/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import marytts.signalproc.display.CursorDisplayer;
import marytts.signalproc.display.CursorEvent;
import marytts.signalproc.display.CursorListener;
import marytts.signalproc.display.CursorSource;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.string.PrintfFormat;

public class FunctionGraphCustom
extends FunctionGraph {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    public static final int DRAW_LINE = 1;
    public static final int DRAW_DOTS = 2;
    public static final int DRAW_LINEWITHDOTS = 3;
    public static final int DRAW_HISTOGRAM = 4;
    public static final int DOT_FULLCIRCLE = 1;
    public static final int DOT_FULLSQUARE = 2;
    public static final int DOT_FULLDIAMOND = 3;
    public static final int DOT_EMPTYCIRCLE = 11;
    public static final int DOT_EMPTYSQUARE = 12;
    public static final int DOT_EMPTYDIAMOND = 13;
    protected int paddingLeft = 40;
    protected int paddingRight = 10;
    protected int paddingTop = 10;
    protected int paddingBottom = 40;
    protected double x0;
    protected double xStep;
    protected List<double[]> dataseries = new ArrayList<double[]>();
    protected double ymin;
    protected double ymax;
    protected boolean showXAxis = true;
    protected boolean showYAxis = true;
    protected BufferedImage graphImage = null;
    protected Color backgroundColor = Color.WHITE;
    protected Color axisColor = Color.BLACK;
    protected List<Color> graphColor = new ArrayList<Color>();
    protected Color histogramBorderColor = Color.BLACK;
    protected List<Integer> graphStyle = new ArrayList<Integer>();
    protected List<Integer> dotStyle = new ArrayList<Integer>();
    protected int dotSize = 6;
    protected int histogramWidth = 10;
    protected boolean autoYMinMax = true;
    protected DoublePoint positionCursor = new DoublePoint();
    protected DoublePoint rangeCursor = new DoublePoint();
    protected List cursorListeners = new ArrayList();

    protected FunctionGraphCustom() {
    }

    public FunctionGraphCustom(double x0, double xStep, double[] y) {
        this(640, 480, x0, xStep, y);
    }

    public FunctionGraphCustom(int width, int height, double x0, double xStep, double[] y) {
        this.initialise(width, height, x0, xStep, y);
    }

    public void initialise(int width, int height, double newX0, double newXStep, double[] data) {
        this.setPreferredSize(new Dimension(width, height));
        this.setOpaque(true);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    FunctionGraphCustom.this.positionCursor.x = FunctionGraphCustom.this.imageX2X(e.getX() - FunctionGraphCustom.this.paddingLeft);
                    FunctionGraphCustom.this.positionCursor.y = FunctionGraphCustom.this.imageY2Y(FunctionGraphCustom.this.getHeight() - FunctionGraphCustom.this.paddingBottom - e.getY());
                    if (!Double.isNaN(FunctionGraphCustom.this.rangeCursor.x) && FunctionGraphCustom.this.positionCursor.x > FunctionGraphCustom.this.rangeCursor.x) {
                        FunctionGraphCustom.this.rangeCursor.x = Double.NaN;
                    }
                } else if (e.getButton() == 3) {
                    FunctionGraphCustom.this.rangeCursor.x = FunctionGraphCustom.this.imageX2X(e.getX() - FunctionGraphCustom.this.paddingLeft);
                    FunctionGraphCustom.this.rangeCursor.y = FunctionGraphCustom.this.imageY2Y(FunctionGraphCustom.this.getHeight() - FunctionGraphCustom.this.paddingBottom - e.getY());
                    if (FunctionGraphCustom.this.positionCursor.x > FunctionGraphCustom.this.rangeCursor.x) {
                        FunctionGraphCustom.this.rangeCursor.x = Double.NaN;
                    }
                }
                FunctionGraphCustom.this.notifyCursorListeners();
                FunctionGraphCustom.this.requestFocusInWindow();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.updateData(newX0, newXStep, data);
        this.graphColor.add(Color.BLUE);
        this.graphStyle.add(1);
        this.dotStyle.add(1);
    }

    public void updateData(double newX0, double newXStep, double[] data) {
        if (newXStep <= 0.0) {
            throw new IllegalArgumentException("newXStep must be >0");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data");
        }
        this.x0 = newX0;
        this.xStep = newXStep;
        double[] series = new double[data.length];
        System.arraycopy(data, 0, series, 0, data.length);
        while (this.dataseries.size() > 0) {
            this.dataseries.remove(0);
        }
        while (this.graphColor.size() > 1) {
            this.graphColor.remove(1);
        }
        while (this.graphStyle.size() > 1) {
            this.graphStyle.remove(1);
        }
        while (this.dotStyle.size() > 1) {
            this.dotStyle.remove(1);
        }
        this.dataseries.add(0, series);
        if (this.autoYMinMax) {
            this.ymin = Double.NaN;
            this.ymax = Double.NaN;
            for (int i = 0; i < data.length; ++i) {
                if (Double.isNaN(data[i])) continue;
                if (Double.isNaN(this.ymin)) {
                    assert (Double.isNaN(this.ymax));
                    this.ymin = data[i];
                    this.ymax = data[i];
                    continue;
                }
                if (data[i] < this.ymin) {
                    this.ymin = data[i];
                    continue;
                }
                if (!(data[i] > this.ymax)) continue;
                this.ymax = data[i];
            }
            if (this.ymin < 0.0) {
                this.paddingBottom = this.paddingTop;
            }
        }
        this.graphImage = null;
    }

    public void setPrimaryDataSeriesStyle(Color newGraphColor, int newGraphStyle, int newDotStyle) {
        this.graphColor.remove(0);
        this.graphColor.add(0, newGraphColor);
        this.graphStyle.remove(0);
        this.graphStyle.add(0, newGraphStyle);
        this.dotStyle.remove(0);
        this.dotStyle.add(0, newDotStyle);
    }

    public void setYMinMax(double theYMin, double theYMax) {
        this.autoYMinMax = false;
        this.ymin = theYMin;
        this.ymax = theYMax;
        if (this.ymin < 0.0) {
            this.paddingBottom = this.paddingTop;
        }
    }

    public void addDataSeries(double[] data, Color newGraphColor, int newGraphStyle, int newDotStyle) {
        if (data == null) {
            throw new NullPointerException("Cannot add null data");
        }
        if (this.dataseries.get(0).length != data.length) {
            throw new IllegalArgumentException("Can only add data of the exact same length as the original data series; len(orig)=" + this.dataseries.get(0).length + ", len(data)=" + data.length);
        }
        double[] series = new double[data.length];
        System.arraycopy(data, 0, series, 0, data.length);
        this.dataseries.add(series);
        this.graphColor.add(newGraphColor);
        this.graphStyle.add(newGraphStyle);
        this.dotStyle.add(newDotStyle);
        if (this.autoYMinMax) {
            for (int i = 0; i < data.length; ++i) {
                if (Double.isNaN(data[i])) continue;
                if (Double.isNaN(this.ymin)) {
                    assert (Double.isNaN(this.ymax));
                    this.ymin = data[i];
                    this.ymax = data[i];
                    continue;
                }
                if (data[i] < this.ymin) {
                    this.ymin = data[i];
                    continue;
                }
                if (!(data[i] > this.ymax)) continue;
                this.ymax = data[i];
            }
            if (this.ymin < 0.0) {
                this.paddingBottom = this.paddingTop;
            }
        }
        this.graphImage = null;
    }

    public double getZoomX() {
        double[] data = this.dataseries.get(0);
        double zoom = ((double)this.getPreferredSize().width - (double)this.paddingLeft - (double)this.paddingRight) / (double)data.length;
        return zoom;
    }

    public void setZoomX(double factor) {
        Rectangle r = this.getVisibleRect();
        int oldWidth = this.getPreferredSize().width;
        double[] data = this.dataseries.get(0);
        int newWidth = (int)((double)data.length * factor) + this.paddingLeft + this.paddingRight;
        if (this.isVisible()) {
            this.setVisible(false);
            this.setPreferredSize(new Dimension(newWidth, this.getPreferredSize().height));
            if (r.x != 0) {
                Rectangle newVisibleRect = new Rectangle((r.x + r.width / 2 - this.paddingLeft) * newWidth / oldWidth - r.width / 2 + this.paddingLeft, r.y, r.width, r.height);
                this.scrollRectToVisible(newVisibleRect);
            }
            this.setVisible(true);
        } else {
            this.setPreferredSize(new Dimension(newWidth, this.getPreferredSize().height));
            this.createGraphImage();
        }
        this.getZoomX();
    }

    protected void createGraphImage() {
        this.graphImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        if (this.graphImage == null) {
            throw new NullPointerException("Cannot create image for drawing graph");
        }
        Graphics2D g = this.graphImage.createGraphics();
        double width = this.getWidth();
        double height = this.getHeight();
        int image_fromX = 0;
        int image_toX = (int)width;
        g.setBackground(this.backgroundColor);
        g.clearRect(0, 0, (int)width, (int)height);
        g.setFont(new Font("Courier", 0, 10));
        int startX = this.paddingLeft;
        int startY = (int)height - this.paddingBottom;
        width -= (double)(this.paddingLeft + this.paddingRight);
        height -= (double)(this.paddingTop + this.paddingBottom);
        if (image_fromX < startX) {
            image_fromX = startX;
        }
        if ((double)image_toX > (double)startX + width) {
            image_toX = (int)((double)startX + width);
        }
        int image_y_origin = this.getYRange() == 0.0 ? startY : startY - (int)(-this.ymin / this.getYRange() * height);
        int image_x_origin = startX + (int)(-this.x0 / this.getXRange() * width);
        if (this.getYRange() > 0.0) {
            for (int s = 0; s < this.dataseries.size(); ++s) {
                this.drawData(g, image_fromX - startX, image_toX - startX, startX, image_y_origin, startY, (int)height, this.dataseries.get(s), this.graphColor.get(s), this.graphStyle.get(s), this.dotStyle.get(s));
            }
        }
        if (this.showXAxis) {
            if (startY >= image_y_origin && (double)image_y_origin >= (double)startY - height) {
                this.drawXAxis(g, width, startX, startY, image_y_origin);
            } else {
                this.drawXAxis(g, width, startX, startY, startY);
            }
        }
        if (this.showYAxis) {
            if (image_fromX <= image_x_origin && image_x_origin <= image_toX) {
                this.drawYAxis(g, height, startX, startY, image_x_origin);
            } else {
                this.drawYAxis(g, height, startX, startY, startX);
            }
        }
    }

    protected void drawData(Graphics2D g, int image_fromX, int image_toX, int image_refX, int image_refY, int startY, int image_height, double[] data, Color currentGraphColor, int currentGraphStyle, int currentDotStyle) {
        int index_toX;
        int index_fromX = this.imageX2indexX(image_fromX);
        if (index_fromX < 0) {
            index_fromX = 0;
        }
        if ((index_toX = this.imageX2indexX(image_toX)) < data.length) {
            index_toX += 20;
        }
        if (index_toX > data.length) {
            index_toX = data.length;
        }
        double xo = 0.0;
        double yo = 0.0;
        double xp = 0.0;
        double yp = 0.0;
        g.setColor(currentGraphColor);
        for (int i = index_fromX; i < index_toX; ++i) {
            if (Double.isNaN(data[i])) continue;
            xp = this.indexX2imageX(i);
            yp = this.y2imageY(data[i]);
            if (currentGraphStyle == 1 || currentGraphStyle == 3) {
                g.drawLine(image_refX + (int)xo, image_refY - (int)yo, image_refX + (int)xp, image_refY - (int)yp);
            }
            if (currentGraphStyle == 2 || currentGraphStyle == 3) {
                this.drawDot(g, image_refX + (int)xp, image_refY - (int)yp, currentDotStyle);
            }
            if (currentGraphStyle == 4) {
                int histHeight;
                int topY = image_refY;
                if (yp > 0.0) {
                    topY = image_refY - (int)yp;
                }
                if (topY + (histHeight = (int)Math.abs(yp)) > startY) {
                    histHeight = startY - topY;
                }
                g.setColor(currentGraphColor);
                g.fillRect(image_refX + (int)xp - this.histogramWidth / 2, topY, this.histogramWidth, histHeight);
                g.setColor(this.histogramBorderColor);
                g.drawRect(image_refX + (int)xp - this.histogramWidth / 2, topY, this.histogramWidth, histHeight);
            }
            xo = xp;
            yo = yp;
        }
    }

    protected void drawDot(Graphics2D g, int x, int y, int currentDotStyle) {
        switch (currentDotStyle) {
            case 1: {
                g.fillOval(x - this.dotSize / 2, y - this.dotSize / 2, this.dotSize, this.dotSize);
                break;
            }
            case 2: {
                g.fillRect(x - this.dotSize / 2, y - this.dotSize / 2, this.dotSize, this.dotSize);
                break;
            }
            case 3: {
                g.fillPolygon(new int[]{x - this.dotSize / 2, x, x + this.dotSize / 2, x}, new int[]{y, y - this.dotSize / 2, y, y + this.dotSize / 2}, 4);
                break;
            }
            case 11: {
                g.drawOval(x - this.dotSize / 2, y - this.dotSize / 2, this.dotSize, this.dotSize);
                break;
            }
            case 12: {
                g.drawRect(x - this.dotSize / 2, y - this.dotSize / 2, this.dotSize, this.dotSize);
                break;
            }
            case 13: {
                g.drawPolygon(new int[]{x - this.dotSize / 2, x, x + this.dotSize / 2, x}, new int[]{y, y - this.dotSize / 2, y, y + this.dotSize / 2}, 4);
                break;
            }
        }
    }

    protected void drawYAxis(Graphics2D g, double height, int startX, int startY, int image_x_origin) {
        g.setColor(this.axisColor);
        double yRange = this.getYRange();
        g.drawLine(image_x_origin, startY, image_x_origin, startY - (int)height);
        if (yRange == 0.0) {
            return;
        }
        int unitOrder = (int)Math.floor(Math.log(yRange / 5.0) / Math.log(10.0));
        double unitDistance = Math.pow(10.0, unitOrder);
        double image_unitDistance = unitDistance / yRange * height;
        if (image_unitDistance < 20.0) {
            unitDistance *= 5.0;
        } else if (image_unitDistance < 50.0) {
            unitDistance *= 2.0;
        }
        double unitStart = this.ymin;
        double modulo = this.ymin % unitDistance;
        if (modulo != 0.0) {
            unitStart = modulo > 0.0 ? (unitStart += unitDistance - modulo) : (unitStart += Math.abs(modulo));
        }
        PrintfFormat labelFormat = unitOrder > 0 ? new PrintfFormat("%.0f") : new PrintfFormat("%." + -unitOrder + "f");
        boolean intLabels = (int)unitDistance == (int)Math.ceil(unitDistance);
        for (double i = unitStart; i < this.ymax; i += unitDistance) {
            double yunit = (i - this.ymin) / yRange * height;
            g.drawLine(image_x_origin + 5, startY - (int)yunit, image_x_origin - 5, startY - (int)yunit);
            g.drawString(labelFormat.sprintf(i), image_x_origin - 30, startY - (int)yunit + 5);
        }
    }

    protected void drawXAxis(Graphics2D g, double width, int startX, int startY, int image_y_origin) {
        g.setColor(this.axisColor);
        double xRange = this.getXRange();
        g.drawLine(startX, image_y_origin, startX + (int)width, image_y_origin);
        int nUnits = (int)width / 50;
        int unitOrder = (int)Math.floor(Math.log(xRange / (double)nUnits) / Math.log(10.0));
        double unitDistance = Math.pow(10.0, unitOrder);
        double image_unitDistance = unitDistance / xRange * width;
        if (image_unitDistance < 20.0) {
            unitDistance *= 5.0;
        } else if (image_unitDistance < 50.0) {
            unitDistance *= 2.0;
        }
        double unitStart = this.x0;
        double modulo = this.x0 % unitDistance;
        if (modulo != 0.0) {
            unitStart = modulo > 0.0 ? (unitStart += unitDistance - modulo) : (unitStart += Math.abs(modulo));
        }
        PrintfFormat labelFormat = unitOrder > 0 ? new PrintfFormat("%.0f") : new PrintfFormat("%." + -unitOrder + "f");
        for (double i = unitStart; i < this.x0 + xRange; i += unitDistance) {
            double xunit = (i - this.x0) / xRange * width;
            g.drawLine(startX + (int)xunit, image_y_origin + 5, startX + (int)xunit, image_y_origin - 5);
            g.drawString(labelFormat.sprintf(i), startX + (int)xunit - 10, image_y_origin + 20);
        }
    }

    public void paintComponent(Graphics gr) {
        if (this.graphImage == null || this.getWidth() != this.graphImage.getWidth() || this.getHeight() != this.graphImage.getHeight()) {
            this.createGraphImage();
        }
        Graphics2D g = (Graphics2D)gr;
        g.drawImage(this.graphImage, null, null);
    }

    protected int imageX2indexX(int imageX) {
        if (this.dataseries.isEmpty()) {
            return 0;
        }
        double[] data = this.dataseries.get(0);
        if (data == null) {
            return 0;
        }
        double xScaleFactor = ((double)this.getWidth() - (double)this.paddingLeft - (double)this.paddingRight) / (double)data.length;
        return (int)((double)imageX / xScaleFactor);
    }

    protected double imageX2X(int imageX) {
        double[] data = this.dataseries.get(0);
        double xScaleFactor = ((double)this.getWidth() - (double)this.paddingLeft - (double)this.paddingRight) / ((double)data.length * this.xStep);
        return this.x0 + (double)imageX / xScaleFactor;
    }

    protected int indexX2imageX(int indexX) {
        if (this.dataseries.isEmpty()) {
            return 0;
        }
        double[] data = this.dataseries.get(0);
        if (data == null) {
            return 0;
        }
        double xScaleFactor = ((double)this.getWidth() - (double)this.paddingLeft - (double)this.paddingRight) / (double)data.length;
        return (int)((double)indexX * xScaleFactor);
    }

    protected int X2imageX(double x) {
        double[] data = this.dataseries.get(0);
        double xScaleFactor = ((double)this.getWidth() - (double)this.paddingLeft - (double)this.paddingRight) / ((double)data.length * this.xStep);
        return (int)((x - this.x0) * xScaleFactor);
    }

    protected int X2indexX(double x) {
        return (int)((x - this.x0) / this.xStep);
    }

    protected double imageY2Y(int imageY) {
        double yScaleFactor = ((double)this.getHeight() - (double)this.paddingTop - (double)this.paddingBottom) / this.getYRange();
        return (double)imageY / yScaleFactor;
    }

    protected int y2imageY(double y) {
        double yScaleFactor = ((double)this.getHeight() - (double)this.paddingTop - (double)this.paddingBottom) / this.getYRange();
        return (int)(y * yScaleFactor);
    }

    protected double getYRange() {
        double yRange = this.ymax - this.ymin;
        if (Double.isNaN(yRange)) {
            yRange = 0.0;
        }
        return yRange;
    }

    protected double getXRange() {
        double[] data = this.dataseries.get(0);
        double xRange = (double)data.length * this.xStep;
        return xRange;
    }

    public CursorDisplayer.CursorLine getPositionCursor() {
        if (Double.isNaN(this.positionCursor.x)) {
            return null;
        }
        return new CursorDisplayer.CursorLine((Component)((Object)this), this.paddingLeft + this.X2imageX(this.positionCursor.x), this.paddingTop, this.getHeight() - this.paddingBottom);
    }

    public CursorDisplayer.CursorLine getRangeCursor() {
        if (Double.isNaN(this.rangeCursor.x)) {
            return null;
        }
        int imageX = this.X2imageX(this.rangeCursor.x);
        return new CursorDisplayer.CursorLine((Component)((Object)this), this.paddingLeft + this.X2imageX(this.rangeCursor.x), this.paddingTop, this.getHeight() - this.paddingBottom, Color.YELLOW);
    }

    public CursorDisplayer.Label getValueLabel() {
        if (Double.isNaN(this.positionCursor.x)) {
            return null;
        }
        int imageX = this.X2imageX(this.positionCursor.x) + 10;
        int imageY = this.paddingTop + 10;
        return new CursorDisplayer.Label((Component)((Object)this), this.getLabel(this.positionCursor.x, this.positionCursor.y), imageX, imageY);
    }

    public void addCursorListener(CursorListener l) {
        this.cursorListeners.add(l);
    }

    public CursorListener[] getCursorListeners() {
        return this.cursorListeners.toArray(new CursorListener[0]);
    }

    public boolean removeCursorListener(CursorListener l) {
        return this.cursorListeners.remove(l);
    }

    protected void notifyCursorListeners() {
        for (CursorListener l : this.cursorListeners) {
            l.updateCursorPosition(new CursorEvent((FunctionGraph)this));
        }
    }

    public void updateCursorPosition(CursorEvent e) {
        FunctionGraph source = e.getSource();
        this.positionCursor.x = source.positionCursor.x;
        this.rangeCursor.x = source.rangeCursor.x;
    }

    public JFrame showInJFrame(String title, boolean allowZoom, boolean exitOnClose) {
        return this.showInJFrame(title, 640, 530, allowZoom, true, exitOnClose);
    }

    public JFrame showInJFrame(String title, boolean allowZoom, boolean showControls, boolean exitOnClose) {
        return this.showInJFrame(title, 640, 530, allowZoom, showControls, exitOnClose);
    }

    public JFrame showInJFrame(String title, int width, int height, boolean allowZoom, boolean exitOnClose) {
        return this.showInJFrame(title, width, height, allowZoom, true, exitOnClose);
    }

    public JFrame showInJFrame(String title, int width, int height, boolean allowZoom, boolean showControls, boolean exitOnClose) {
        JFrame main = new JFrame(title);
        int mainWidth = width;
        JScrollPane scroll = new JScrollPane((Component)((Object)this));
        scroll.setHorizontalScrollBarPolicy(30);
        main.getContentPane().add((Component)scroll, "Center");
        CursorDisplayer glass = new CursorDisplayer();
        main.setGlassPane((Component)glass);
        glass.setVisible(true);
        glass.addCursorSource((CursorSource)this);
        this.addCursorListener((CursorListener)glass);
        if (allowZoom) {
            JPanel controls;
            JPanel zoomPanel = new JPanel();
            zoomPanel.setLayout(new BoxLayout(zoomPanel, 1));
            main.getContentPane().add((Component)zoomPanel, "West");
            zoomPanel.add(Box.createVerticalGlue());
            JButton zoomIn = new JButton("Zoom In");
            zoomIn.setAlignmentX(0.5f);
            zoomIn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FunctionGraphCustom.this.setZoomX(FunctionGraphCustom.this.getZoomX() * 2.0);
                    FunctionGraphCustom.this.requestFocus();
                }
            });
            zoomPanel.add(zoomIn);
            JButton zoomOut = new JButton("Zoom Out");
            zoomOut.setAlignmentX(0.5f);
            zoomOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FunctionGraphCustom.this.setZoomX(FunctionGraphCustom.this.getZoomX() * 0.5);
                    FunctionGraphCustom.this.requestFocus();
                }
            });
            zoomPanel.add(zoomOut);
            if (showControls && (controls = this.getControls()) != null) {
                zoomPanel.add(Box.createVerticalGlue());
                controls.setAlignmentX(0.5f);
                zoomPanel.add(controls);
            }
            mainWidth += zoomPanel.getPreferredSize().width + 30;
            zoomPanel.add(Box.createVerticalGlue());
        }
        main.setSize(mainWidth, height);
        if (exitOnClose) {
            main.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        main.setVisible(true);
        this.requestFocus();
        return main;
    }

    protected JPanel getControls() {
        return null;
    }

    protected String getLabel(double x, double y) {
        int precisionY;
        int precisionX;
        int pixelPrecisionX = 2;
        if (this.graphImage != null) {
            pixelPrecisionX = (int)(Math.log((double)this.graphImage.getWidth() / this.getXRange()) / Math.log(10.0));
        }
        if ((precisionX = -((int)(Math.log(this.getXRange()) / Math.log(10.0))) + pixelPrecisionX) < 0) {
            precisionX = 0;
        }
        if ((precisionY = -((int)(Math.log(this.getYRange()) / Math.log(10.0))) + 2) < 0) {
            precisionY = 0;
        }
        int indexX = this.X2indexX(x);
        double[] data = this.dataseries.get(0);
        return "f(" + new PrintfFormat("%." + precisionX + "f").sprintf(x) + ")=" + new PrintfFormat("%." + precisionY + "f").sprintf(data[indexX]);
    }

    public class DoublePoint {
        double x;
        double y;

        public DoublePoint() {
            this(Double.NaN, Double.NaN);
        }

        public DoublePoint(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

