/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.signals.PeriodicityDetector;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.signals.TimeSeries;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSADataset;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAWorkflow;
import org.gcube.dataanalysis.ecoengine.utils.AggregationFunctions;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.hibernate.SessionFactory;

public class TimeSeriesAnalysis
extends StandardLocalExternalAlgorithm {
    private static String timeSeriesTable = "TimeSeriesTable";
    private static String valuesColumn = "ValueColum";
    private static String timeColumn = "TimeColum";
    private static String frequencyResolution = "FrequencyResolution";
    private static String aggregationFunction = "AggregationFunction";
    private static String SSAAnalysisWindowSamples = "SSA_Window_in_Samples";
    private static String SSAEigenvaluesThreshold = "SSA_EigenvaluesThreshold";
    private static String SSAPointsToForecast = "SSA_Points_to_Forecast";
    private Image signalImg = null;
    private Image uniformSignalImg = null;
    private Image uniformSignalSamplesImg = null;
    private Image spectrogramImg = null;
    private Image forecastsignalImg = null;
    private Image eigenValuesImg = null;
    private File outputfilename = null;
    private static boolean display = false;
    private static int maxpoints = 10000;

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getDescription() {
        return "An algorithms applying signal processing to a non uniform time series. A maximum of " + maxpoints + " distinct points in time is allowed to be processed. The process uniformly samples the series, then extracts hidden periodicities and signal properties. The sampling period is the shortest time difference between two points. Finally, by using Caterpillar-SSA the algorithm forecasts the Time Series. The output shows the detected periodicity, the forecasted signal and the spectrogram.";
    }

    @Override
    protected void process() throws Exception {
        SessionFactory dbconnection = null;
        this.status = 0.0f;
        try {
            dbconnection = DatabaseUtils.initDBSession(this.config);
            String tablename = this.config.getParam(timeSeriesTable);
            String valuescolum = this.config.getParam(valuesColumn);
            String timecolumn = this.config.getParam(timeColumn);
            String aggregationFunc = this.config.getParam(aggregationFunction);
            String frequencyRes = this.config.getParam(frequencyResolution);
            int windowLength = Integer.parseInt(this.config.getParam(SSAAnalysisWindowSamples));
            float eigenvaluespercthr = Float.parseFloat(this.config.getParam(SSAEigenvaluesThreshold));
            int pointsToReconstruct = Integer.parseInt(this.config.getParam(SSAPointsToForecast));
            float frequencyResDouble = 1.0f;
            if (timecolumn == null) {
                timecolumn = "time";
            }
            if (aggregationFunc == null) {
                aggregationFunc = "SUM";
            }
            if (frequencyRes != null) {
                try {
                    frequencyResDouble = Float.parseFloat(frequencyRes);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Table Name: " + tablename));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Time Column: " + timecolumn));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Values Column: " + valuescolum));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Aggregation: " + aggregationFunc));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Frequency Resolution: " + frequencyRes));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->SSA Window Samples: " + windowLength));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->SSA Eigenvalues threshold: " + eigenvaluespercthr));
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->SSA Points to Reconstruct: " + pointsToReconstruct));
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Extracting Points...");
            String query = "select * from (select " + aggregationFunc + "(" + valuescolum + ")," + timecolumn + " from " + tablename + " group by " + timecolumn + ") as a";
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Query to execute: " + query));
            List<Object> results = DatabaseFactory.executeSQLQuery(query, dbconnection);
            this.status = 10.0f;
            if (results == null || results.size() == 0) {
                throw new Exception("Error in retrieving values from the table: no time series found");
            }
            if (results.size() > maxpoints) {
                throw new Exception("Too long Time Series: a maximum of distinct " + maxpoints + " in time is allowed");
            }
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Points Extracted!");
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Building signal");
            ArrayList<Tuple<String>> signal = new ArrayList<Tuple<String>>();
            int sizesignal = 0;
            for (Object row : results) {
                Object[] srow = (Object[])row;
                String value = "" + srow[0];
                String time = "" + srow[1];
                signal.add(new Tuple<String>(time, value));
                ++sizesignal;
            }
            this.status = 20.0f;
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Signal built with success. Size: " + sizesignal));
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Building Time Series");
            TimeSeries ts = TimeSeries.buildFromSignal(signal, this.config);
            String timepattern = ts.getTimepattern();
            String chartpattern = "HH:mm:ss MM-dd-yy";
            if (timepattern.equals("s")) {
                chartpattern = "HH:mm:ss:SS";
            }
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Uniformly sampling the signal");
            if (display) {
                SignalProcessing.displaySignalWithTime(ts.getValues(), ts.getTime(), "Time Series", chartpattern);
            }
            this.signalImg = SignalProcessing.renderSignalWithTime(ts.getValues(), ts.getTime(), "Original Time Series", chartpattern);
            ts.convertToUniformSignal(0.0);
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Uniform sampling finished");
            this.status = 30.0f;
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Detecting periodicity");
            PeriodicityDetector pd = new PeriodicityDetector();
            double F = pd.detectFrequency(ts.getValues(), 1, 0.01f, 0.5f, frequencyResDouble, display);
            this.outputParameters.put("Detected Frequency (samples^-1)", "" + MathFunctions.roundDecimal(F, 2));
            this.outputParameters.put("Indecision on Frequency", "[" + MathFunctions.roundDecimal(pd.lowermeanF, 2) + " , " + MathFunctions.roundDecimal(pd.uppermeanF, 2) + "]");
            this.outputParameters.put("Average detected Period (samples)", "" + MathFunctions.roundDecimal(pd.meanPeriod, 2));
            this.outputParameters.put("Indecision on Average Period", "[" + MathFunctions.roundDecimal(pd.lowermeanPeriod, 2) + " , " + MathFunctions.roundDecimal(pd.uppermeanPeriod, 2) + "]");
            this.outputParameters.put("Samples range in which periodicity was detected", "from " + pd.startPeriodSampleIndex + "  to " + pd.endPeriodSampleIndex);
            this.outputParameters.put("Period Strength with interpretation", "" + MathFunctions.roundDecimal(pd.periodicityStrength, 2) + " (" + pd.getPeriodicityStregthInterpretation() + ")");
            this.outputParameters.put("Range of frequencies (in samples^-1) represented in the Spectrogram:", "[" + MathFunctions.roundDecimal(pd.minFrequency, 2) + " , " + MathFunctions.roundDecimal(pd.maxFrequency, 2) + "]");
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Periodicity Detected!");
            this.status = 60.0f;
            System.gc();
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Executing SSA analysis");
            ArrayList<Double> values = new ArrayList<Double>();
            for (double v : ts.getValues()) {
                values.add(v);
            }
            SSADataset ssa = SSAWorkflow.applyCompleteWorkflow(values, windowLength, eigenvaluespercthr, pointsToReconstruct, false);
            Date[] newtimes = ts.extendTime(pointsToReconstruct);
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->SSA analysis completed");
            this.status = 70.0f;
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Rendering Images");
            this.uniformSignalImg = SignalProcessing.renderSignalWithTime(ts.getValues(), ts.getTime(), "Uniformly Sampled Time Series", chartpattern);
            if (this.uniformSignalImg == null) {
                this.outputParameters.put("Note:", "The charts for uniformly sampled and forecasted signals contain too many points and will not be displayed. The values will be only reported in the output file.");
            } else {
                this.outputParameters.put("Note:", "Details about the values are reported in the output file.");
            }
            this.uniformSignalSamplesImg = SignalProcessing.renderSignalWithGenericTime(ts.getValues(), 0.0f, 1.0f, "Uniformly Sampled Time Series in Samples");
            this.spectrogramImg = SignalProcessing.renderSignalSpectrogram2(pd.currentspectrum);
            this.forecastsignalImg = SignalProcessing.renderSignalWithTime(ssa.getForecastSignal(), newtimes, "Forecasted Time Series", chartpattern);
            double[] eigenValues = new double[ssa.getPercentList().size()];
            for (int i = 0; i < eigenValues.length; ++i) {
                eigenValues[i] = ssa.getPercentList().get(i);
            }
            this.eigenValuesImg = SignalProcessing.renderSignalWithGenericTime(eigenValues, 0.0f, 1.0f, "SSA Eigenvalues");
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Images Rendered");
            System.gc();
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Producing Files");
            this.outputfilename = new File(this.config.getPersistencePath(), valuescolum + "_SignalProcessing.csv");
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.outputfilename));
            bw.write("Uniformly Sampled Time Series,Time Line,Forecasted Time Series,SSA Eigenvalues\n");
            int[] lengthsVector = new int[]{ts.getValues().length, newtimes.length, ssa.getForecastSignal().length, eigenValues.length};
            int maxLen = Operations.getMax(lengthsVector);
            for (int i = 0; i < maxLen; ++i) {
                if (i < ts.getValues().length) {
                    bw.write("" + ts.getValues()[i] + ",");
                } else {
                    bw.write(",");
                }
                if (i < newtimes.length) {
                    bw.write("" + newtimes[i] + ",");
                } else {
                    bw.write(",");
                }
                if (i < ssa.getForecastSignal().length) {
                    bw.write("" + ssa.getForecastSignal()[i] + ",");
                } else {
                    bw.write(",");
                }
                if (i < eigenValues.length) {
                    bw.write("" + eigenValues[i] + ",");
                } else {
                    bw.write(",");
                }
                bw.write("\n");
            }
            bw.close();
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Files Produced");
            if (display) {
                SignalProcessing.displaySignalWithTime(ts.getValues(), ts.getTime(), "Uniformly Sampled Time Series", chartpattern);
                SignalProcessing.displaySignalWithGenericTime(ts.getValues(), 0.0f, 1.0f, "Uniformly Sampled Time Series in Samples");
                SignalProcessing.displaySignalWithTime(ssa.getForecastSignal(), newtimes, "Forecasted Time Series", chartpattern);
                SignalProcessing.displaySignalWithGenericTime(eigenValues, 0.0f, 1.0f, "SSA Eigenvalues");
            }
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->" + this.outputParameters));
            AnalysisLogger.getLogger().debug((Object)"TimeSeriesAnalysis->Computation has finished");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e.getLocalizedMessage());
        }
        finally {
            if (dbconnection != null) {
                dbconnection.close();
            }
        }
    }

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.TIMESERIES);
        InputTable p = new InputTable(templates, timeSeriesTable, "The table containing the time series", "timeseries");
        this.inputs.add(p);
        ColumnType p1 = new ColumnType(timeSeriesTable, valuesColumn, "The column containing the values of the time series", "values", false);
        this.inputs.add(p1);
        this.addDoubleInput(frequencyResolution, "The precision in detecting the period. The lower this number the less the number of points in the Spectrogram (higher number of samples used at each step). Reducing this, the spectrogram will be finer and sharper, but you should tune it. Too many samples will make the Spectrogram noisy.", "1");
        this.addEnumerateInput(AggregationFunctions.values(), aggregationFunction, "Function to apply to samples with the same time instant", AggregationFunctions.SUM.name());
        this.addIntegerInput(SSAAnalysisWindowSamples, "The number of samples in the produced uniformly sampled signal, to use in the SSA algorithm. This number should identify a portion of the signal long enough to make the system guess the nature of the trend", "20");
        this.addDoubleInput(SSAEigenvaluesThreshold, "The threshold under which an SSA eigenvalue will be ignored, along with its eigenvector, for the reconstruction of the signal", "0.7");
        this.addIntegerInput(SSAPointsToForecast, "The number of points to forecast over the original length of the time series", "10");
        DatabaseType.addDefaultDBPars(this.inputs);
    }

    @Override
    public StatisticalType getOutput() {
        LinkedHashMap<String, StatisticalType> outMap = PrimitiveType.stringMap2StatisticalMap(this.outputParameters);
        LinkedHashMap<String, Image> producedImages = new LinkedHashMap<String, Image>();
        if (this.signalImg != null) {
            producedImages.put("Original Time Series", this.signalImg);
        }
        if (this.uniformSignalImg != null) {
            producedImages.put("Uniformly Sampled Time Series", this.uniformSignalImg);
        }
        if (this.uniformSignalSamplesImg != null) {
            producedImages.put("Uniformly Sampled Time Series in Samples", this.uniformSignalSamplesImg);
        }
        if (this.forecastsignalImg != null) {
            producedImages.put("Forecasted Time Series", this.forecastsignalImg);
        }
        if (this.spectrogramImg != null) {
            producedImages.put("Spectrogram of the Uniformly Sampled Time Series", this.spectrogramImg);
        }
        if (this.eigenValuesImg != null) {
            producedImages.put("SSA Eigenvalues", this.eigenValuesImg);
        }
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "Time Series Report", "Charts reporting the Time Series Analysis");
        outMap.put("Images", images);
        if (this.outputfilename != null) {
            PrimitiveType file = new PrimitiveType(File.class.getName(), this.outputfilename, PrimitiveTypes.FILE, "AnalysisReport", "AnalysisReport");
            outMap.put("Analysis Report", file);
        }
        PrimitiveType p = new PrimitiveType(LinkedHashMap.class.getName(), outMap, PrimitiveTypes.MAP, "Output", "");
        return p;
    }

    @Override
    public void shutdown() {
    }
}

