/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.spatialdistributions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionGeneric;

public class DummyAlgorithm
implements SpatialProbabilityDistributionGeneric {
    List<String> randomElements;
    String persistence;
    private String filename;
    static String persistedFilePrefix = "dummyfile";

    public static void main(String[] args) {
        String s = DummyAlgorithm.toString(330.6499f);
        System.out.println(s);
        System.out.println(DummyAlgorithm.fromString(s));
    }

    private static String toString(float number) {
        String s = "" + number;
        int m = s.length();
        String res = "";
        for (int i = 0; i < m; ++i) {
            int k = 0;
            k = s.charAt(i) == '.' ? s.charAt(i) : Integer.parseInt("" + s.charAt(i));
            res = res + (char)(k + 65);
        }
        return res;
    }

    private static float fromString(String alphanumeric) {
        int m = alphanumeric.length();
        String res = "";
        for (int i = 0; i < m; ++i) {
            int k = alphanumeric.charAt(i) - 65;
            res = k == 46 ? res + "." : res + k;
        }
        return Float.parseFloat(res);
    }

    @Override
    public void init(AlgorithmConfiguration config) {
        AnalysisLogger.getLogger().trace((Object)"Dummy INIT");
        this.randomElements = new ArrayList<String>();
        for (int i = 0; i < 170000; ++i) {
            this.randomElements.add("" + 100.0 * Math.random());
        }
        this.persistence = config.getPersistencePath();
    }

    @Override
    public String getMainInfoType() {
        return String.class.getName();
    }

    @Override
    public String getGeographicalInfoType() {
        return String.class.getName();
    }

    @Override
    public List<Object> getMainInfoObjects() {
        ArrayList<Object> randomElements = new ArrayList<Object>();
        for (int i = 0; i < 20; ++i) {
            randomElements.add(DummyAlgorithm.toString((float)(100.0 * Math.random())));
        }
        return randomElements;
    }

    @Override
    public List<Object> getGeographicalInfoObjects() {
        AnalysisLogger.getLogger().trace((Object)"Dummy TAKING RANDOMS");
        ArrayList<Object> randomElements = new ArrayList<Object>();
        for (int i = 0; i < 170000; ++i) {
            randomElements.add("" + 100.0 * Math.random());
        }
        return randomElements;
    }

    @Override
    public float calcProb(Object mainInfo, Object area) {
        Float f1 = Float.valueOf(DummyAlgorithm.fromString((String)mainInfo));
        Float f2 = Float.valueOf((String)area);
        return 100.0f * f1.floatValue() * f2.floatValue();
    }

    @Override
    public void singleStepPreprocess(Object mainInfo, Object area) {
        AnalysisLogger.getLogger().trace((Object)"Dummy SINGLE PREPROCESSING Step");
    }

    @Override
    public void singleStepPostprocess(Object mainInfo, Object allAreasInformation) {
        AnalysisLogger.getLogger().trace((Object)"Dummy SINGLE POSTPROCESSING Step");
    }

    @Override
    public void postProcess() {
        AnalysisLogger.getLogger().trace((Object)"Dummy POSTPROCESS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDistribution(Map<Object, Map<Object, Float>> distribution) {
        ObjectOutputStream outputStream = null;
        try {
            int ysize = 0;
            Iterator<Object> i$ = distribution.keySet().iterator();
            if (i$.hasNext()) {
                Object s = i$.next();
                ysize = distribution.get(s).size();
            }
            AnalysisLogger.getLogger().debug((Object)("Dummy overall dimension of the distribution: " + distribution.size() + " X " + ysize));
            this.filename = this.persistence + persistedFilePrefix + UUID.randomUUID();
            AnalysisLogger.getLogger().debug((Object)("Dummy Storing in " + this.filename));
            outputStream = new ObjectOutputStream(new FileOutputStream(this.persistence + persistedFilePrefix + "_" + UUID.randomUUID()));
            outputStream.writeObject(distribution);
            AnalysisLogger.getLogger().debug((Object)"Dummy Stored");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public float getInternalStatus() {
        return 100.0f;
    }

    @Override
    public String getMainInfoID(Object mainInfo) {
        return (String)mainInfo;
    }

    @Override
    public String getGeographicalID(Object geoInfo) {
        return (String)geoInfo;
    }

    @Override
    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_GEOINFO};
        return p;
    }

    @Override
    public String getName() {
        return "DUMMY";
    }

    @Override
    public String getDescription() {
        return "a testing algorithm for statistical service work performances - calculates a random probability distribution and stores on a file";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        return null;
    }

    @Override
    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(File.class.getName(), new File(this.filename), PrimitiveTypes.FILE, "DummyDistribution", "Dummy Distribution File");
        return p;
    }
}

