/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.abstracts;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import java.util.LinkedList;

public abstract class SamplesTable {
    public double minY = 0.0;
    public double maxY = 0.0;
    public double minX = 0.0;
    public double maxX = 0.0;

    public ExampleSet generateExampleSet() {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int a = 0;
        while (a < this.getNumOfAttributes()) {
            attributes.add(AttributeFactory.createAttribute((String)("att" + a), (int)4));
            ++a;
        }
        Attribute label = AttributeFactory.createAttribute((String)"label", (int)1);
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        int d = 0;
        while (d < this.getNumOfDataRows()) {
            double[] data = new double[attributes.size()];
            int a2 = 0;
            while (a2 < this.getNumOfAttributes()) {
                data[a2] = this.getValue(d, a2);
                ++a2;
            }
            data[data.length - 1] = label.getMapping().mapString(this.getClassification(d));
            table.addDataRow((DataRow)new DoubleArrayDataRow(data));
            ++d;
        }
        ExampleSet exampleSet = table.createExampleSet(label);
        return exampleSet;
    }

    public void generateSampleTable(ExampleSet es) {
        MemoryExampleTable met = (MemoryExampleTable)es.getExampleTable();
        int numofcolumns = met.getAttributeCount();
        int numofrows = met.size();
        int i = 0;
        while (i < numofrows) {
            Attribute labelAtt = met.getAttribute(numofcolumns - 1);
            int index = (int)met.getDataRow(i).get(labelAtt);
            String label = labelAtt.getMapping().mapIndex(index);
            this.addSampleRow(label, 0.0);
            int j = 0;
            while (j < numofcolumns - 1) {
                Attribute att = AttributeFactory.createAttribute((String)("att" + j), (int)4);
                att.setTableIndex(j);
                DoubleArrayDataRow dadr = (DoubleArrayDataRow)met.getDataRow(i);
                double element = dadr.get(att);
                this.addSample(i, j, element);
                ++j;
            }
            ++i;
        }
    }

    public abstract int getNumOfAttributes();

    public abstract int getNumOfDataRows();

    public abstract double getValue(int var1, int var2);

    public abstract String getClassification(int var1);

    public String toString() {
        StringBuffer bs = new StringBuffer();
        bs.append("NUMBER OF ROWS: " + this.getNumOfDataRows() + "\n");
        bs.append("NUMBER OF COLUMNS: " + this.getNumOfAttributes() + "\n");
        int i = 0;
        while (i < this.getNumOfDataRows()) {
            bs.append("ROW " + i + " : ");
            bs.append("LABEL " + this.getClassification(i) + " : ");
            int j = 0;
            while (j < this.getNumOfAttributes()) {
                bs.append(String.valueOf(this.getValue(i, j)) + "\t");
                ++j;
            }
            bs.append("\n");
            ++i;
        }
        return bs.toString();
    }

    public void calculateBounds() {
        int Ylen = this.getNumOfAttributes();
        int Xlen = this.getNumOfDataRows();
        int i = 0;
        while (i < Xlen) {
            int j = 0;
            while (j < Ylen) {
                double point;
                double localmin = this.minY;
                double localmax = this.maxY;
                if (j == 0) {
                    localmin = this.minX;
                    localmax = this.maxX;
                }
                if ((point = this.getValue(i, j)) < localmin) {
                    localmin = point;
                } else if (point > localmax) {
                    localmax = point;
                }
                if (j == 0) {
                    this.minX = localmin;
                    this.maxX = localmax;
                } else {
                    this.minY = localmin;
                    this.maxY = localmax;
                }
                ++j;
            }
            ++i;
        }
    }

    public abstract void addLabel(int var1, String var2);

    public abstract void addSample(int var1, int var2, double var3);

    public abstract void addSampleRow(String var1, double ... var2);
}

