/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.LineGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TransectLineGraph;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.transducers.charts.QuantitiesAttributesChartsTransducerer;
import org.gcube.dataanalysis.ecoengine.utils.TimeAnalyzer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeSeriesChartsTransducerer
extends QuantitiesAttributesChartsTransducerer {
    String timepattern = "";
    SimpleDateFormat formatter = null;
    Date sampleTime = null;

    @Override
    protected void setInputParameters() {
        super.setInputParameters();
        ColumnType p = new ColumnType(inputTableParameter, timeParameter, "The column containing time information", "year", false);
        this.inputs.add(p);
    }

    @Override
    public String getDescription() {
        return "An algorithm producing time series charts of attributes vs. quantities. Charts are displayed per quantity column and only the top ten quantities are reported.";
    }

    public Date getTime(String timel) {
        try {
            if (this.formatter == null) {
                TimeAnalyzer analyzer = new TimeAnalyzer();
                this.sampleTime = analyzer.string2Date(timel);
                this.timepattern = analyzer.getPattern();
                AnalysisLogger.getLogger().debug((Object)("TimeSeriesChart: Time pattern: " + this.timepattern));
                this.formatter = new SimpleDateFormat(this.timepattern);
            }
            return this.formatter.parse(timel);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getChartPattern(Date time) {
        if (this.timepattern.equals("s") || DateGuesser.isJavaDateOrigin(time)) {
            return "HH:mm:ss:SS";
        }
        if (this.timepattern.length() == 4) {
            return "yyyy";
        }
        return "MM-dd-yy";
    }

    @Override
    public Image[] createCharts(String[] dimensions, String quantity, String time, List<Object> rows, boolean displaychart) {
        if (dimensions == null) {
            dimensions = new String[]{};
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries series = null;
        series = dimensions.length > 0 ? new TimeSeries((Comparable)((Object)("Trend of " + quantity + " for " + Arrays.toString(dimensions).replace("[", "").replace("]", "")))) : new TimeSeries((Comparable)((Object)("Trend of " + quantity)));
        dataset.addSeries(series);
        DefaultCategoryDataset[] linedatasets = new DefaultCategoryDataset[dimensions.length];
        for (Object row : rows) {
            Object[] array = (Object[])row;
            Double q = null;
            Date timeD = null;
            String timel = "" + array[array.length - 1];
            try {
                q = Double.parseDouble("" + array[array.length - 2]);
                timeD = this.getTime(timel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (q == null || timeD == null) continue;
            FixedMillisecond ms = new FixedMillisecond(timeD);
            series.add((RegularTimePeriod)ms, (Number)q);
            int dimIdx = 0;
            while (dimIdx < dimensions.length) {
                String dimensionValue = "";
                if (array[dimIdx] != null) {
                    dimensionValue = "" + array[dimIdx];
                }
                if (dimensionValue.length() > 0) {
                    DefaultCategoryDataset lineds = linedatasets[dimIdx];
                    if (lineds == null) {
                        linedatasets[dimIdx] = lineds = new DefaultCategoryDataset();
                    }
                    lineds.addValue((Number)q, (Comparable)((Object)"singlets"), (Comparable)((Object)(String.valueOf(timel) + ";[" + dimensionValue + "]")));
                }
                ++dimIdx;
            }
        }
        Image chartTS = ImageTools.toImage(TimeSeriesGraph.createStaticChart((Dataset)dataset, this.getChartPattern(this.sampleTime), "Variations of " + quantity).createBufferedImage(680, 420));
        if (displaychart) {
            TimeSeriesGraph tsg = new TimeSeriesGraph("Variations of " + quantity);
            tsg.timeseriesformat = this.getChartPattern(this.sampleTime);
            tsg.render((Dataset)dataset);
            int i = 0;
            while (i < dimensions.length) {
                TransectLineGraph tlg = new TransectLineGraph("Variations of " + dimensions[i]);
                tlg.render((Dataset)linedatasets[i]);
                ++i;
            }
        }
        Image[] charts = new Image[1 + dimensions.length];
        charts[0] = chartTS;
        int i = 0;
        while (i < dimensions.length) {
            Image linechartTS;
            charts[i + 1] = linechartTS = ImageTools.toImage(LineGraph.createStaticChart((Dataset)linedatasets[i], "Variations of " + dimensions[i]).createBufferedImage(680, 420));
            ++i;
        }
        return charts;
    }
}

