/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.math.BigInteger;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class HspecDiscrepanciesCalculator {
    private BigInteger numOfElements;
    private int errorCounter;
    protected String LogFile = "ALog.properties";
    int chunkSize = 7000;
    static double Threshold = 0.01;
    public String referenceTable = "speciesrichness";
    public String analyzedTable = "crossspecies_nonreviewed";
    public String referenceCriteria = "csquarecode,speccount";
    public String destinationCriteria = "csquarecode,maxspeciescountinacell";
    public String referenceSelectedColumns = "csquarecode,speccount";
    public String destinationSelectedColumns = "csquarecode,maxspeciescountinacell";
    public static String selectElementsQuery = "select %1$s from %2$s order by %3$s";
    public static String selectDestElementsQuery = "select %1$s from %2$s where %3$s";
    protected SessionFactory referencedbConnection;
    protected SessionFactory destinationdbConnection;

    public HspecDiscrepanciesCalculator(AlgorithmConfiguration config) throws Exception {
        AnalysisLogger.setLogger(String.valueOf(config.getConfigPath()) + this.LogFile);
        this.referencedbConnection = DatabaseFactory.initDBConnection(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultConnectionFile, config);
        AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
        this.destinationdbConnection = DatabaseFactory.initDBConnection(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultConnectionFile, config);
        AnalysisLogger.getLogger().debug((Object)"OriginalDB initialized");
    }

    public BigInteger countElements(String tablename, SessionFactory session) {
        BigInteger count = BigInteger.ZERO;
        String countingQuery = "select count(*) from " + tablename;
        AnalysisLogger.getLogger().debug((Object)("Getting DB elements by this query: " + countingQuery));
        List<Object> result = DatabaseFactory.executeSQLQuery(countingQuery, session);
        count = (BigInteger)result.get(0);
        return count;
    }

    public List<Object> takeChunkOfDestElements(String tablename, String selectedColumns, String criteria, SessionFactory session, String whereclause) {
        String query = String.format(selectDestElementsQuery, selectedColumns, tablename, whereclause);
        List<Object> results = DatabaseFactory.executeSQLQuery(query, session);
        return results;
    }

    public List<Object> takeChunkOfElements(String tablename, String selectedColumns, String criteria, int limit, int offset, SessionFactory session) {
        String query = String.valueOf(String.format(selectElementsQuery, selectedColumns, tablename, criteria)) + " limit " + limit + " offset " + offset;
        AnalysisLogger.getLogger().debug((Object)("takeChunkOfElements-> executing query on DB: " + query));
        List<Object> results = DatabaseFactory.executeSQLQuery(query, session);
        return results;
    }

    public double isNumber(String element) {
        try {
            double d = Double.parseDouble(element);
            return d;
        }
        catch (Exception e) {
            return -1.7976931348623157E308;
        }
    }

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setParam("DistributionTable", "hspec_suitable_automatic_local");
        config.setParam("ConfigPath", "./cfg/");
        config.setParam("CsquarecodesTable", "hcaf_d");
        config.setParam("EnvelopeTable", "hspen_micro");
        config.setParam("CreateTable", "true");
        config.setNumberOfResources(2);
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://localhost/testdb");
        HspecDiscrepanciesCalculator ec = new HspecDiscrepanciesCalculator(config);
        long t0 = System.currentTimeMillis();
        ec.runTest();
        long t1 = System.currentTimeMillis();
        float difference = t1 - t0;
        System.out.println("Elapsed time : " + (difference /= 60000.0f) + " min");
    }

    public boolean runTest() {
        long t0 = System.currentTimeMillis();
        this.numOfElements = this.countElements(this.analyzedTable, this.destinationdbConnection);
        AnalysisLogger.getLogger().debug((Object)("Remote DB contains " + this.numOfElements + " elements."));
        int maxNumber = this.numOfElements.intValue();
        int numOfChunks = maxNumber / this.chunkSize;
        if (maxNumber % this.chunkSize > 0) {
            ++numOfChunks;
        }
        int startIndex = 0;
        this.errorCounter = 0;
        boolean equal = true;
        boolean error = false;
        int i = startIndex;
        while (i < numOfChunks) {
            int offset = i * this.chunkSize;
            List<Object> referencechunk = this.takeChunkOfElements(this.referenceTable, this.referenceSelectedColumns, this.referenceCriteria, this.chunkSize, offset, this.referencedbConnection);
            int m = referencechunk.size();
            int j = 0;
            while (j < m) {
                int k;
                Object[] refrow = (Object[])referencechunk.get(j);
                String whereclause = "";
                String[] refcolumns = this.referenceCriteria.split(",");
                int k2 = 0;
                while (k2 < refcolumns.length) {
                    whereclause = String.valueOf(whereclause) + refcolumns[k2].trim() + "='" + refrow[k2] + "'";
                    if (k2 < refcolumns.length - 1) {
                        whereclause = String.valueOf(whereclause) + " and ";
                    }
                    ++k2;
                }
                List<Object> destinationchunk = this.takeChunkOfDestElements(this.analyzedTable, this.destinationSelectedColumns, this.destinationCriteria, this.destinationdbConnection, whereclause);
                Object[] destrow = null;
                int columns = 0;
                if (destinationchunk == null || destinationchunk.size() <= 0) {
                    AnalysisLogger.getLogger().debug((Object)("ERROR - COULD NOT FIND " + refrow + " ON DESTINATION TABLE"));
                    k = 0;
                    while (k < refcolumns.length) {
                        AnalysisLogger.getLogger().debug((Object)("-" + refrow[k]));
                        ++k;
                    }
                    error = true;
                    break;
                }
                destrow = (Object[])destinationchunk.get(0);
                columns = destrow.length;
                k = 0;
                while (k < columns) {
                    String refelem = "" + refrow[k];
                    String destelem = "" + destrow[k];
                    double d = this.isNumber(refelem);
                    if (d != -1.7976931348623157E308) {
                        if (Math.abs(d - this.isNumber(destelem)) > Threshold) {
                            ++this.errorCounter;
                            equal = false;
                            AnalysisLogger.getLogger().debug((Object)("ERROR - DISCREPANCY AT NUMBERS COMPARISON: " + refelem + " vs " + destelem));
                        }
                    } else if (!refelem.equals(destelem)) {
                        ++this.errorCounter;
                        equal = false;
                        AnalysisLogger.getLogger().debug((Object)("ERROR - DISCREPANCY AT STRING COMPARISON: " + refelem + " vs " + destelem));
                    }
                    if (!equal) break;
                    ++k;
                }
                if (!equal) break;
                ++j;
            }
            if (error || !equal) break;
            AnalysisLogger.getLogger().debug((Object)("CHUNK NUMBER " + i + " of " + numOfChunks + " OK!"));
            ++i;
        }
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (t1 - t0) + " ms"));
        this.referencedbConnection.close();
        this.destinationdbConnection.close();
        return equal;
    }
}

