/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import javax.swing.JPanel;
import org.gcube.contentmanagement.graphtools.plotting.graphs.ColorMap;

public class SpectrumPlot2
extends JPanel {
    private BufferedImage spectrogram = null;
    private Image scaledSpectrogram = null;
    private float zoom = 1.0f;
    private float vzoom = 1.0f;
    private double offsetFactor;
    private double[][] data;
    public int width;
    public int height;
    private ColorMap cmap = ColorMap.getJet(64);
    private double minVal;
    private double maxVal;

    public SpectrumPlot2(double[][] dat) {
        this.data = dat;
        this.width = dat.length;
        this.height = dat[0].length;
        this.computeSpectrogram();
    }

    private void computeSpectrogram() {
        try {
            this.maxVal = 0.0;
            this.minVal = 2.147483647E9;
            int x = 0;
            while (x < this.width) {
                int y = 0;
                while (y < this.height) {
                    if (this.data[x][y] > this.maxVal) {
                        this.maxVal = this.data[x][y];
                    }
                    if (this.data[x][y] < this.minVal) {
                        this.minVal = this.data[x][y];
                    }
                    ++y;
                }
                ++x;
            }
            double minIntensity = Math.abs(this.minVal);
            double maxIntensity = this.maxVal + minIntensity;
            int maxYIndex = this.height - 1;
            Dimension d = new Dimension(this.width, this.height);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.spectrogram = new BufferedImage(this.width, this.height, 1);
            double scaleFactor = (63.0 + this.offsetFactor) / maxIntensity;
            int i = 0;
            while (i < this.width) {
                int j = maxYIndex;
                while (j >= 0) {
                    int grey = (int)((this.data[i][j] + minIntensity) * scaleFactor - this.offsetFactor);
                    this.spectrogram.setRGB(i, maxYIndex - j, this.cmap.getColor(grey));
                    --j;
                }
                ++i;
            }
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(this.zoom * (float)this.width), (int)(this.vzoom * (float)this.height));
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            Dimension sz = this.getSize();
            this.repaint(0L, 0, 0, sz.width - 1, sz.height - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOffsetFactor(double offsetFactor) {
        this.offsetFactor = offsetFactor;
        this.computeSpectrogram();
    }

    public void vzoomSet(float vzoom) {
        this.vzoom = vzoom;
        this.zoom();
    }

    public void hzoomSet(float zoom) {
        this.zoomSet(zoom);
    }

    protected void zoomSet(float zoom) {
        this.zoom = zoom;
        this.zoom();
    }

    public void zoom() {
        if (this.spectrogram != null) {
            int width = this.spectrogram.getWidth();
            int height = this.spectrogram.getHeight();
            width = (int)(this.zoom * (float)width);
            height = (int)(this.vzoom * (float)height);
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter(width, height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            this.setPreferredSize(new Dimension(width, height));
            this.revalidate();
            this.repaint();
        }
    }

    public float getVZoom() {
        return this.vzoom;
    }

    public float getHZoom() {
        return this.zoom;
    }

    public SpectrumPlot2 getColorBar() {
        int barWidth = 20;
        double[][] cb = new double[barWidth][this.cmap.size];
        int x = 0;
        while (x < cb.length) {
            int y = 0;
            while (y < cb[x].length) {
                cb[x][y] = y;
                ++y;
            }
            ++x;
        }
        return new SpectrumPlot2(cb);
    }

    public double getData(int x, int y) {
        return this.data[x][y];
    }

    public int getDataWidth() {
        return this.width;
    }

    public int getDataHeight() {
        return this.height;
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, sz.width - 1, sz.height - 1);
        if (this.spectrogram != null) {
            g.drawImage(this.scaledSpectrogram, 0, 0, null);
        }
    }
}

