/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.hibernate.SessionFactory;

public abstract class AbstractChartsProducer
extends StandardLocalExternalAlgorithm {
    static String inputTableParameter = "InputTable";
    static String attributesParameter = "Attributes";
    static String quantitiesParameter = "Quantities";
    static String timeParameter = "Time";
    public HashMap<String, Image> producedImages = new HashMap();
    public boolean displaycharts = true;
    static int maxSeries = 10;
    SessionFactory connection = null;

    @Override
    protected abstract void setInputParameters();

    @Override
    public StatisticalType getOutput() {
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), this.producedImages, PrimitiveTypes.IMAGES, "images", "Charts");
        LinkedHashMap<String, PrimitiveType> outputmap = new LinkedHashMap<String, PrimitiveType>();
        outputmap.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), outputmap, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"ChartsProducer Initialized");
    }

    @Override
    public abstract String getDescription();

    public String[] getDimensions() {
        String dimensionS = IOHelper.getInputParameter(this.config, attributesParameter);
        String[] dimensions = null;
        try {
            dimensions = dimensionS.split(AlgorithmConfiguration.getListSeparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dimensions != null && dimensions.length == 1 && dimensions[0].trim().length() == 0) {
            dimensions = null;
        }
        return dimensions;
    }

    public String[] getQuantities() {
        String quantitieS = IOHelper.getInputParameter(this.config, quantitiesParameter);
        String[] quantities = quantitieS.split(AlgorithmConfiguration.getListSeparator());
        return quantities;
    }

    public String getTimeDimension() {
        String timeS = IOHelper.getInputParameter(this.config, timeParameter);
        return timeS;
    }

    public String InfoRetrievalQuery(String table, String[] dimensions, String quantity, String time) {
        if (time != null) {
            if (dimensions != null && dimensions.length > 0) {
                return "select * from (select distinct " + Arrays.toString(dimensions).replace("[", "").replace("]", "") + " , " + quantity + "," + time + " from " + table + " order by " + quantity + " limit " + maxSeries + ") as a order by " + time;
            }
            return "select * from (select distinct " + quantity + "," + time + " from " + table + " order by " + quantity + " limit " + maxSeries + ") as a order by " + time;
        }
        if (dimensions != null && dimensions.length > 0) {
            return "select distinct " + Arrays.toString(dimensions).replace("[", "").replace("]", "") + " , " + quantity + " from " + table + " order by " + quantity + " limit " + maxSeries;
        }
        return "select distinct row_number() over(), " + quantity + " from " + table + " order by " + quantity + " limit " + maxSeries;
    }

    @Override
    protected void process() throws Exception {
        this.status = 0.0f;
        AnalysisLogger.setLogger(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile);
        long t0 = System.currentTimeMillis();
        try {
            try {
                AnalysisLogger.getLogger().debug((Object)"ChartsProducer started");
                String driver = this.config.getParam("DatabaseDriver");
                String username = this.config.getParam("DatabaseUserName");
                String pwd = this.config.getParam("DatabasePassword");
                String url = this.config.getParam("DatabaseURL");
                String table = IOHelper.getInputParameter(this.config, inputTableParameter);
                AnalysisLogger.getLogger().debug((Object)("ChartsProducer: Driver: " + driver + " User " + username + " URL " + url + " Table: " + table));
                this.connection = DatabaseUtils.initDBSession(this.config);
                AnalysisLogger.getLogger().debug((Object)"ChartsProducer: Connection initialized");
                LexicalEngineConfiguration conf = new LexicalEngineConfiguration();
                conf.setDatabaseUserName(username);
                conf.setDatabasePassword(pwd);
                conf.setDatabaseDriver(driver);
                conf.setDatabaseURL(url);
                conf.setDatabaseDialect("org.hibernate.dialect.PostgreSQLDialect");
                String[] dimensions = this.getDimensions();
                String[] quantities = this.getQuantities();
                String time = this.getTimeDimension();
                String[] stringArray = quantities;
                int n = quantities.length;
                int n2 = 0;
                while (n2 < n) {
                    Image[] charts;
                    String quantity = stringArray[n2];
                    String query = this.InfoRetrievalQuery(table, dimensions, quantity, time);
                    AnalysisLogger.getLogger().debug((Object)("ChartsProducer: Query for retrieving information " + query));
                    List<Object> values = DatabaseFactory.executeSQLQuery(query, this.connection);
                    Image[] imageArray = charts = this.createCharts(dimensions, quantity, time, values, this.displaycharts);
                    int n3 = charts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Image chart = imageArray[n4];
                        if (chart != null) {
                            this.producedImages.put("Charts focused on " + quantity, chart);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                AnalysisLogger.getLogger().debug((Object)"ChartsProducer: finished");
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    public abstract Image[] createCharts(String[] var1, String var2, String var3, List<Object> var4, boolean var5);

    @Override
    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"ChartsProducer shutdown");
        DatabaseUtils.closeDBConnection(this.connection);
    }
}

