/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.hibernate.SessionFactory;

public class DBScan
implements Clusterer {
    protected AlgorithmConfiguration config;
    protected String epsilon;
    protected String minPoints;
    protected ExampleSet points;
    protected ArrayList<ArrayList<String>> rows;
    protected String OccurrencePointsTable;
    protected String OccurrencePointsClusterLabel;
    protected String OccurrencePointsClusterTable;
    protected String FeaturesColumnNames;
    protected float status;
    protected SessionFactory dbHibConnection;
    protected double[][] samplesVector;
    public static String clusterColumn = "clusterid";
    public static String clusterColumnType = "character varying";
    public static String outliersColumn = "outlier";
    public static String outliersColumnType = "boolean";
    protected boolean initrapidminer = true;
    long t00;
    ResourceFactory resourceManager;

    public static void mainCluster(String[] args) throws Exception {
        String[] coordinates = new String[]{"55.973798,-55.297853", "57.279043,-57.055666", "55.776573,-56.440431", "54.622978,-52.309572", "56.267761,-54.594728", "31.052934,-70.151369", "34.161818,-68.129885", "30.372875,-61.977541", "24.20689,-21.547853", "21.453069,-21.987306", "21.453069,-19.526369", "51.013755,-20.229494"};
        double[][] sampleVectors = new double[coordinates.length][2];
        int i = 0;
        while (i < coordinates.length) {
            String coordCop = coordinates[i];
            double first = Double.parseDouble(coordCop.substring(0, coordCop.indexOf(44)));
            double second = Double.parseDouble(coordCop.substring(coordCop.indexOf(44) + 1));
            sampleVectors[i][0] = first;
            sampleVectors[i][1] = second;
            ++i;
        }
        DBScan dbscanner = new DBScan();
        dbscanner.produceSamples(sampleVectors);
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setParam("epsilon", "10");
        config.setParam("min_points", "1");
        config.setConfigPath("./cfg/");
        config.initRapidMiner();
        dbscanner.setConfiguration(config);
        dbscanner.compute();
    }

    public static void mainRandom(String[] args) throws Exception {
        int max = 100000;
        String[] coordinates = new String[max];
        int j = 0;
        while (j < max) {
            coordinates[j] = String.valueOf(100.0 * Math.random()) + "," + 100.0 * Math.random();
            ++j;
        }
        double[][] sampleVectors = new double[coordinates.length][2];
        int i = 0;
        while (i < coordinates.length) {
            String coordCop = coordinates[i];
            double first = Double.parseDouble(coordCop.substring(0, coordCop.indexOf(44)));
            double second = Double.parseDouble(coordCop.substring(coordCop.indexOf(44) + 1));
            sampleVectors[i][0] = first;
            sampleVectors[i][1] = second;
            ++i;
        }
        DBScan dbscanner = new DBScan();
        dbscanner.produceSamples(sampleVectors);
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setParam("epsilon", "10");
        config.setParam("min_points", "1");
        config.setConfigPath("./cfg/");
        config.initRapidMiner();
        long t0 = System.currentTimeMillis();
        dbscanner.setConfiguration(config);
        dbscanner.compute();
        System.out.println("ELAPSED " + (System.currentTimeMillis() - t0));
    }

    public static void main(String[] args) throws Exception {
        long t0 = System.currentTimeMillis();
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("OccurrencePointsTable", "presence_basking_cluster");
        config.setParam("FeaturesColumnNames", "centerlat,centerlong");
        config.setParam("OccurrencePointsClusterTable", "occCluster_1");
        config.setParam("epsilon", "10");
        config.setParam("min_points", "1");
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://146.48.87.169/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        DBScan dbscanner = new DBScan();
        dbscanner.setConfiguration(config);
        dbscanner.init();
        dbscanner.compute();
        System.out.println("ELAPSED " + (System.currentTimeMillis() - t0));
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public void init() throws Exception {
        this.status = 0.0f;
        if (this.config != null && this.initrapidminer) {
            this.config.initRapidMiner();
        }
        AnalysisLogger.getLogger().debug((Object)"Initialized Rapid Miner ");
        AnalysisLogger.getLogger().debug((Object)"Initializing Database Connection");
        this.dbHibConnection = DatabaseUtils.initDBSession(this.config);
        try {
            AnalysisLogger.getLogger().debug((Object)("dropping table " + this.OccurrencePointsClusterTable));
            String dropStatement = DatabaseUtils.dropTableStatement(this.OccurrencePointsClusterTable);
            AnalysisLogger.getLogger().debug((Object)("dropping table " + dropStatement));
            DatabaseFactory.executeSQLUpdate(dropStatement, this.dbHibConnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Could not drop table " + this.OccurrencePointsClusterTable));
        }
        AnalysisLogger.getLogger().debug((Object)("Creating table " + this.OccurrencePointsClusterTable));
        String[] features = this.FeaturesColumnNames.split(AlgorithmConfiguration.getListSeparator());
        String columns = "";
        int i = 0;
        while (i < features.length) {
            columns = String.valueOf(columns) + features[i] + " real";
            if (i < features.length - 1) {
                columns = String.valueOf(columns) + ",";
            }
            ++i;
        }
        String createStatement = "create table " + this.OccurrencePointsClusterTable + " ( " + columns + ")";
        AnalysisLogger.getLogger().debug((Object)("Statement: " + createStatement));
        DatabaseFactory.executeSQLUpdate(createStatement, this.dbHibConnection);
        AnalysisLogger.getLogger().debug((Object)"Adding Columns");
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.addColumnStatement(this.OccurrencePointsClusterTable, clusterColumn, clusterColumnType), this.dbHibConnection);
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.addColumnStatement(this.OccurrencePointsClusterTable, outliersColumn, outliersColumnType), this.dbHibConnection);
        AnalysisLogger.getLogger().debug((Object)"Getting Samples");
        try {
            this.getSamples();
        }
        catch (Throwable e) {
            AnalysisLogger.getLogger().debug((Object)("Error getting samples for clustering: " + e.getLocalizedMessage()));
        }
        this.status = 10.0f;
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        if (config != null) {
            this.epsilon = config.getParam("epsilon");
            this.minPoints = config.getParam("min_points");
            this.OccurrencePointsTable = config.getParam("OccurrencePointsTable").toLowerCase();
            this.OccurrencePointsClusterLabel = config.getParam("OccurrencePointsClusterLabel");
            this.OccurrencePointsClusterTable = config.getParam("OccurrencePointsClusterTable").toLowerCase();
            this.FeaturesColumnNames = config.getParam("FeaturesColumnNames");
            this.config = config;
        }
    }

    protected void getSamples() throws Exception {
        this.t00 = System.currentTimeMillis();
        this.FeaturesColumnNames = this.FeaturesColumnNames.replace(AlgorithmConfiguration.listSeparator, ",");
        String[] elements = this.FeaturesColumnNames.split(",");
        int N = 4000;
        double k = elements.length;
        double t = 82327.0;
        double logG = Math.log(t) - (double)N;
        int limit = N;
        AnalysisLogger.getLogger().debug((Object)("Clustering limit: " + limit));
        List<Object> samples = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.OccurrencePointsTable, this.FeaturesColumnNames, "limit " + limit), this.dbHibConnection);
        int dimensions = elements.length;
        int nSamples = samples.size();
        this.samplesVector = new double[nSamples][dimensions];
        int ir = 0;
        for (Object row : samples) {
            Object[] rowArr = new Object[1];
            try {
                rowArr = (Object[])row;
            }
            catch (ClassCastException e) {
                rowArr[0] = "" + row;
            }
            int ic = 0;
            Object[] objectArray = rowArr;
            int n = rowArr.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                Double feature = null;
                try {
                    feature = Double.parseDouble("" + elem);
                }
                catch (Exception e) {
                    feature = Transformations.indexString("" + elem);
                }
                this.samplesVector[ir][ic] = feature;
                ++ic;
                ++n2;
            }
            ++ir;
        }
        AnalysisLogger.getLogger().debug((Object)"Building Sample Set For Miner");
        this.produceSamples(this.samplesVector);
        AnalysisLogger.getLogger().debug((Object)("Obtained " + this.samplesVector.length + " chunks"));
    }

    public void produceSamples(double[][] sampleVectors) throws Exception {
        this.points = Transformations.matrix2ExampleSet(sampleVectors);
    }

    @Override
    public void compute() throws Exception {
        try {
            try {
                if (this.config == null || this.epsilon == null || this.minPoints == null || this.points == null) {
                    throw new Exception("DBScan: Error incomplete parameters");
                }
                AnalysisLogger.getLogger().debug((Object)"DBScan: Settin up the cluster");
                com.rapidminer.operator.clustering.clusterer.DBScan clusterer = (com.rapidminer.operator.clustering.clusterer.DBScan)OperatorService.createOperator((String)"DBScanClustering");
                clusterer.setParameter("local_random_seed", "-1");
                clusterer.setParameter("epsilon", this.epsilon);
                clusterer.setParameter("min_points", this.minPoints);
                clusterer.setParameter("add_cluster_attribute", "true");
                clusterer.setParameter("keep_example_set", "true");
                IOContainer innerInput = new IOContainer(new IOObject[]{this.points});
                AnalysisLogger.getLogger().debug((Object)"DBScan: Clustering...");
                long ti = System.currentTimeMillis();
                IOContainer output = clusterer.apply(innerInput);
                AnalysisLogger.getLogger().debug((Object)("DBScan: ...ELAPSED CLUSTERING TIME: " + (System.currentTimeMillis() - ti)));
                AnalysisLogger.getLogger().debug((Object)("DBScan: ...Clustering Finished in " + (System.currentTimeMillis() - this.t00)));
                this.status = 70.0f;
                IOObject[] outputvector = output.getIOObjects();
                this.BuildClusterTable(outputvector);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("ERROR " + e.getLocalizedMessage()));
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    protected void BuildClusterTable(IOObject[] outputvector) throws Exception {
        ClusterModel innermodel = (ClusterModel)outputvector[0];
        ExampleSet es = (ExampleSet)outputvector[1];
        String columnsNames = String.valueOf(this.FeaturesColumnNames) + "," + clusterColumn + "," + outliersColumn;
        int minpoints = Integer.parseInt(this.minPoints);
        AnalysisLogger.getLogger().debug((Object)("Analyzing Cluster -> minpoints" + minpoints));
        int nClusters = innermodel.getClusters().size();
        float statusstep = (100.0f - this.status) / (float)(nClusters + 1);
        AnalysisLogger.getLogger().debug((Object)"Start Write On DB");
        for (Cluster c : innermodel.getClusters()) {
            StringBuffer bufferRows = new StringBuffer();
            int id = c.getClusterId();
            boolean outlier = false;
            int npoints = c.getExampleIds().size();
            AnalysisLogger.getLogger().debug((Object)("Analyzing Cluster ->" + id + " with " + npoints));
            if (npoints <= minpoints) {
                outlier = true;
            }
            int k = 0;
            for (Object o : c.getExampleIds()) {
                int idd = (int)Double.parseDouble("" + o);
                Example e = es.getExample(idd - 1);
                Attributes attributes = e.getAttributes();
                bufferRows.append("(");
                StringBuffer valueStrings = new StringBuffer();
                for (Attribute attribute : attributes) {
                    valueStrings.append(String.valueOf(e.getValue(attribute)) + ",");
                }
                String towrite = valueStrings.toString();
                towrite = towrite.substring(0, towrite.length() - 1);
                bufferRows.append(String.valueOf(towrite) + "," + id + "," + outlier + ")");
                if (k < npoints - 1) {
                    bufferRows.append(",");
                }
                ++k;
            }
            if (bufferRows.length() > 0) {
                AnalysisLogger.getLogger().debug((Object)"Writing into DB");
                DatabaseFactory.executeSQLUpdate(DatabaseUtils.insertFromBuffer(this.OccurrencePointsClusterTable, columnsNames, bufferRows), this.dbHibConnection);
                AnalysisLogger.getLogger().debug((Object)"Finished with writing into DB");
            } else {
                AnalysisLogger.getLogger().debug((Object)"Nothing to write in the buffer");
            }
            float instatus = this.status + statusstep;
            this.status = Math.min(95.0f, instatus);
            AnalysisLogger.getLogger().debug((Object)("Status: " + this.status));
        }
    }

    @Override
    public void shutdown() {
        try {
            AnalysisLogger.getLogger().debug((Object)"Closing DB Connection ");
            if (this.dbHibConnection != null) {
                this.dbHibConnection.close();
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Could not shut down connection");
        }
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.CLUSTER);
        return new OutputTable(templateHspec, this.OccurrencePointsClusterLabel, this.OccurrencePointsClusterTable, "Output cluster table");
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateOccs = new ArrayList<TableTemplates>();
        templateOccs.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateOccs, "OccurrencePointsTable", "Occurrence Points Table. Max 4000 points", "occurrences");
        ColumnTypesList p2 = new ColumnTypesList("OccurrencePointsTable", "FeaturesColumnNames", "column Names for the features", false);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "OccurrencePointsClusterLabel", "table name of the resulting distribution", "OccCluster_");
        ServiceType p3 = new ServiceType(ServiceParameters.RANDOMSTRING, "OccurrencePointsClusterTable", "table name of the distribution", "occCluster_");
        PrimitiveType p4 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "epsilon", "DBScan epsilon parameter", "10");
        PrimitiveType p5 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "min_points", "DBScan minimum points parameter (identifies outliers)", "1");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p0);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public String getDescription() {
        return "A clustering algorithm for real valued vectors that relies on the density-based spatial clustering of applications with noise (DBSCAN) algorithm. A maximum of 4000 points is allowed.";
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return ResourceFactory.getResources(100.0f);
        }
        return ResourceFactory.getResources(0.0f);
    }
}

