/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.plugin;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Consumer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.dataanalysis.executor.plugin.QueueListener;
import org.gcube.dataanalysis.executor.plugin.QueueWatcher;
import org.gcube.dataanalysis.executor.plugin.ScriptIOWorker;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class GenericWorkerPlugin
extends GCUBEHandler<TaskRuntime>
implements ExecutorTask {
    public static Consumer activeT;
    public static QueueWatcher qWatcher;
    public static Hashtable<String, String> sessionBlackList;
    public static Boolean processing;
    public static Boolean creating;
    ConsumerWatcher consumerwatcher;
    Timer consumerWatcherTimer;

    public void stop() throws UnsupportedOperationException, Exception {
        this.getLogger().trace((Object)"GenericWorkerPlugin: Stopped - closed all watchers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        this.setState((State)State.Running.INSTANCE);
        this.getLogger().trace((Object)"GenericWorkerPlugin: Start");
        TaskRuntime runtime = (TaskRuntime)this.getHandled();
        String nodeAddress = GHNContext.getContext().getHostname();
        Map inputs = runtime.getInputs();
        this.getLogger().trace((Object)("GenericWorkerPlugin: Inputs: " + inputs + " on node: " + nodeAddress));
        try {
            String uniqueTopicName = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.TOPIC_NAME.name()));
            String user = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_USER.name()));
            String password = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_PASSWORD.name()));
            String queueURL = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_URL.name()));
            String topicResponseName = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.TOPIC_RESPONSE_NAME.name()));
            String session = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QSESSION.name()));
            String erase = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.ERASE.name()));
            if (session == null) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: Session is null ignoring message");
            } else {
                if (this.consumerwatcher == null || this.consumerWatcherTimer == null) {
                    this.getLogger().trace((Object)"GenericWorkerPlugin: Starting consumer watcher");
                    this.consumerWatcherTimer = new Timer();
                    this.consumerwatcher = new ConsumerWatcher();
                    this.consumerWatcherTimer.schedule((TimerTask)this.consumerwatcher, 0L, (long)QCONSTANTS.QueueLifeTime);
                }
                if (qWatcher == null) {
                    qWatcher = new QueueWatcher(QCONSTANTS.QueueLifeTime);
                }
                if (qWatcher.isTooMuch()) {
                    this.resetAll();
                }
                if (erase != null && erase.equals("true")) {
                    this.getLogger().trace((Object)("GenericWorkerPlugin: purging session " + session + " on queue " + uniqueTopicName));
                    if (sessionBlackList == null) {
                        sessionBlackList = new Hashtable();
                    }
                    sessionBlackList.put(session, uniqueTopicName);
                    this.getLogger().trace((Object)("GenericWorkerPlugin: topic " + session + "on queue " + uniqueTopicName + " has been blacklisted"));
                } else if (GenericWorkerPlugin.getProcessing()) {
                    this.getLogger().trace((Object)"GenericWorkerPlugin: Worker is Computing - Ignoring Request");
                } else if (!GenericWorkerPlugin.getCreating()) {
                    GenericWorkerPlugin.setCreating(true);
                    this.getLogger().trace((Object)("GenericWorkerPlugin: Adding Topic " + uniqueTopicName + " with session " + session));
                    if (activeT == null) {
                        if (sessionBlackList == null) {
                            sessionBlackList = new Hashtable();
                        }
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Active Queue is null - creating");
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Creating Producer");
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Creating Consumer");
                        QueueManager qm = new QueueManager();
                        qm.createAndConnect(user, password, queueURL, uniqueTopicName);
                        QueueListener ql = new QueueListener(qm, uniqueTopicName, nodeAddress, this.logger);
                        activeT = new Consumer(qm, ql, ql, uniqueTopicName);
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Active Queue was created!");
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Setting Creation flag to FALSE");
                        Thread.sleep(10000L);
                        GenericWorkerPlugin.setCreating(false);
                        this.getLogger().trace((Object)"GenericWorkerPlugin: Creation was set to FALSE");
                    }
                } else {
                    this.getLogger().trace((Object)"GenericWorkerPlugin: Warning - Worker is occupied");
                }
                this.getLogger().trace((Object)"GenericWorkerPlugin: Finished");
            }
            this.setState((State)State.Done.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().error((Object)("GenericWorkerPlugin: Error " + e.getLocalizedMessage()));
            this.getLogger().trace((Object)"GenericWorkerPlugin: Completely Finished");
            this.setState((State)State.Failed.INSTANCE);
        }
        finally {
            this.stop();
        }
    }

    public static void setProcessing(boolean state) {
        processing = state;
        if (processing.booleanValue()) {
            GenericWorkerPlugin.resetWatcher();
        }
    }

    public static boolean getProcessing() {
        if (processing == null) {
            processing = false;
        }
        return processing;
    }

    public static boolean getCreating() {
        if (creating == null) {
            creating = false;
        }
        return creating;
    }

    public static void setCreating(boolean state) {
        creating = state;
        if (creating.booleanValue()) {
            GenericWorkerPlugin.resetWatcher();
        }
    }

    public static void resetWatcher() {
        qWatcher.reset();
    }

    public void resetAll() {
        try {
            if (activeT != null) {
                activeT.stop();
                activeT.closeSession();
                activeT = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GenericWorkerPlugin.setCreating(false);
        sessionBlackList = null;
        GenericWorkerPlugin.resetWatcher();
        this.purgeConsumerWatcher();
        this.getLogger().trace((Object)"GenericWorkerPlugin: Reset All!");
    }

    private void purgeConsumerWatcher() {
        this.getLogger().trace((Object)"GenericWorkerPlugin: Stopping - closing all watchers");
        if (this.consumerwatcher != null) {
            this.consumerwatcher.cancel();
            if (this.consumerWatcherTimer != null) {
                this.consumerWatcherTimer.cancel();
                this.consumerWatcherTimer.purge();
            }
            this.consumerwatcher = null;
            this.consumerWatcherTimer = null;
        }
        this.getLogger().trace((Object)"GenericWorkerPlugin: Stopping - closed all watchers");
    }

    public class ConsumerWatcher
    extends TimerTask {
        @Override
        public void run() {
            try {
                if (qWatcher != null && qWatcher.isTooMuch() && !GenericWorkerPlugin.getProcessing() && !GenericWorkerPlugin.getCreating()) {
                    GenericWorkerPlugin.this.resetAll();
                }
            }
            catch (Exception e) {
                System.out.println("GenericWorkerPlugin: ERROR IN RESETTING WATCHER!");
                e.printStackTrace();
            }
        }
    }
}

