/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.messagequeue;

import java.util.UUID;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class QueueManager {
    public ActiveMQConnectionFactory connectionFactory;
    public Connection connection;
    public Session session;
    public Destination destination;
    boolean transacted = false;
    public String mqurl;
    private String identifier;

    public void createAndConnect(String user, String password, String mqurl, String queueName) throws JMSException {
        this.mqurl = mqurl;
        this.connect(user, password, mqurl);
        this.session = this.connection.createSession(this.transacted, 2);
        this.identifier = "" + UUID.randomUUID();
        this.destination = this.session.createQueue(queueName + "?wireFormat.maxInactivityDurationInitalDelay=3600000&requestTimeout=240000&wireFormat.maxInactivityDuration=3600000&transport.closeAsync=false");
    }

    public void destroy() {
    }

    private void connect(String user, String password, String mqurl) throws JMSException {
        this.connectionFactory = new ActiveMQConnectionFactory(user, password, mqurl);
        this.connectionFactory.getPrefetchPolicy().setQueuePrefetch(1);
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.identifier);
        this.connection.start();
    }

    public void closeSession() throws Exception {
        this.session.close();
    }
}

