/**
 * 
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * @author Paolo Fabriani
 *
 */
public class TimeUtil {

    public static String toString(Calendar c) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return format.format(c.getTime());
    }

    public static Calendar toCalendar(String s) throws ParseException {
        String[] formats = {
                "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'",
                "yyyy-MM-dd hh:mm:ss",
                "yyyy-MM-dd"
        };
        ParseException outException = null;
        for(String f:formats) {
            SimpleDateFormat format = new SimpleDateFormat(f);
            Calendar c = Calendar.getInstance();
            try {
                c.setTime(format.parse(s));
                return c;
            } catch (ParseException e) {
                outException = e;
                continue;
            }
        }
        throw outException;
    }

}
