/**
 * 
 */
package org.gcube.dataanalysis.copernicus.motu.model;

import java.util.Collection;
import java.util.Vector;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement(name = "motuCatalogue")
public class MotuCatalogue {

    private String url;
    
    private Collection<ServiceMetadata> services;

    @XmlAttribute(name="serverURL")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlElement(name = "service")
    @XmlElementWrapper(name = "services")
    public Collection<ServiceMetadata> getServices() {
        return services;
    }

    public void setServices(Collection<ServiceMetadata> services) {
        this.services = services;
    }

    public void addService(ServiceMetadata service) {
        if(this.services==null) {
            this.services = new Vector<>();
        }
        this.services.add(service);
    }

}
