package org.gcube.dataanalysis.copernicus.motu.model;

import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/**
 * Helper class to unmarshal xml representations to java objects.
 * 
 * @author Paolo Fabriani
 *
 */
public class MotuUnmarshaller {

    public static StatusModeResponse getStatusModeResponse(String xml)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(StatusModeResponse.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (StatusModeResponse) unmarshaller.unmarshal(reader);
    }

    public static RequestSize getRequestSize(String xml) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance(RequestSize.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (RequestSize) unmarshaller.unmarshal(reader);
    }

    public static ProductMetadataInfo getProductMetadataInfo(String xml)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(ProductMetadataInfo.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (ProductMetadataInfo) unmarshaller.unmarshal(reader);
    }

}
