package org.gcube.dataanalysis.copernicus.motu.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

import org.apache.commons.io.FileUtils;

public class SizeUtils {

    public static final Long KB = 1024L;
    public static final Long MB = 1024*KB;
    public static final Long GB = 1024*MB;
    
    public static String units = "BKMGTPEZY";

    public static long parse(String arg0) {
        int spaceNdx = arg0.indexOf(" ");

        double ret = Double.parseDouble(arg0.substring(0, spaceNdx));

        String unitString = arg0.substring(spaceNdx + 1);

        int unitChar = unitString.charAt(0);

        int power = units.indexOf(unitChar);

        boolean isSi = unitString.indexOf('i') != -1;

        int factor = 1024;
        if (isSi) {
            factor = 1000;
        }
        return new Double(ret * Math.pow(factor, power)).longValue();
    }
    
    public static String humanReadableSize(Long bytes) {
        for(int i=0; i<10; i++) {
            Double s = Math.pow(1024,i);
            if (bytes < 500 * s) {
                Double out = bytes * 1d / s;
                out = round(out, 2);
                return (out + " ") + units.charAt(i) + "B";
            }
        }
        return bytes+ " B";
    }
    
    private static double round(double value, int places) {
        if (places < 0) throw new IllegalArgumentException();

        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
    
}
