/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems;

import org.apache.commons.lang.WordUtils;

public class CodedString
implements Comparable<CodedString> {
    private String code;

    public CodedString(String code) {
        this.code = code;
    }

    public String getDisplayName() {
        String[] uncapitalize;
        switch (this.code) {
            case "iberian-biscay-irish-seas": {
                return "Iberia-Biscay-Irish Regional Seas";
            }
            case "north-west-shelf-seas": {
                return "European North-West Shelf Seas";
            }
        }
        String out = this.code.trim();
        out = out.replaceAll("-", " ");
        out = out.replaceAll("_", " ");
        out = WordUtils.capitalize((String)out);
        for (String unc : uncapitalize = new String[]{"of", "at", "in", "to", "as", "per", "by", "from", "for", "and"}) {
            String find = " " + WordUtils.capitalize((String)unc) + " ";
            String repl = " " + unc + " ";
            out = out.replaceAll(find, repl);
        }
        return out;
    }

    @Override
    public int compareTo(CodedString other) {
        return this.code.compareTo(other.code);
    }

    public boolean equals(CodedString other) {
        return this.code.equals(other.code);
    }
}

