/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.io.File;
import java.util.Collection;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.gcube.dataanalysis.copernicus.motu.client.ChunkMerger;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequestEnvelope;
import org.gcube.dataanalysis.copernicus.motu.client.PlainMotuClient;
import org.gcube.dataanalysis.copernicus.motu.client.RequestSplitter;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedDownloader;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedSubmitter;
import org.gcube.dataanalysis.copernicus.motu.client.WorkCompleteListener;
import org.gcube.dataanalysis.copernicus.motu.model.Axis;
import org.gcube.dataanalysis.copernicus.motu.model.MotuCatalogue;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.ServiceMetadata;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.gcube.dataanalysis.copernicus.motu.util.MotuWorkspace;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;

public class MotuClient
extends PlainMotuClient {
    private static final Logger LOGGER = Logger.getLogger(MotuClient.class);
    private Long preferredDownloadSize;
    private static final String[] DEFAULT_VAR_SPLIT = new String[]{"v", "t", "x", "y", "z"};
    private static final Long CHECK_INTERVAL = 10000L;

    public MotuClient(String serviceURL) {
        super(serviceURL);
    }

    public Long getPreferredDownloadSize() {
        if (this.preferredDownloadSize != null) {
            return this.preferredDownloadSize;
        }
        return Long.MAX_VALUE;
    }

    public void setPreferredDownloadSize(Long preferredDownloadSize) {
        this.preferredDownloadSize = preferredDownloadSize;
    }

    public File downloadProduct(DownloadRequest request) throws Exception {
        return this.downloadProduct(request, DEFAULT_VAR_SPLIT);
    }

    public File downloadProduct(DownloadRequest request, File destFile) throws Exception {
        return this.downloadProduct(request, destFile, DEFAULT_VAR_SPLIT);
    }

    @Override
    public RequestSize getSize(DownloadRequest request) throws Exception {
        this.ensureParameters(request);
        return super.getSize(request);
    }

    public RequestSize getSize(String service, String product) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setService(service);
        request.setProduct(product);
        return this.getSize(request);
    }

    private DownloadRequest ensureParameters(DownloadRequest request) throws Exception {
        ProductMetadataInfo pmi = this.describeProduct(request);
        if (request.gettLo() == null) {
            request.settLo(pmi.getFirstAvailableTimeCode());
        }
        if (request.gettHi() == null) {
            request.settHi(pmi.getLastAvailableTimeCode());
        }
        for (Axis axis : pmi.getDataGeospatialCoverage()) {
            if (axis.getName().equals("lon")) {
                if (request.getxLo() == null) {
                    request.setxLo(Double.parseDouble(axis.getLower()));
                }
                if (request.getxHi() == null) {
                    request.setxHi(Double.parseDouble(axis.getUpper()));
                }
            }
            if (axis.getName().equals("lat")) {
                if (request.getyLo() == null) {
                    request.setyLo(Double.parseDouble(axis.getLower()));
                }
                if (request.getyHi() == null) {
                    request.setyHi(Double.parseDouble(axis.getUpper()));
                }
            }
            if (!axis.getName().equals("depth")) continue;
            if (request.getzLo() == null) {
                request.setzLo(Double.parseDouble(axis.getLower()));
            }
            if (request.getzHi() != null) continue;
            request.setzHi(Double.parseDouble(axis.getUpper()));
        }
        return request;
    }

    public ProductMetadataInfo describeProduct(String service, String product) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setService(service);
        request.setProduct(product);
        return super.describeProduct(request);
    }

    public void describeCoverage(String service, String product) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setService(service);
        request.setProduct(product);
        super.describeCoverage(request);
    }

    public ProductMetadataInfo describeProduct(ServiceMetadata service, String product) throws Exception {
        return this.describeProduct(service.getName(), product);
    }

    public File downloadProduct(DownloadRequest request, File destFile, String ... splitParameters) throws Exception {
        String executionId = UUID.randomUUID().toString();
        MotuWorkspace workspace = new MotuWorkspace(executionId);
        workspace.setExecutionsRoot("/tmp/motu-downloads");
        workspace.setInputLocation("download");
        workspace.setOutputLocation("output");
        workspace.ensureStructureExists();
        ThreadedSubmitter ts = new ThreadedSubmitter(this);
        final ThreadedDownloader td = new ThreadedDownloader();
        td.setDestinationDir(workspace.getInputLocation());
        ts.setListener(new WorkCompleteListener<DownloadRequestEnvelope>(){

            @Override
            public void workComplete(DownloadRequestEnvelope chunk) {
                td.push(chunk);
            }
        });
        this.ensureParameters(request);
        RequestSplitter splitter = new RequestSplitter(request);
        splitter.setMotuClient(this);
        for (DownloadRequestEnvelope envelope : splitter.splitRequest(splitParameters)) {
            ts.push(envelope);
        }
        while (!ts.isComplete() || !td.isComplete()) {
            Thread.sleep(CHECK_INTERVAL);
        }
        File mergedFile = new File(workspace.getOutputLocation(), request.getProduct() + ".nc");
        ChunkMerger cm = new ChunkMerger();
        cm.mergeAll(workspace.getInputLocation(), mergedFile);
        if (destFile == null) {
            destFile = new File("/tmp", executionId + "-" + request.getProduct() + ".nc");
        }
        FileUtils.moveFile((File)mergedFile, (File)destFile);
        return destFile;
    }

    public File downloadProduct(DownloadRequest request, String ... splitParameters) throws Exception {
        return this.downloadProduct(request, (File)null, splitParameters);
    }

    public Collection<ServiceMetadata> listServices() throws Exception {
        String url = this.getServiceURL() + "?action=listservices";
        String html = NetworkUtils.doGet(url, this.getCasProxy());
        String str = "<tr> <td> <a href=\\?action=listcatalog&service=([^>]+)> ([^<]+) </a> </td> <td> ([^<]+) </td> </tr>";
        str = str.replaceAll("\\s", "\\\\s*");
        Pattern pattern = Pattern.compile(str);
        Vector<ServiceMetadata> output = new Vector<ServiceMetadata>();
        Matcher m = pattern.matcher(html);
        while (m.find()) {
            ServiceMetadata service = new ServiceMetadata();
            service.setName(m.group(1).trim());
            service.setDescription(m.group(2).trim());
            service.setType(m.group(3).trim());
            output.add(service);
        }
        return output;
    }

    public Collection<String> listProductsNames(String service) throws Exception {
        String url = this.getServiceURL() + "?action=listcatalog&service=" + service;
        String html = NetworkUtils.doGet(url, this.getCasProxy());
        String str = "<a href=\\?action=productdownloadhome&service=([^&]+)&product=([^&>]+)>";
        str = str.replaceAll("\\s", "\\\\s*");
        Pattern pattern = Pattern.compile(str);
        Vector<String> output = new Vector<String>();
        Matcher m = pattern.matcher(html);
        while (m.find()) {
            output.add(m.group(2));
        }
        return output;
    }

    public Collection<StatusModeResponse> checkAllStatus(Collection<StatusModeResponse> requests) throws Exception {
        Vector<StatusModeResponse> out = new Vector<StatusModeResponse>();
        for (StatusModeResponse smr : requests) {
            out.add(super.checkStatus(smr.getRequestId()));
        }
        for (StatusModeResponse smr : out) {
            LOGGER.info((Object)("Status of " + smr.getRequestId() + " is " + smr.getStatus()));
        }
        return out;
    }

    public MotuCatalogue getCatalogue() throws Exception {
        MotuCatalogue catalogue = new MotuCatalogue();
        catalogue.setUrl(this.getServiceURL());
        for (ServiceMetadata service : this.listServices()) {
            if (service.getType().equals("Subsetter")) {
                for (String productName : this.listProductsNames(service.getName())) {
                    ProductMetadataInfo pmi = this.describeProduct(service.getName(), productName);
                    service.addProduct(pmi);
                }
            }
            if (!service.hasProducts()) continue;
            catalogue.addService(service);
        }
        return catalogue;
    }
}

