/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.oscar;

import java.net.URL;
import java.util.List;
import org.gcube.dataanalysis.oscar.util.ISClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsUploader {
    private static final Logger logger = LoggerFactory.getLogger(ThreddsUploader.class);

    public boolean publishOnThredds(String scope, String fileAbsolutePath) throws Exception {
        String remoteFolder = "/data/content/thredds/public/netcdf/";
        List<URL> threddsAddress = new ISClient().getThreddsServices();
        if (threddsAddress.size() == 0) {
            throw new Exception("Thredds resource is not available in scope " + scope);
        }
        logger.info("Found " + threddsAddress.size() + " thredds services.");
        URL thredds = threddsAddress.get(0);
        logger.info("Picking the first one: " + thredds);
        List<URL> dataTransferAddress = new ISClient().getDataTransferServices();
        if (dataTransferAddress.size() == 0) {
            throw new Exception("Data Transfer services are not available in scope " + scope);
        }
        URL dataTransfer = null;
        for (URL address : dataTransferAddress) {
            if (!address.getHost().equals(thredds.getHost())) continue;
            dataTransfer = address;
            break;
        }
        if (dataTransfer == null) {
            throw new Exception("Thredds data transfer has not been found in the same scope of the catalog: " + scope);
        }
        logger.info("TODO: Transferring files using: " + dataTransfer);
        logger.info("TODO: Adding metadata on GeoNetwork");
        logger.info("Finished");
        return true;
    }
}

