/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import ucar.ma2.StructureData;

public abstract class CoordVarExtractor {
    protected String axisName;
    protected String memberName;
    protected int nestingLevel;

    protected CoordVarExtractor(String axisName, int nestingLevel) {
        this.axisName = axisName;
        int pos = axisName.indexOf(".");
        this.memberName = pos > 0 ? axisName.substring(pos + 1) : axisName;
        this.nestingLevel = nestingLevel;
    }

    public abstract double getCoordValue(StructureData var1);

    public abstract long getCoordValueLong(StructureData var1);

    public abstract String getCoordValueString(StructureData var1);

    public abstract String getUnitsString();

    public abstract boolean isString();

    public abstract boolean isInt();

    public double getCoordValue(StructureData[] tableData) {
        return this.getCoordValue(tableData[this.nestingLevel]);
    }

    public String getCoordValueString(StructureData[] tableData) {
        return this.getCoordValueString(tableData[this.nestingLevel]);
    }

    public String getCoordValueAsString(StructureData sdata) {
        if (this.isString()) {
            return this.getCoordValueString(sdata);
        }
        if (this.isInt()) {
            long val2 = this.getCoordValueLong(sdata);
            return Long.toString(val2);
        }
        double dval = this.getCoordValue(sdata);
        return Double.toString(dval);
    }

    protected abstract boolean isMissing(StructureData var1);

    public boolean isMissing(StructureData[] tableData) {
        return this.isMissing(tableData[this.nestingLevel]);
    }

    public String toString() {
        return this.axisName + " nestingLevel= " + this.nestingLevel;
    }
}

