/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.util.Formatter;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;

public abstract class Evaluator {
    public static String findNameVariableWithStandardNameAndDimension(NetcdfDataset ds, String standard_name, Dimension outer, Formatter errlog) {
        Variable v = Evaluator.findVariableWithAttributeAndDimension(ds, "standard_name", standard_name, outer, errlog);
        return v == null ? null : v.getShortName();
    }

    public static Variable findVariableWithAttributeAndDimension(NetcdfDataset ds, String att_name, String att_value, Dimension outer, Formatter errlog) {
        for (Variable v : ds.getVariables()) {
            String attValue = ds.findAttValueIgnoreCase(v, att_name, null);
            if (attValue == null || !attValue.equalsIgnoreCase(att_value)) continue;
            if (v.getRank() > 0 && v.getDimension(0).equals(outer)) {
                return v;
            }
            if (!Evaluator.isEffectivelyScaler(v) || outer != null) continue;
            return v;
        }
        for (Variable v : ds.getVariables()) {
            Structure s;
            if (!(v instanceof Structure) || ((s = (Structure)v).getRank() <= 0 || !s.getDimension(0).equals(outer)) && (s.getRank() != 0 || outer != null)) continue;
            for (Variable vs : s.getVariables()) {
                Attribute att = vs.findAttributeIgnoreCase(att_name);
                if (att == null || !att.isString() || !att.getStringValue().equalsIgnoreCase(att_value)) continue;
                return vs;
            }
        }
        return null;
    }

    public static boolean isEffectivelyScaler(Variable v) {
        return v.getRank() == 0 || v.getRank() == 1 && v.getDataType() == DataType.CHAR;
    }

    public static VarAtt findVariableWithAttribute(NetcdfDataset ds, String attName) {
        for (Variable v : ds.getVariables()) {
            Attribute att = v.findAttributeIgnoreCase(attName);
            if (att == null) continue;
            return new VarAtt(v, att);
        }
        for (Variable v : ds.getVariables()) {
            if (!(v instanceof Structure)) continue;
            Structure s = (Structure)v;
            for (Variable vs : s.getVariables()) {
                Attribute att = vs.findAttributeIgnoreCase(attName);
                if (att == null) continue;
                return new VarAtt(vs, att);
            }
        }
        return null;
    }

    public static Variable findVariableWithAttributeValue(NetcdfDataset ds, String attName, String attValue) {
        for (Variable v : ds.getVariables()) {
            String haveValue = ds.findAttValueIgnoreCase(v, attName, null);
            if (haveValue == null || !haveValue.equals(attValue)) continue;
            return v;
        }
        for (Variable v : ds.getVariables()) {
            Variable vn;
            if (!(v instanceof Structure) || null == (vn = Evaluator.findVariableWithAttributeValue((Structure)v, attName, attValue))) continue;
            return vn;
        }
        return null;
    }

    public static String findNameOfVariableWithAttributeValue(NetcdfDataset ds, String attName, String attValue) {
        Variable v = Evaluator.findVariableWithAttributeValue(ds, attName, attValue);
        return v == null ? null : v.getShortName();
    }

    public static Variable findVariableWithAttributeValue(Structure struct, String attName, String attValue) {
        for (Variable v : struct.getVariables()) {
            Attribute att = v.findAttributeIgnoreCase(attName);
            if (att == null || !att.getStringValue().equals(attValue)) continue;
            return v;
        }
        return null;
    }

    public static Structure findStructureWithDimensions(NetcdfDataset ds, Dimension dim0, Dimension dim1) {
        for (Variable v : ds.getVariables()) {
            if (!(v instanceof Structure)) continue;
            if (dim1 != null && v.getRank() == 2 && v.getDimension(0).equals(dim0) && v.getDimension(1).equals(dim1)) {
                return (Structure)v;
            }
            if (dim1 != null || v.getRank() != 1 || !v.getDimension(0).equals(dim0)) continue;
            return (Structure)v;
        }
        return null;
    }

    public static Structure findNestedStructure(Structure s) {
        for (Variable v : s.getVariables()) {
            if (!(v instanceof Structure)) continue;
            return (Structure)v;
        }
        return null;
    }

    public static boolean hasNetcdf3RecordStructure(NetcdfDataset ds) {
        Variable v = ds.findVariable("record");
        return v != null && v.getDataType() == DataType.STRUCTURE;
    }

    public static String getLiteral(NetcdfDataset ds, String key, Formatter errlog) {
        if (key.startsWith(":")) {
            String val2 = ds.findAttValueIgnoreCase(null, key.substring(1), null);
            if (val2 == null && errlog != null) {
                errlog.format(" Cant find global attribute %s%n", key);
            }
            return val2;
        }
        return key;
    }

    public static FeatureType getFeatureType(NetcdfDataset ds, String key, Formatter errlog) {
        FeatureType ft = null;
        String fts = Evaluator.getLiteral(ds, key, errlog);
        if (fts != null && (ft = FeatureType.valueOf(fts.toUpperCase())) == null && errlog != null) {
            errlog.format(" Cant find Feature type %s from %s%n", fts, key);
        }
        return ft;
    }

    public static String getVariableName(NetcdfDataset ds, String key, Formatter errlog) {
        Variable v = null;
        String vs = Evaluator.getLiteral(ds, key, errlog);
        if (vs != null && (v = ds.findVariable(vs)) == null && errlog != null) {
            errlog.format(" Cant find Variable %s from %s%n", vs, key);
        }
        return v == null ? null : v.getShortName();
    }

    public static Dimension getDimension(NetcdfDataset ds, String key, Formatter errlog) {
        Dimension d = null;
        String s = Evaluator.getLiteral(ds, key, errlog);
        if (s != null && (d = ds.findDimension(s)) == null && errlog != null) {
            errlog.format(" Cant find Variable %s from %s%n", s, key);
        }
        return d;
    }

    public static String getDimensionName(NetcdfDataset ds, String key, Formatter errlog) {
        Dimension d = Evaluator.getDimension(ds, key, errlog);
        return d == null ? null : d.getShortName();
    }

    private Evaluator() {
    }

    public static class VarAtt {
        public Variable var;
        public Attribute att;

        public VarAtt(Variable var, Attribute att) {
            this.var = var;
            this.att = att;
        }
    }
}

