/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.sigmet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.sigmet.Ray;
import ucar.nc2.iosp.sigmet.SigmetIOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class SigmetVolumeScan {
    String[] data_name = new String[]{" ", "TotalPower", "Reflectivity", "Velocity", "Width", "DifferentialReflectivity"};
    private List<List<Ray>> differentialReflectivityGroups;
    private List<List<Ray>> reflectivityGroups;
    private List<List<Ray>> totalPowerGroups;
    private List<List<Ray>> velocityGroups;
    private List<List<Ray>> widthGroups;
    private List<List<Ray>> timeGroups;
    private int[] num_gates;
    public int[] base_time;
    public short[] year;
    public short[] month;
    public short[] day;
    public Ray firstRay = null;
    public Ray lastRay = null;
    public RandomAccessFile raf;
    public boolean hasReflectivity = false;
    public boolean hasVelocity = false;
    public boolean hasWidth = false;
    public boolean hasTotalPower = false;
    public boolean hasDifferentialReflectivity = false;
    public boolean hasTime = false;
    private int max_radials = 0;
    private int min_radials = Integer.MAX_VALUE;
    private boolean debugRadials = false;

    SigmetVolumeScan(RandomAccessFile raf, NetcdfFile ncfile, ArrayList<Variable> varList) throws IOException {
        int REC_SIZE = 6144;
        int len = 12288;
        short nrec = 0;
        short nsweep = 1;
        short nray = 0;
        short byteoff = 0;
        int nwords = 0;
        int end_words = 0;
        int data_read = 0;
        int num_zero = 0;
        int rays_count = 0;
        int nb = 0;
        int pos = 0;
        int pos_ray_hdr = 0;
        boolean t = false;
        short a0 = 0;
        short a00 = 0;
        short dty = 1;
        short beg_az = 0;
        short beg_elev = 0;
        short end_az = 0;
        short end_elev = 0;
        int num_bins = 0;
        short time_start_sw = 0;
        float az = 0.0f;
        float elev = 0.0f;
        float d = 0.0f;
        float step = 0.0f;
        boolean beg_rec = true;
        boolean end_rec = true;
        boolean read_ray_hdr = true;
        boolean begin = true;
        int cur_len = len;
        int beg = 1;
        int kk = 0;
        int col = 0;
        int nu = 0;
        boolean bt0 = false;
        boolean bt1 = false;
        boolean start_sweep = true;
        short end_sweep = 1;
        boolean start_ray = true;
        short end_ray = 1;
        this.raf = raf;
        raf.order(1);
        int fileLength = (int)raf.length();
        Map<String, Number> recHdr = SigmetIOServiceProvider.readRecordsHdr(raf);
        int nparams = recHdr.get("nparams").intValue();
        short number_sweeps = recHdr.get("number_sweeps").shortValue();
        short num_rays = recHdr.get("num_rays").shortValue();
        int range_1st = recHdr.get("range_first").intValue();
        float range_first = (float)range_1st * 0.01f;
        int stepp = recHdr.get("range_last").intValue();
        float range_last = (float)stepp * 0.01f;
        short bins = recHdr.get("bins").shortValue();
        short[] num_sweep = new short[nparams];
        short[] num_rays_swp = new short[nparams];
        short[] indx_1ray = new short[nparams];
        short[] num_rays_act = new short[nparams];
        short[] angl_swp = new short[nparams];
        short[] bin_len = new short[nparams];
        short[] data_type = new short[nparams];
        this.num_gates = new int[number_sweeps];
        end_sweep = number_sweeps;
        end_ray = num_rays;
        this.base_time = new int[nparams * number_sweeps];
        this.year = new short[nparams * number_sweeps];
        this.month = new short[nparams * number_sweeps];
        this.day = new short[nparams * number_sweeps];
        ArrayList<Ray> totalPower = new ArrayList<Ray>();
        ArrayList<Ray> velocity = new ArrayList<Ray>();
        ArrayList<Ray> reflectivity = new ArrayList<Ray>();
        ArrayList<Ray> width = new ArrayList<Ray>();
        ArrayList<Ray> diffReflectivity = new ArrayList<Ray>();
        ArrayList time = new ArrayList();
        short irays = num_rays;
        Ray ray = null;
        int two = 0;
        float[] val2 = new float[bins];
        while (len < fileLength) {
            int rayoffset = 0;
            int rayoffset1 = 0;
            int datalen = 0;
            cur_len = len;
            if (nsweep == number_sweeps & rays_count == beg) {
                return;
            }
            if (beg_rec) {
                raf.seek(cur_len);
                nrec = raf.readShort();
                nsweep = raf.readShort();
                byteoff = raf.readShort();
                len += 2;
                nray = raf.readShort();
                len += 2;
                cur_len += 12;
                beg_rec = false;
            }
            if (nsweep <= number_sweeps & rays_count % beg == 0) {
                beg = 0;
                for (int i = 0; i < nparams; ++i) {
                    int idh_len = cur_len + 12 + i * 76;
                    raf.seek(idh_len);
                    this.base_time[nu] = raf.readInt();
                    raf.skipBytes(2);
                    this.year[nu] = raf.readShort();
                    this.month[nu] = raf.readShort();
                    this.day[nu] = raf.readShort();
                    ++nu;
                    num_sweep[i] = raf.readShort();
                    num_rays_swp[i] = raf.readShort();
                    indx_1ray[i] = raf.readShort();
                    raf.skipBytes(2);
                    num_rays_act[i] = raf.readShort();
                    beg += num_rays_act[i];
                    angl_swp[i] = raf.readShort();
                    bin_len[i] = raf.readShort();
                    data_type[i] = raf.readShort();
                }
                cur_len += nparams * 76;
            }
            len = cur_len;
            if (end_rec) {
                raf.seek(cur_len);
                a0 = raf.readShort();
                cur_len += 2;
                if (a0 == 1) {
                    if (cur_len % 6144 == 0) {
                        beg_rec = true;
                        end_rec = true;
                        ++rays_count;
                        read_ray_hdr = true;
                        pos = 0;
                        data_read = 0;
                        nb = 0;
                        len = cur_len;
                        continue;
                    }
                    end_rec = true;
                    len = cur_len;
                    ++rays_count;
                    continue;
                }
                nwords = a0 & Short.MAX_VALUE;
                end_words = nwords - 6;
                data_read = end_words * 2;
                end_rec = false;
                if (cur_len % 6144 == 0) {
                    len = cur_len;
                    read_ray_hdr = true;
                    beg_rec = true;
                    continue;
                }
            }
            len = cur_len;
            dty = data_type[0];
            if (nparams > 1) {
                kk = rays_count % nparams;
                col = rays_count / nparams;
                dty = data_type[kk];
            } else if (number_sweeps > 1) {
                kk = nsweep - 1;
                col = rays_count % irays;
            }
            String var_name = this.data_name[dty];
            if (read_ray_hdr) {
                if (pos_ray_hdr < 2) {
                    raf.seek(cur_len);
                    beg_az = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 2;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 4) {
                    raf.seek(cur_len);
                    beg_elev = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 4;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 6) {
                    raf.seek(cur_len);
                    end_az = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 6;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 8) {
                    raf.seek(cur_len);
                    end_elev = raf.readShort();
                    len = cur_len += 2;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 8;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 10) {
                    raf.seek(cur_len);
                    num_bins = raf.readShort();
                    len = cur_len += 2;
                    if (num_bins % 2 != 0) {
                        num_bins = (short)(num_bins + 1);
                    }
                    this.num_gates[nsweep - 1] = num_bins;
                    if (cur_len % 6144 == 0) {
                        pos_ray_hdr = 10;
                        beg_rec = true;
                        read_ray_hdr = true;
                        continue;
                    }
                }
                if (pos_ray_hdr < 12) {
                    raf.seek(cur_len);
                    time_start_sw = raf.readShort();
                    len = cur_len += 2;
                }
            }
            az = SigmetIOServiceProvider.calcAz(beg_az, end_az);
            elev = SigmetIOServiceProvider.calcElev(end_elev);
            step = SigmetIOServiceProvider.calcStep(range_first, range_last, (short)num_bins);
            if (cur_len % 6144 == 0) {
                len = cur_len;
                beg_rec = true;
                read_ray_hdr = false;
                continue;
            }
            if (pos > 0) {
                data_read -= pos;
                pos = 0;
            }
            if (data_read > 0) {
                raf.seek(cur_len);
                rayoffset = cur_len;
                datalen = data_read;
                for (int i = 0; i < data_read; ++i) {
                    ++nb;
                    if (++cur_len % 6144 != 0) continue;
                    pos = i + 1;
                    beg_rec = true;
                    read_ray_hdr = false;
                    len = cur_len;
                    raf.seek(cur_len);
                    break;
                }
                raf.seek(cur_len);
                if (pos > 0) continue;
            }
            if (cur_len % 6144 == 0) {
                pos = 0;
                beg_rec = true;
                read_ray_hdr = false;
                data_read = 0;
                len = cur_len;
                continue;
            }
            raf.seek(cur_len);
            rayoffset1 = cur_len;
            while (nb < num_bins) {
                a00 = raf.readShort();
                cur_len += 2;
                if (a00 == 1) {
                    ray = new Ray(-999.99f, -999.99f, -999.99f, -999.99f, (short)num_bins, -99, -999, 0, -999, nsweep, var_name, dty);
                    ++rays_count;
                    beg_rec = false;
                    end_rec = true;
                    break;
                }
                if (a00 < 0) {
                    nwords = a00 & Short.MAX_VALUE;
                    data_read = nwords * 2;
                    if (cur_len % 6144 == 0) {
                        pos = 0;
                        beg_rec = true;
                        end_rec = false;
                        len = cur_len;
                        read_ray_hdr = false;
                        break;
                    }
                    raf.seek(cur_len);
                    for (int ii = 0; ii < data_read; ++ii) {
                        ++nb;
                        if (++cur_len % 6144 != 0) continue;
                        pos = ii + 1;
                        beg_rec = true;
                        end_rec = false;
                        len = cur_len;
                        read_ray_hdr = false;
                        raf.seek(cur_len);
                        break;
                    }
                    raf.seek(cur_len);
                    if (pos <= 0) continue;
                    break;
                }
                if (!(a00 > 0 & a00 != 1)) continue;
                num_zero = a00 * 2;
                nb += num_zero;
                if (cur_len % 6144 != 0) continue;
                beg_rec = true;
                end_rec = false;
                read_ray_hdr = false;
                pos = 0;
                data_read = 0;
                len = cur_len;
                break;
            }
            if (cur_len % 6144 == 0) {
                len = cur_len;
                continue;
            }
            raf.seek(cur_len);
            if (nb == num_bins) {
                a00 = raf.readShort();
                cur_len += 2;
                end_rec = true;
                ray = new Ray(range_first, step, az, elev, (short)num_bins, time_start_sw, rayoffset, datalen, rayoffset1, nsweep, var_name, dty);
                ++two;
                if (nsweep == number_sweeps & ++rays_count % beg == 0) {
                    if (var_name.trim().equalsIgnoreCase("TotalPower")) {
                        totalPower.add(ray);
                        break;
                    }
                    if (var_name.trim().equalsIgnoreCase("Reflectivity")) {
                        reflectivity.add(ray);
                        break;
                    }
                    if (var_name.trim().equalsIgnoreCase("Velocity")) {
                        velocity.add(ray);
                        break;
                    }
                    if (var_name.trim().equalsIgnoreCase("Width")) {
                        width.add(ray);
                        break;
                    }
                    if (var_name.trim().equalsIgnoreCase("DifferentialReflectivity")) {
                        diffReflectivity.add(ray);
                        break;
                    }
                    System.out.println(" Error: Unknown Radial Variable found!!");
                    break;
                }
                if (cur_len % 6144 == 0) {
                    beg_rec = true;
                    end_rec = true;
                    read_ray_hdr = true;
                    pos = 0;
                    data_read = 0;
                    nb = 0;
                    len = cur_len;
                    if (var_name.trim().equalsIgnoreCase("TotalPower")) {
                        totalPower.add(ray);
                        continue;
                    }
                    if (var_name.trim().equalsIgnoreCase("Reflectivity")) {
                        reflectivity.add(ray);
                        continue;
                    }
                    if (var_name.trim().equalsIgnoreCase("Velocity")) {
                        velocity.add(ray);
                        continue;
                    }
                    if (var_name.trim().equalsIgnoreCase("Width")) {
                        width.add(ray);
                        continue;
                    }
                    if (var_name.trim().equalsIgnoreCase("DifferentialReflectivity")) {
                        diffReflectivity.add(ray);
                        continue;
                    }
                    System.out.println(" Error: Unknown Radial Variable found!!");
                    continue;
                }
            }
            if (this.firstRay == null) {
                this.firstRay = ray;
            }
            if (var_name.trim().equalsIgnoreCase("TotalPower")) {
                totalPower.add(ray);
            } else if (var_name.trim().equalsIgnoreCase("Reflectivity")) {
                reflectivity.add(ray);
            } else if (var_name.trim().equalsIgnoreCase("Velocity")) {
                velocity.add(ray);
            } else if (var_name.trim().equalsIgnoreCase("Width")) {
                width.add(ray);
            } else if (var_name.trim().equalsIgnoreCase("DifferentialReflectivity")) {
                diffReflectivity.add(ray);
            } else {
                System.out.println(" Error: Unknown Radial Variable found!!");
            }
            pos = 0;
            data_read = 0;
            nb = 0;
            read_ray_hdr = true;
            pos_ray_hdr = 0;
            if (nsweep <= number_sweeps & rays_count % beg == 0) {
                beg_rec = true;
                end_rec = true;
                rays_count = 0;
                nb = 0;
                len = cur_len = 6144 * (nrec + 1);
                read_ray_hdr = true;
            }
            len = cur_len;
        }
        this.lastRay = ray;
        if (reflectivity.size() > 0) {
            this.reflectivityGroups = this.sortScans("reflectivity", reflectivity, 1000);
            this.hasReflectivity = true;
        }
        if (velocity.size() > 0) {
            this.velocityGroups = this.sortScans("velocity", velocity, 1000);
            this.hasVelocity = true;
        }
        if (totalPower.size() > 0) {
            this.totalPowerGroups = this.sortScans("totalPower", totalPower, 1000);
            this.hasTotalPower = true;
        }
        if (width.size() > 0) {
            this.widthGroups = this.sortScans("width", width, 1000);
            this.hasWidth = true;
        }
        if (diffReflectivity.size() > 0) {
            this.differentialReflectivityGroups = this.sortScans("diffReflectivity", diffReflectivity, 1000);
            this.hasDifferentialReflectivity = true;
        }
        if (time.size() > 0) {
            this.timeGroups = this.sortScans("diffReflectivity", diffReflectivity, 1000);
            this.hasTime = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<List<Ray>> sortScans(String name, List<Ray> scans, int siz) {
        HashMap groupHash = new HashMap(siz);
        for (Ray ray : scans) {
            void var7_7;
            List list = (List)groupHash.get((short)ray.nsweep);
            if (null == list) {
                ArrayList arrayList = new ArrayList();
                groupHash.put((short)ray.nsweep, arrayList);
            }
            var7_7.add(ray);
        }
        for (Short aShort : groupHash.keySet()) {
            List list = (List)groupHash.get(aShort);
            Ray[] rr = new Ray[list.size()];
            list.toArray(rr);
            this.checkSort(rr);
        }
        ArrayList<List<Ray>> groups = new ArrayList<List<Ray>>(groupHash.values());
        Collections.sort(groups, new GroupComparator());
        for (List list : groups) {
            this.max_radials = Math.max(this.max_radials, list.size());
            this.min_radials = Math.min(this.min_radials, list.size());
        }
        if (this.debugRadials) {
            System.out.println(name + " min_radials= " + this.min_radials + " max_radials= " + this.max_radials);
            for (List list : groups) {
                Ray lastr = (Ray)list.get(0);
                for (int j = 1; j < list.size(); ++j) {
                    Ray r = (Ray)list.get(j);
                    if (r.getTime() < lastr.getTime()) {
                        System.out.println(" out of order " + j);
                    }
                    lastr = r;
                }
            }
        }
        return groups;
    }

    public List<List<Ray>> getTotalPowerGroups() {
        return this.totalPowerGroups;
    }

    public List<List<Ray>> getVelocityGroups() {
        return this.velocityGroups;
    }

    public List<List<Ray>> getWidthGroups() {
        return this.widthGroups;
    }

    public List<List<Ray>> getReflectivityGroups() {
        return this.reflectivityGroups;
    }

    public List<List<Ray>> getDifferentialReflectivityGroups() {
        return this.differentialReflectivityGroups;
    }

    public int[] getNumberGates() {
        return this.num_gates;
    }

    public int[] getStartSweep() {
        return this.base_time;
    }

    void checkSort(Ray[] r) {
        int i;
        int i2;
        int j = 0;
        int n = 0;
        int n1 = 0;
        int n2 = 0;
        short time1 = 0;
        short time2 = 0;
        int[] k1 = new int[300];
        int[] k2 = new int[300];
        for (int i3 = 0; i3 < r.length - 1; ++i3) {
            time1 = r[i3].getTime();
            if (time1 == (time2 = r[i3 + 1].getTime())) continue;
            k2[j] = i3;
            k1[++j] = i3 + 1;
        }
        if (k2[j] < r.length - 1) {
            k1[j] = k2[j - 1] + 1;
            k2[j] = r.length - 1;
            n = j + 1;
        }
        int it1 = 0;
        int it2 = 0;
        for (int ii = 0; ii < j + 1; ++ii) {
            n1 = k1[ii];
            for (int i4 = 0; i4 < j + 1; ++i4) {
                if (i4 == ii) continue;
                n2 = k1[i4];
                if (r[n1].getTime() != r[n2].getTime()) continue;
                it1 = ii;
                it2 = i4;
            }
        }
        n1 = k1[it1];
        n2 = k1[it2];
        int s1 = k2[it1] - k1[it1] + 1;
        int s2 = k2[it2] - k1[it2] + 1;
        float[] t0 = new float[s1];
        float[] t00 = new float[s2];
        for (i2 = 0; i2 < s1; ++i2) {
            t0[i2] = r[n1 + i2].getAz();
        }
        for (i2 = 0; i2 < s2; ++i2) {
            t00[i2] = r[n2 + i2].getAz();
        }
        float mx0 = t0[0];
        for (int i5 = 0; i5 < s1; ++i5) {
            if (!(mx0 < t0[i5])) continue;
            mx0 = t0[i5];
        }
        float mx00 = t00[0];
        for (i = 0; i < s2; ++i) {
            if (!(mx00 < t00[i])) continue;
            mx00 = t00[i];
        }
        if (mx0 > 330.0f & mx00 < 50.0f) {
            for (i = 0; i < s1; ++i) {
                float q = r[n1 + i].getAz();
                r[n1 + i].setAz(q - 360.0f);
            }
        }
        Arrays.sort(r, new RayComparator());
        for (i = 0; i < r.length; ++i) {
            float a = r[i].getAz();
            if (!(a < 0.0f & a > -361.0f)) continue;
            float qa = r[i].getAz();
            r[i].setAz(qa + 360.0f);
        }
    }

    class RayComparator
    implements Comparator<Ray> {
        RayComparator() {
        }

        @Override
        public int compare(Ray ray1, Ray ray2) {
            if (ray1.getTime() < ray2.getTime()) {
                return -1;
            }
            if (ray1.getTime() == ray2.getTime()) {
                if (ray1.getAz() < ray2.getAz()) {
                    return -1;
                }
                if (ray1.getAz() > ray2.getAz()) {
                    return 1;
                }
                if (ray1.getAz() == ray2.getAz()) {
                    return 0;
                }
            } else if (ray1.getTime() > ray2.getTime()) {
                return 1;
            }
            return 0;
        }
    }

    private class GroupComparator
    implements Comparator<List<Ray>> {
        private GroupComparator() {
        }

        @Override
        public int compare(List<Ray> group1, List<Ray> group2) {
            Ray record1 = group1.get(0);
            Ray record2 = group2.get(0);
            return record1.nsweep - record2.nsweep;
        }
    }
}

