/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStreamProto;
import ucar.unidata.io.RandomAccessFile;

public class NcStream {
    public static final byte[] MAGIC_START = new byte[]{67, 68, 70, 83};
    public static final byte[] MAGIC_HEADER = new byte[]{-83, -20, -50, -38};
    public static final byte[] MAGIC_DATA = new byte[]{-85, -20, -50, -70};
    public static final byte[] MAGIC_VDATA = new byte[]{-85, -17, -2, -70};
    public static final byte[] MAGIC_VEND = new byte[]{-19, -17, -2, -38};
    public static final byte[] MAGIC_ERR = new byte[]{-85, -83, -70, -38};
    public static final byte[] MAGIC_END = new byte[]{-19, -19, -34, -34};

    static NcStreamProto.Group.Builder encodeGroup(Group g, int sizeToCache) throws IOException {
        NcStreamProto.Group.Builder groupBuilder = NcStreamProto.Group.newBuilder();
        groupBuilder.setName(g.getShortName());
        for (Dimension dim : g.getDimensions()) {
            groupBuilder.addDims(NcStream.encodeDim(dim));
        }
        for (Attribute att : g.getAttributes()) {
            groupBuilder.addAtts(NcStream.encodeAtt(att));
        }
        for (EnumTypedef enumType : g.getEnumTypedefs()) {
            groupBuilder.addEnumTypes(NcStream.encodeEnumTypedef(enumType));
        }
        for (Variable var : g.getVariables()) {
            if (var instanceof Structure) {
                groupBuilder.addStructs(NcStream.encodeStructure((Structure)var));
                continue;
            }
            groupBuilder.addVars(NcStream.encodeVar(var, sizeToCache));
        }
        for (Group ng : g.getGroups()) {
            groupBuilder.addGroups(NcStream.encodeGroup(ng, sizeToCache));
        }
        return groupBuilder;
    }

    static NcStreamProto.Attribute.Builder encodeAtt(Attribute att) {
        NcStreamProto.Attribute.Builder attBuilder = NcStreamProto.Attribute.newBuilder();
        attBuilder.setName(att.getShortName());
        attBuilder.setType(NcStream.encodeAttributeType(att.getDataType()));
        attBuilder.setLen(att.getLength());
        if (att.getLength() > 0) {
            if (att.isString()) {
                for (int i = 0; i < att.getLength(); ++i) {
                    attBuilder.addSdata(att.getStringValue(i));
                }
            } else {
                Array data = att.getValues();
                ByteBuffer bb = data.getDataAsByteBuffer();
                attBuilder.setData(ByteString.copyFrom(bb.array()));
            }
        }
        return attBuilder;
    }

    static NcStreamProto.Dimension.Builder encodeDim(Dimension dim) {
        NcStreamProto.Dimension.Builder dimBuilder = NcStreamProto.Dimension.newBuilder();
        if (dim.getShortName() != null) {
            dimBuilder.setName(dim.getShortName());
        }
        dimBuilder.setLength(dim.getLength());
        if (!dim.isShared()) {
            dimBuilder.setIsPrivate(true);
        }
        if (dim.isVariableLength()) {
            dimBuilder.setIsVlen(true);
        }
        if (dim.isUnlimited()) {
            dimBuilder.setIsUnlimited(true);
        }
        return dimBuilder;
    }

    static NcStreamProto.EnumTypedef.Builder encodeEnumTypedef(EnumTypedef enumType) throws IOException {
        NcStreamProto.EnumTypedef.Builder builder = NcStreamProto.EnumTypedef.newBuilder();
        builder.setName(enumType.getShortName());
        Map<Integer, String> map = enumType.getMap();
        NcStreamProto.EnumTypedef.EnumType.Builder b2 = NcStreamProto.EnumTypedef.EnumType.newBuilder();
        for (int code : map.keySet()) {
            b2.clear();
            b2.setCode(code);
            b2.setValue(map.get(code));
            builder.addMap(b2);
        }
        return builder;
    }

    static NcStreamProto.Variable.Builder encodeVar(Variable var, int sizeToCache) throws IOException {
        Iterator<Attribute> enumType;
        NcStreamProto.Variable.Builder builder = NcStreamProto.Variable.newBuilder();
        builder.setName(var.getShortName());
        builder.setDataType(NcStream.encodeDataType(var.getDataType()));
        if (var.isUnsigned()) {
            builder.setUnsigned(true);
        }
        if (var.getDataType().isEnum() && (enumType = var.getEnumTypedef()) != null) {
            builder.setEnumType(((CDMNode)((Object)enumType)).getShortName());
        }
        for (Dimension dim : var.getDimensions()) {
            builder.addShape(NcStream.encodeDim(dim));
        }
        for (Attribute att : var.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        if (var.isCaching() && var.getDataType().isNumeric() && (var.isCoordinateVariable() || var.getSize() * (long)var.getElementSize() < (long)sizeToCache)) {
            Array data = var.read();
            ByteBuffer bb = data.getDataAsByteBuffer();
            builder.setData(ByteString.copyFrom(bb.array()));
        }
        return builder;
    }

    static NcStreamProto.Structure.Builder encodeStructure(Structure s) throws IOException {
        NcStreamProto.Structure.Builder builder = NcStreamProto.Structure.newBuilder();
        builder.setName(s.getShortName());
        builder.setDataType(NcStream.encodeDataType(s.getDataType()));
        for (Dimension dim : s.getDimensions()) {
            builder.addShape(NcStream.encodeDim(dim));
        }
        for (Attribute att : s.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        for (Variable v : s.getVariables()) {
            if (v instanceof Structure) {
                builder.addStructs(NcStream.encodeStructure((Structure)v));
                continue;
            }
            builder.addVars(NcStream.encodeVar(v, -1));
        }
        return builder;
    }

    public static NcStreamProto.Error encodeErrorMessage(String message) {
        NcStreamProto.Error.Builder builder = NcStreamProto.Error.newBuilder();
        builder.setMessage(message);
        return builder.build();
    }

    static NcStreamProto.Data encodeDataProto(Variable var, Section section, NcStreamProto.Compress compressionType, ByteOrder bo, int uncompressedLength) {
        NcStreamProto.Data.Builder builder = NcStreamProto.Data.newBuilder();
        builder.setVarName(var.getFullNameEscaped());
        builder.setDataType(NcStream.encodeDataType(var.getDataType()));
        builder.setSection(NcStream.encodeSection(section));
        builder.setCompress(compressionType);
        if (compressionType != NcStreamProto.Compress.NONE) {
            builder.setUncompressedSize(uncompressedLength);
        }
        if (var.isVariableLength()) {
            builder.setVdata(true);
        }
        builder.setBigend(bo == ByteOrder.BIG_ENDIAN);
        builder.setVersion(2);
        return builder.build();
    }

    public static NcStreamProto.Section encodeSection(Section section) {
        NcStreamProto.Section.Builder sbuilder = NcStreamProto.Section.newBuilder();
        for (Range r : section.getRanges()) {
            NcStreamProto.Range.Builder rbuilder = NcStreamProto.Range.newBuilder();
            if (r.first() != 0) {
                rbuilder.setStart(r.first());
            }
            rbuilder.setSize(r.length());
            if (r.stride() != 1) {
                rbuilder.setStride(r.stride());
            }
            sbuilder.addRange(rbuilder);
        }
        return sbuilder.build();
    }

    public static long encodeArrayStructure(ArrayStructure as, ByteOrder bo, OutputStream os) throws IOException {
        long size = 0L;
        ArrayStructureBB dataBB = StructureDataDeep.copyToArrayBB(as, bo, true);
        ArrayList<String> ss = new ArrayList<String>();
        List<Object> heap = dataBB.getHeap();
        ArrayList<Integer> count = new ArrayList<Integer>();
        if (heap != null) {
            for (Object ho : heap) {
                if (ho instanceof String) {
                    count.add(1);
                    ss.add((String)ho);
                    continue;
                }
                if (!(ho instanceof String[])) continue;
                String[] hos = (String[])ho;
                count.add(hos.length);
                for (String s : hos) {
                    ss.add(s);
                }
            }
        }
        StructureMembers sm = dataBB.getStructureMembers();
        ByteBuffer bb = dataBB.getByteBuffer();
        NcStreamProto.StructureData proto = NcStream.encodeStructureDataProto(bb.array(), count, ss, (int)as.getSize(), sm.getStructureSize());
        byte[] datab = proto.toByteArray();
        size += (long)NcStream.writeVInt(os, datab.length);
        os.write(datab);
        return size += (long)datab.length;
    }

    static NcStreamProto.StructureData encodeStructureDataProto(byte[] fixed, List<Integer> count, List<String> ss, int nrows, int rowLength) {
        NcStreamProto.StructureData.Builder builder = NcStreamProto.StructureData.newBuilder();
        builder.setData(ByteString.copyFrom(fixed));
        builder.setNrows(nrows);
        builder.setRowLength(rowLength);
        for (Integer c : count) {
            builder.addHeapCount(c);
        }
        for (String s : ss) {
            builder.addSdata(s);
        }
        return builder.build();
    }

    public static ArrayStructureBB decodeArrayStructure(StructureMembers sm, int[] shape, byte[] proto) throws IOException {
        NcStreamProto.StructureData.Builder builder = NcStreamProto.StructureData.newBuilder();
        builder.mergeFrom(proto);
        long size = 0L;
        ByteBuffer bb = ByteBuffer.wrap(builder.getData().toByteArray());
        ArrayStructureBB dataBB = new ArrayStructureBB(sm, shape, bb, 0);
        List<String> ss = builder.getSdataList();
        List<Integer> count = builder.getHeapCountList();
        int scount = 0;
        for (Integer c : count) {
            if (c == 1) {
                dataBB.addObjectToHeap(ss.get(scount++));
                continue;
            }
            String[] hos = new String[c.intValue()];
            for (int i = 0; i < c; ++i) {
                hos[i] = ss.get(scount++);
            }
            dataBB.addObjectToHeap(hos);
        }
        return dataBB;
    }

    public static StructureData decodeStructureData(StructureMembers sm, ByteOrder bo, byte[] proto) throws IOException {
        NcStreamProto.StructureData.Builder builder = NcStreamProto.StructureData.newBuilder();
        builder.mergeFrom(proto);
        ByteBuffer bb = ByteBuffer.wrap(builder.getData().toByteArray());
        bb.order(bo);
        ArrayStructureBB dataBB = new ArrayStructureBB(sm, new int[]{1}, bb, 0);
        List<String> ss = builder.getSdataList();
        List<Integer> count = builder.getHeapCountList();
        int scount = 0;
        for (Integer c : count) {
            if (c == 1) {
                dataBB.addObjectToHeap(ss.get(scount++));
                continue;
            }
            String[] hos = new String[c.intValue()];
            for (int i = 0; i < c; ++i) {
                hos[i] = ss.get(scount++);
            }
            dataBB.addObjectToHeap(hos);
        }
        return dataBB.getStructureData(0);
    }

    static void show(NcStreamProto.Header proto) throws InvalidProtocolBufferException {
        NcStreamProto.Group root = proto.getRoot();
        for (NcStreamProto.Dimension dim : root.getDimsList()) {
            System.out.println("dim= " + dim);
        }
        for (NcStreamProto.Attribute att : root.getAttsList()) {
            System.out.println("att= " + att);
        }
        for (NcStreamProto.Variable var : root.getVarsList()) {
            System.out.println("var= " + var);
        }
    }

    static int writeByte(OutputStream out, byte b) throws IOException {
        out.write(b);
        return 1;
    }

    static int writeBytes(OutputStream out, byte[] b, int offset, int length) throws IOException {
        out.write(b, offset, length);
        return length;
    }

    public static int writeBytes(OutputStream out, byte[] b) throws IOException {
        return NcStream.writeBytes(out, b, 0, b.length);
    }

    public static int writeVInt(OutputStream out, int value) throws IOException {
        int count = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            NcStream.writeByte(out, (byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        NcStream.writeByte(out, (byte)value);
        return count + 1;
    }

    public static int writeVInt(RandomAccessFile out, int value) throws IOException {
        int count = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            out.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        out.write((byte)value);
        return count + 1;
    }

    public static int writeVInt(WritableByteChannel wbc, int value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            bb.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        bb.put((byte)value);
        bb.flip();
        wbc.write(bb);
        return bb.limit();
    }

    static int writeVLong(OutputStream out, long i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            NcStream.writeByte(out, (byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
            ++count;
        }
        NcStream.writeByte(out, (byte)i);
        return count + 1;
    }

    public static int readVInt(InputStream is) throws IOException {
        int ib = is.read();
        if (ib == -1) {
            return -1;
        }
        byte b = (byte)ib;
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            ib = is.read();
            if (ib == -1) {
                return -1;
            }
            b = (byte)ib;
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static int readVInt(RandomAccessFile raf) throws IOException {
        int ib = raf.read();
        if (ib == -1) {
            return -1;
        }
        byte b = (byte)ib;
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            ib = raf.read();
            if (ib == -1) {
                return -1;
            }
            b = (byte)ib;
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static int readFully(InputStream is, byte[] b) throws IOException {
        int bytesRead;
        int done = 0;
        for (int want = b.length; want > 0 && (bytesRead = is.read(b, done, want)) != -1; want -= bytesRead) {
            done += bytesRead;
        }
        return done;
    }

    public static boolean readAndTest(InputStream is, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        NcStream.readFully(is, b);
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean readAndTest(RandomAccessFile raf, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        raf.readFully(b);
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean test(Byte[] b, byte[] test) throws IOException {
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public static String decodeErrorMessage(NcStreamProto.Error err) {
        return err.getMessage();
    }

    static Dimension decodeDim(NcStreamProto.Dimension dim) {
        String name = !dim.hasName() || dim.getName().length() == 0 ? null : dim.getName();
        return new Dimension(name, (int)dim.getLength(), !dim.getIsPrivate(), dim.getIsUnlimited(), dim.getIsVlen());
    }

    static void readGroup(NcStreamProto.Group proto, NetcdfFile ncfile, Group g) throws InvalidProtocolBufferException {
        for (NcStreamProto.Dimension dim : proto.getDimsList()) {
            g.addDimension(NcStream.decodeDim(dim));
        }
        for (NcStreamProto.Attribute att : proto.getAttsList()) {
            g.addAttribute(NcStream.decodeAtt(att));
        }
        for (NcStreamProto.EnumTypedef enumType : proto.getEnumTypesList()) {
            g.addEnumeration(NcStream.decodeEnumTypedef(enumType));
        }
        for (NcStreamProto.Variable var : proto.getVarsList()) {
            g.addVariable(NcStream.decodeVar(ncfile, g, null, var));
        }
        for (NcStreamProto.Structure s : proto.getStructsList()) {
            g.addVariable(NcStream.decodeStructure(ncfile, g, null, s));
        }
        for (NcStreamProto.Group gp : proto.getGroupsList()) {
            Group ng = new Group(ncfile, g, gp.getName());
            g.addGroup(ng);
            NcStream.readGroup(gp, ncfile, ng);
        }
    }

    static EnumTypedef decodeEnumTypedef(NcStreamProto.EnumTypedef enumType) {
        List<NcStreamProto.EnumTypedef.EnumType> list = enumType.getMapList();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * list.size());
        for (NcStreamProto.EnumTypedef.EnumType et : list) {
            map.put(et.getCode(), et.getValue());
        }
        return new EnumTypedef(enumType.getName(), map);
    }

    static Attribute decodeAtt(NcStreamProto.Attribute attp) {
        int len = attp.getLen();
        if (len == 0) {
            return new Attribute(attp.getName(), NcStream.decodeAttributeType(attp.getType()), false);
        }
        DataType dt = NcStream.decodeAttributeType(attp.getType());
        if (dt == DataType.STRING) {
            int lenp = attp.getSdataCount();
            if (lenp != len) {
                System.out.println("HEY lenp != len");
            }
            if (lenp == 1) {
                return new Attribute(attp.getName(), attp.getSdata(0));
            }
            Array data = Array.factory(dt, new int[]{lenp});
            for (int i = 0; i < lenp; ++i) {
                data.setObject(i, (Object)attp.getSdata(i));
            }
            return new Attribute(attp.getName(), data);
        }
        ByteString bs = attp.getData();
        ByteBuffer bb = ByteBuffer.wrap(bs.toByteArray());
        return new Attribute(attp.getName(), Array.factory(NcStream.decodeAttributeType(attp.getType()), null, bb));
    }

    static Variable decodeVar(NetcdfFile ncfile, Group g, Structure parent, NcStreamProto.Variable var) {
        String enumName;
        Iterator<NcStreamProto.Attribute> enumType;
        Variable ncvar = new Variable(ncfile, g, parent, var.getName());
        DataType varType = NcStream.decodeDataType(var.getDataType());
        ncvar.setDataType(NcStream.decodeDataType(var.getDataType()));
        if (varType.isEnum() && (enumType = g.findEnumeration(enumName = var.getEnumType())) != null) {
            ncvar.setEnumTypedef((EnumTypedef)((Object)enumType));
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        for (NcStreamProto.Dimension dim : var.getShapeList()) {
            Dimension ncdim = NcStream.decodeDim(dim);
            if (!ncdim.isShared()) {
                dims.add(ncdim);
                continue;
            }
            Dimension d = g.findDimension(ncdim.getShortName());
            if (d == null) {
                throw new IllegalStateException("Can find shared dimension " + dim.getName());
            }
            dims.add(d);
        }
        ncvar.setDimensions(dims);
        for (NcStreamProto.Attribute att : var.getAttsList()) {
            ncvar.addAttribute(NcStream.decodeAtt(att));
        }
        if (var.getUnsigned()) {
            ncvar.addAttribute(new Attribute("_Unsigned", "true"));
        }
        if (var.hasData()) {
            ByteBuffer bb = ByteBuffer.wrap(var.getData().toByteArray());
            Array data = Array.factory(varType, ncvar.getShape(), bb);
            ncvar.setCachedData(data, false);
        }
        return ncvar;
    }

    static Structure decodeStructure(NetcdfFile ncfile, Group g, Structure parent, NcStreamProto.Structure s) {
        Structure ncvar = s.getDataType() == NcStreamProto.DataType.SEQUENCE ? new Sequence(ncfile, g, parent, s.getName()) : new Structure(ncfile, g, parent, s.getName());
        ncvar.setDataType(NcStream.decodeDataType(s.getDataType()));
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        for (NcStreamProto.Dimension dim : s.getShapeList()) {
            Dimension ncdim = NcStream.decodeDim(dim);
            if (!ncdim.isShared()) {
                dims.add(ncdim);
                continue;
            }
            Dimension d = g.findDimension(ncdim.getShortName());
            if (d == null) {
                throw new IllegalStateException("Can find shared dimension " + dim.getName());
            }
            dims.add(d);
        }
        ncvar.setDimensions(dims);
        for (NcStreamProto.Attribute att : s.getAttsList()) {
            ncvar.addAttribute(NcStream.decodeAtt(att));
        }
        for (NcStreamProto.Variable vp : s.getVarsList()) {
            ncvar.addMemberVariable(NcStream.decodeVar(ncfile, g, ncvar, vp));
        }
        for (NcStreamProto.Structure sp : s.getStructsList()) {
            ncvar.addMemberVariable(NcStream.decodeStructure(ncfile, g, ncvar, sp));
        }
        return ncvar;
    }

    public static Section decodeSection(NcStreamProto.Section proto) {
        Section section = new Section();
        for (NcStreamProto.Range pr : proto.getRangeList()) {
            try {
                section.appendRange((int)pr.getStart(), (int)(pr.getStart() + pr.getSize() - 1L));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                return null;
            }
        }
        return section;
    }

    static NcStreamProto.Attribute.Type encodeAttributeType(DataType dtype) {
        switch (dtype) {
            case CHAR: 
            case STRING: {
                return NcStreamProto.Attribute.Type.STRING;
            }
            case BYTE: {
                return NcStreamProto.Attribute.Type.BYTE;
            }
            case SHORT: {
                return NcStreamProto.Attribute.Type.SHORT;
            }
            case INT: {
                return NcStreamProto.Attribute.Type.INT;
            }
            case LONG: {
                return NcStreamProto.Attribute.Type.LONG;
            }
            case FLOAT: {
                return NcStreamProto.Attribute.Type.FLOAT;
            }
            case DOUBLE: {
                return NcStreamProto.Attribute.Type.DOUBLE;
            }
        }
        throw new IllegalStateException("illegal att type " + (Object)((Object)dtype));
    }

    public static NcStreamProto.DataType encodeDataType(DataType dtype) {
        switch (dtype) {
            case CHAR: {
                return NcStreamProto.DataType.CHAR;
            }
            case BYTE: {
                return NcStreamProto.DataType.BYTE;
            }
            case SHORT: {
                return NcStreamProto.DataType.SHORT;
            }
            case INT: {
                return NcStreamProto.DataType.INT;
            }
            case LONG: {
                return NcStreamProto.DataType.LONG;
            }
            case FLOAT: {
                return NcStreamProto.DataType.FLOAT;
            }
            case DOUBLE: {
                return NcStreamProto.DataType.DOUBLE;
            }
            case STRING: {
                return NcStreamProto.DataType.STRING;
            }
            case STRUCTURE: {
                return NcStreamProto.DataType.STRUCTURE;
            }
            case SEQUENCE: {
                return NcStreamProto.DataType.SEQUENCE;
            }
            case ENUM1: {
                return NcStreamProto.DataType.ENUM1;
            }
            case ENUM2: {
                return NcStreamProto.DataType.ENUM2;
            }
            case ENUM4: {
                return NcStreamProto.DataType.ENUM4;
            }
            case OPAQUE: {
                return NcStreamProto.DataType.OPAQUE;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    static DataType decodeAttributeType(NcStreamProto.Attribute.Type dtype) {
        switch (dtype) {
            case STRING: {
                return DataType.STRING;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case SHORT: {
                return DataType.SHORT;
            }
            case INT: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalStateException("illegal att type " + dtype);
    }

    public static DataType decodeDataType(NcStreamProto.DataType dtype) {
        switch (dtype) {
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case SHORT: {
                return DataType.SHORT;
            }
            case INT: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case STRING: {
                return DataType.STRING;
            }
            case STRUCTURE: {
                return DataType.STRUCTURE;
            }
            case SEQUENCE: {
                return DataType.SEQUENCE;
            }
            case ENUM1: {
                return DataType.ENUM1;
            }
            case ENUM2: {
                return DataType.ENUM2;
            }
            case ENUM4: {
                return DataType.ENUM4;
            }
            case OPAQUE: {
                return DataType.OPAQUE;
            }
        }
        throw new IllegalStateException("illegal data type " + dtype);
    }
}

