/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.directoryOperation;

import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketCoding {
    final Logger logger = LoggerFactory.getLogger(BucketCoding.class);
    public static final String SEPARATOR = "_-_";
    public String file_separator = "/";

    public String bucketFileCoding(String path, String rootArea) {
        if (!ObjectId.isValid(path)) {
            String absolutePath = path;
            if (rootArea.length() > 0) {
                path = absolutePath = this.mergingPathAndFile(rootArea, path);
            }
            if (!"mongo".equalsIgnoreCase("mongo")) {
                String string = absolutePath.replaceAll(this.file_separator, SEPARATOR);
            }
        }
        return path;
    }

    public String mergingPathAndDir(String rootArea, String path) {
        char c = rootArea.charAt(rootArea.length() - 1);
        if ((c + "").equalsIgnoreCase(this.file_separator)) {
            rootArea = rootArea.substring(0, rootArea.length() - 1);
        }
        if (!((c = path.charAt(0)) + "").equalsIgnoreCase(this.file_separator)) {
            path = this.file_separator + path;
        }
        if (!((c = path.charAt(path.length() - 1)) + "").equalsIgnoreCase(this.file_separator)) {
            path = path + this.file_separator;
        }
        String bucketName = rootArea + path;
        return bucketName;
    }

    public String checkSintaxDir(String path) {
        char c = path.charAt(0);
        if (!(c + "").equalsIgnoreCase(this.file_separator)) {
            path = this.file_separator + path;
        }
        if (!((c = path.charAt(path.length() - 1)) + "").equalsIgnoreCase(this.file_separator)) {
            path = path + this.file_separator;
        }
        String bucketName = path;
        return bucketName;
    }

    private String mergingPathAndFile(String rootArea, String path) {
        char c = rootArea.charAt(rootArea.length() - 1);
        if ((c + "").equalsIgnoreCase(this.file_separator)) {
            rootArea = rootArea.substring(0, rootArea.length() - 1);
        }
        if (!((c = path.charAt(0)) + "").equalsIgnoreCase(this.file_separator)) {
            path = this.file_separator + path;
        }
        if (((c = path.charAt(path.length() - 1)) + "").equalsIgnoreCase(this.file_separator)) {
            path = path.substring(0, path.length() - 1);
        }
        String bucketName = rootArea + path;
        return bucketName;
    }

    public String bucketFileDecoding(String key, String rootArea) {
        String nameDecoded = key;
        if (!"mongo".equalsIgnoreCase("mongo")) {
            String[] splits = key.split(SEPARATOR);
            nameDecoded = splits[splits.length - 1];
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("decodeBucketFile(String) - end");
        }
        return nameDecoded;
    }

    public String bucketDirCoding(String dir, String rootArea) {
        if (!"mongo".equalsIgnoreCase("mongo")) {
            dir = dir.replaceAll(this.file_separator, SEPARATOR);
        }
        dir = this.mergingPathAndDir(rootArea, dir);
        return dir;
    }

    public String bucketDirDecoding(String key, String rootArea) {
        if (!"mongo".equalsIgnoreCase("mongo")) {
            String lastChar = key.substring(key.length() - 3);
            if (lastChar.equalsIgnoreCase(SEPARATOR)) {
                String[] extractPath = key.split(SEPARATOR);
                String[] rootPath = rootArea.split(this.file_separator);
                key = "";
                for (int i = rootPath.length; i < extractPath.length; ++i) {
                    key = key + this.file_separator + extractPath[i];
                }
                key = key + this.file_separator;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("found directory: " + key);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found object coded: " + key);
                }
                key = this.bucketFileDecoding(key, rootArea);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("found object: " + key);
                }
            }
        }
        return key;
    }

    public boolean isFileObject(String key) {
        String lastChar = key.substring(key.length() - 3);
        return !lastChar.equalsIgnoreCase(SEPARATOR);
    }
}

