/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.Encrypter;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class GetUrl
extends Operation {
    private OutputStream os;
    public static final String URL_SEPARATOR = "/";

    public GetUrl(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public Object doIt(MyFile myFile) throws RemoteBackendException {
        String resolverHost = myFile.getResolverHOst();
        String urlBase = "smp://" + resolverHost + URL_SEPARATOR;
        String urlParam = "";
        try {
            String id = this.getId(this.bucket);
            this.logger.debug("encrypting string " + id);
            urlParam = new Encrypter("DES").encrypt(id);
            this.logger.debug(" string encrypted " + urlParam);
        }
        catch (Encrypter.EncryptionException e) {
            throw new RemoteBackendException(" Error in getUrl operation problem to encrypt the string", e.getCause());
        }
        this.logger.info("URL generated: " + urlBase + urlParam);
        return urlBase + urlParam;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String buck = null;
        BucketCoding bc = new BucketCoding();
        this.bucket = buck = bc.bucketFileCoding(remotePath, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }

    private String getId(String path) {
        String id = null;
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType);
        long dim = 0L;
        try {
            id = tm.getId(this.bucket);
        }
        catch (Exception e) {
            throw new RemoteBackendException(" Error in GetSize operation ", e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        return id;
    }

    private String retrieveRootScope(String scope) {
        ScopeBean sb = new ScopeBean(scope);
        while (!sb.is(ScopeBean.Type.INFRASTRUCTURE)) {
            sb = sb.enclosingScope();
        }
        return sb.name();
    }
}

