/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.List;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDir
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String sourcePath;
    private String destinationPath;
    private OutputStream os;

    public MoveDir(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.sourcePath = file.getLocalPath();
        this.destinationPath = remotePath;
        this.sourcePath = new BucketCoding().bucketFileCoding(file.getLocalPath(), rootArea);
        this.bucket = this.destinationPath = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        return this.bucket;
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType);
        List<String> ids = null;
        try {
            ids = tm.moveDir(myFile, this.sourcePath, this.destinationPath);
        }
        catch (UnknownHostException e) {
            this.logger.error("Problem in moveDir from: " + this.sourcePath + " to: " + this.destinationPath + ": " + e.getMessage());
            throw new RemoteBackendException(" Error in moveDir operation ", e.getCause());
        }
        return ids.toString();
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        DirectoryBucket dirBuc = new DirectoryBucket(server, this.user, this.password, remotePath, author);
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        this.sourcePath = resource.getLocalPath();
        this.destinationPath = resource.getRemotePath();
        this.sourcePath = new BucketCoding().bucketFileCoding(resource.getLocalPath(), rootArea);
        this.bucket = this.destinationPath = new BucketCoding().bucketFileCoding(resource.getRemotePath(), rootArea);
        return this.bucket;
    }
}

