/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport;

import com.mongodb.MongoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;

public abstract class TransportManager {
    public abstract String getName();

    public abstract void initBackend(String[] var1);

    public String downloadManager(MyFile myFile, String key, Class<? extends Object> type) throws IOException {
        String key4lock = null;
        if (myFile.isLock()) {
            key4lock = this.lock(myFile, key, type);
            return key4lock;
        }
        return this.get(myFile, key, type).toString();
    }

    public String uploadManager(Object resource, String bucket, String key, boolean replace) throws FileNotFoundException, UnknownHostException {
        String id = null;
        MyFile file = (MyFile)resource;
        id = file.getLockedKey() != null && !file.getLockedKey().isEmpty() ? this.unlock(resource, bucket, key, file.getLockedKey()) : this.put(resource, bucket, key, replace);
        return id;
    }

    public abstract Object get(MyFile var1, String var2, Class<? extends Object> var3) throws FileNotFoundException, IOException;

    public abstract String put(Object var1, String var2, String var3, boolean var4) throws UnknownHostException;

    public abstract Map getValues(MyFile var1, String var2, Class<? extends Object> var3) throws UnknownHostException;

    public abstract void removeRemoteFile(String var1, MyFile var2) throws UnknownHostException;

    public abstract void removeDir(String var1, MyFile var2) throws UnknownHostException;

    public abstract long getSize(String var1) throws UnknownHostException;

    public abstract String lock(MyFile var1, String var2, Class<? extends Object> var3) throws IOException;

    public abstract String unlock(Object var1, String var2, String var3, String var4) throws FileNotFoundException, UnknownHostException, MongoException;

    public abstract long getTTL(String var1) throws UnknownHostException;

    public abstract long renewTTL(MyFile var1) throws UnknownHostException, IllegalAccessException;

    public abstract String link(MyFile var1, String var2, String var3) throws UnknownHostException;

    public abstract String copy(MyFile var1, String var2, String var3) throws UnknownHostException;

    public abstract String move(MyFile var1, String var2, String var3) throws UnknownHostException;

    public abstract List<String> copyDir(MyFile var1, String var2, String var3) throws UnknownHostException;

    public abstract List<String> moveDir(MyFile var1, String var2, String var3) throws UnknownHostException;

    public abstract String getFileProperty(String var1, String var2) throws UnknownHostException;

    public abstract long getFolderTotalItems(String var1) throws UnknownHostException;

    public abstract long getFolderTotalVolume(String var1) throws UnknownHostException;

    public abstract String getUserTotalVolume(String var1) throws UnknownHostException;

    public abstract String getUserTotalItems(String var1) throws UnknownHostException;

    public abstract String getId(String var1) throws UnknownHostException;

    public abstract String getField(String var1, String var2) throws UnknownHostException;

    public abstract void close();
}

