/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPurl;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringDecrypter;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionById
extends SMPurl {
    public static final String INFRASTRUCTURE_ENV_VARIABLE_NAME = "infrastructure";
    private static final String GCUBE_RESOLVER_HOST = "data.gcube.org";
    private static final String D4SCIENCE_RESOLVER_HOST = "data.d4science.org";
    private static final String GCUBE_INFRA = "gcube";
    private static final String D4SCIENCE_INFRA = "d4science.research-infrastructures.eu";
    private Logger logger = LoggerFactory.getLogger(SMPURLConnection.class);
    private String serviceClass = "Storage-manager";
    private String serviceName = "resolver-uri";
    private String owner = "storage-manager";

    public SMPURLConnectionById(URL url) {
        super(url);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            StringWriter w = new StringWriter();
            return this.storageClient(this.url.toString());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private InputStream storageClient(String url) throws Exception {
        this.logger.info("url :" + url);
        String[] urlParam = url.split("/");
        String infrastructure = this.extractInfrastructureNewVersion(urlParam[2]);
        String rootScope = "/" + infrastructure;
        this.logger.debug("infrastructure: " + rootScope);
        String encrypted = this.retrieveStringEncrypted(urlParam);
        this.logger.debug("String encrypted " + encrypted);
        String phrase = this.retrieveEncryptionPhrase(rootScope);
        String location = new StringDecrypter("DES", phrase).decrypt(encrypted);
        this.logger.info("String decrypted: " + location);
        IClient client = null;
        String currentScope = ScopeProvider.instance.get();
        this.logger.info("current scope found(ScopeProvider): " + currentScope + ". Setting scope before  call StorageClient object: " + rootScope);
        ScopeProvider.instance.set(rootScope);
        client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED).getClient();
        InputStream is = null;
        is = client.get().RFileAsInputStream(location);
        ScopeProvider.instance.set(currentScope);
        return is;
    }

    private String extractInfrastructureNewVersion(String urlParam) {
        this.logger.debug("urlParam: " + urlParam);
        String infra = this.checkVarEnvInfra();
        if (infra != null) {
            return infra;
        }
        return this.getInfraFromResolverHost(urlParam);
    }

    private String getInfraFromResolverHost(String resolverHost) {
        if (resolverHost.equals(GCUBE_RESOLVER_HOST)) {
            return GCUBE_INFRA;
        }
        if (resolverHost.equals(D4SCIENCE_RESOLVER_HOST)) {
            return D4SCIENCE_INFRA;
        }
        return resolverHost;
    }

    private String checkVarEnvInfra() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String infra = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase(INFRASTRUCTURE_ENV_VARIABLE_NAME)) continue;
            infra = env.get(key);
            break;
        }
        return infra;
    }

    private String retrieveStringEncrypted(String[] urlParam) {
        String encrypted = urlParam[3];
        for (int i = 4; i < urlParam.length; ++i) {
            encrypted = encrypted + "/" + urlParam[i];
        }
        return encrypted;
    }

    private String retrieveEncryptionPhrase(String rootScope) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String scope = rootScope;
        ScopeProvider.instance.set(scope);
        this.logger.debug("set scope: " + scope);
        String encryptedKey = null;
        ISClientConnector isclient = new ISClientConnector();
        encryptedKey = isclient.retrievePropertyValue("PassPhrase", scope);
        String decryptString = StringEncrypter.getEncrypter().decrypt(encryptedKey, new Key[0]);
        ScopeProvider.instance.set(currentScope);
        return decryptString;
    }

    private String extractRootScope(String url) {
        String rootScope = null;
        String[] loc = url.split("//");
        this.logger.debug("infrastructure extracted: " + loc[1]);
        String[] params = loc[1].split("#");
        rootScope = params[0];
        this.logger.info("infrastructure: " + rootScope);
        return rootScope;
    }

    private String extractLocation(String url) {
        String location = null;
        String[] loc = url.split("//");
        this.logger.debug("location extracted: " + loc[1]);
        String[] params = loc[1].split("#");
        location = params[1];
        this.logger.info("MongoID " + location);
        return location;
    }

    private String extractInfrastructure(String url) {
        String rootScope = null;
        String[] loc = url.split("//");
        rootScope = loc[1];
        this.logger.debug("infrastructure extracted: " + rootScope);
        return rootScope;
    }

    private String extractLocationNew(String url) {
        String location = null;
        String[] loc = url.split("//");
        this.logger.debug("location extracted: " + loc[1]);
        String[] params = loc[1].split("#");
        location = params[1];
        this.logger.info("MongoID " + location);
        return location;
    }

    private void createFileTest(InputStream is) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File("/home/rcirillo/FilePerTest/uriSMPTest.jpg"));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            is.close();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info("New file created!");
    }
}

