/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.LazyBSONCallback;
import org.bson.io.Bits;

public class LazyBSONDecoder
implements BSONDecoder {
    byte[] _buffer = null;

    public BSONObject readObject(byte[] b) {
        try {
            return this.readObject(new ByteArrayInputStream(b));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        LazyBSONCallback c = new LazyBSONCallback();
        this.decode(in, (BSONCallback)c);
        return (BSONObject)c.get();
    }

    public int decode(byte[] b, BSONCallback callback) {
        try {
            return this.decode(new ByteArrayInputStream(b), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        byte[] data = null;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        int read = this.readBytesFully(in, this._buffer, 0, 4);
        int objSize = Bits.readInt(this._buffer);
        if (objSize > this._buffer.length) {
            data = new byte[objSize];
            System.arraycopy(this._buffer, 0, data, 0, read);
        } else {
            data = this._buffer;
            this._buffer = null;
        }
        if (read < objSize) {
            this.readBytesFully(in, data, read, objSize - read);
        }
        callback.gotBinary(null, (byte)0, data);
        return objSize + 4;
    }

    private int readBytesFully(InputStream in, byte[] buffer, int offset, int toread) throws IOException {
        int read = 0;
        int len = buffer.length;
        while (read < toread) {
            int n = in.read(buffer, offset, toread - read);
            read += n;
            offset += n;
        }
        return read;
    }
}

