/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import java.net.UnknownHostException;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Link
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String sourcePath;
    private String destinationPath;
    private OutputStream os;

    public Link(String[] server, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.sourcePath = file.getPathClient();
        this.destinationPath = remotePath;
        this.sourcePath = new BucketCoding().bucketFileCoding(file.getPathClient(), author, rootArea);
        this.bucket = this.destinationPath = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        return this.bucket;
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport(this.backendType);
        String id = null;
        try {
            id = tm.link(myFile, this.sourcePath, this.destinationPath);
        }
        catch (UnknownHostException e) {
            throw new RemoteBackendException(" Error in link operation ", e.getCause());
        }
        return id;
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        DirectoryBucket dirBuc = new DirectoryBucket(server, remotePath, author);
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        this.sourcePath = resource.getPathClient();
        this.destinationPath = resource.getPathServer();
        this.sourcePath = new BucketCoding().bucketFileCoding(resource.getPathClient(), author, rootArea);
        this.bucket = this.destinationPath = new BucketCoding().bucketFileCoding(resource.getPathServer(), author, rootArea);
        return this.bucket;
    }
}

