/**
 * 
 */
package org.gcube.dataanalysis.executor.plugin;

import java.util.HashMap;
import java.util.Map;


import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
//import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;

import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.dataanalysis.executor.scripts.OSCommandGenericWorker;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.LoggerFactory;


public class GenericWorkerPluginDeclaration implements PluginDeclaration {

	/**{@inheritDoc}*/
	@Override
	public void init() throws Exception {
		DirContextURLStreamHandlerFactory.addUserFactory(new ConfigurableStreamHandlerFactory("smp", new Handler()));
		
		/*
		 * TomcatURLStreamHandlerFactory ushf = TomcatURLStreamHandlerFactory.getInstance();
		 * boolean registered = TomcatURLStreamHandlerFactory.register();
		 * if(!registered){
		 * 		throw new Exception();
		 * }
		 * ushf.addUserFactory(new ConfigurableStreamHandlerFactory("smp", new Handler()));
		*/
	}
	
	/** {@inheritDoc} */
	@Override
	public String getName() {
		return "SmartGenericWorker";
	}

	/** {@inheritDoc} */
	@Override
	public Map<String, String> getSupportedCapabilities() {
		HashMap<String,String> properties = new HashMap<String, String>();
		/*
		String rversion = getRVersion();
		
		if (rversion != null)
			properties.put("R version",rversion);
		*/
		return properties;
	}

	/** {@inheritDoc} */
	@Override
	public Class<? extends Plugin<? extends PluginDeclaration>> getPluginImplementation() {
		return GenericWorkerPlugin.class;
	}

	/** {@inheritDoc} */
	@Override
	public String getDescription() {
		return "Smart Generic Worker Description";
	}

	/** {@inheritDoc} */
	@Override
	public String getVersion() {
		return "1.0.3-SNAPSHOT";
	}

	 private String getRVersion(){
		   OSCommandGenericWorker command = new OSCommandGenericWorker();
			String line = null;
			try {
				System.out.println("Getting LINE R Version: "+line);
				line = command.ExecuteGetLine("R -- version",  LoggerFactory.getLogger(GenericWorkerPlugin.class));
				System.out.println("LINE R Version: "+line);
				line = line.substring(0,line.indexOf("(")).trim();
			} catch (Exception e) {
				line = null;
				e.printStackTrace();
			}
			return line;
	   }
	 
}
