/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.CopyDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDirOperator
extends CopyDir {
    Logger logger = LoggerFactory.getLogger(CopyDirOperator.class);

    public CopyDirOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public List<String> execute(MongoIOManager mongoPrimaryInstance, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        String parentFolder = this.extractParent(source);
        String destinationId = null;
        ArrayList<String> idList = null;
        this.logger.debug("copyDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true);
            GridFS gfs = mongoPrimaryInstance.getGfs();
            BasicDBObject query = new BasicDBObject();
            query.put("dir", new BasicDBObject("$regex", source + "*"));
            List<GridFSDBFile> folder = gfs.find(query);
            if (folder != null) {
                idList = new ArrayList<String>(folder.size());
                for (GridFSDBFile f : folder) {
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    f = mongoPrimaryInstance.retrieveLinkPayload(f);
                    InputStream is = f.getInputStream();
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    GridFSInputFile destinationFile = gfs.createFile(is);
                    destinationFile.put("filename", filename);
                    destinationFile.put("type", "file");
                    destinationFile.put("dir", dir);
                    mongoPrimaryInstance.updateCommonFields(destinationFile, resource, OperationDefinition.OPERATION.COPY_DIR);
                    idList.add(destinationFile.getId().toString());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ObjectId: " + destinationId);
                    }
                    mongoPrimaryInstance.buildDirTree(mongoPrimaryInstance.getMetaDataCollection(db), dir);
                    destinationFile.save();
                }
            }
            mongoPrimaryInstance.close();
        }
        return idList;
    }
}

