/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.gridfs.GridFSDBFile;
import java.io.FileNotFoundException;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockOperator
extends Lock {
    final Logger logger = LoggerFactory.getLogger(LockOperator.class);

    public LockOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance, MyFile resource, String serverLocation) throws Exception {
        GridFSDBFile f;
        OperationDefinition op = resource.getOperationDefinition();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        if (resource.getLocalPath() != null && !resource.getLocalPath().isEmpty()) {
            resource.setOperation(OperationDefinition.OPERATION.DOWNLOAD);
            this.get(this.getDownload(), resource, true);
            resource.setOperation(op);
            mongoPrimaryInstance.close();
            mongoPrimaryInstance = null;
        }
        this.logger.info("MongoClient lock method: " + op.toString());
        String key = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + this.getRemotePath());
        }
        if ((f = mongoPrimaryInstance.retrieveRemoteDescriptor(this.getRemotePath(), remoteResourceIdentifier, true)) != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || mongoPrimaryInstance.isTTLUnlocked(f)) {
                key = f.getId() + "" + System.currentTimeMillis();
                f.put("lock", key);
                f.put("timestamp", System.currentTimeMillis());
                mongoPrimaryInstance.updateCommonFields(f, resource, OperationDefinition.OPERATION.LOCK);
                f.save();
            } else {
                mongoPrimaryInstance.checkTTL(f);
            }
        } else {
            mongoPrimaryInstance.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return key;
    }
}

