/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ensemble;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ensemble.util.Workspace;

public class EnsembleAlgorithm
extends StandardLocalExternalAlgorithm {
    private static final String ENSEMBLE_MODEL_SOURCE_PKG = "/tmp/ensemble/script/MEE_NORTHSEA_260914.py";
    private static final String ENSEMBLE_MODEL_SCRIPT_NAME = "MEE_NORTHSEA_260914.py";
    private static final String INPUT_LOCATION = ".";
    private static final String OUTPUT_LOCATION = ".";
    private static final String BINARIES_LOCATION = ".";
    public static final String IN_DAPSTOM_FILE = "?DAPSTOM File?";
    public static final String IN_NS_DIET_FILE = "?NS_DIET File?";
    public static final String IN_FISHING_PARAM_HIST_FILE = "?FISHING_PARAM_HIST_FILE File?";
    public static final String IN_FISHING_PARAM_MSY_FILE = "?FISHING_PARAM_MSY_FILE File?";
    public static final String IN_NS_IV_FILE = "?NS_IV_FILE File?";
    public static final String IN_NS_PARAMS_FILE = "?NS_PARAMS_FILE File?";
    private static final String IN_DAPSTOM_FILE_DESCRIPTION = "?description for DAPSTOM File?";
    private static final String IN_NS_DIET_FILE_DESCRIPTION = "?description for NS_DIET File?";
    private static final String IN_FISHING_PARAM_HIST_FILE_DESCRIPTION = "?description for FISHING_PARAM_HIST_FILE File?";
    private static final String IN_FISHING_PARAM_MSY_FILE_DESCRIPTION = "?description for FISHING_PARAM_MSY_FILE File?";
    private static final String IN_NS_IV_FILE_DESCRIPTION = "?description for NS_IV_FILE File?";
    private static final String IN_NS_PARAMS_FILE_DESCRIPTION = "?description for NS_PARAMS_FILE File?";
    private static final String DAPSTOM_FILE_HARDCODED_NAME = "DAPSTOM.txt";
    private static final String NS_DIET_FILE_HARDCODED_NAME = "NS_diet.csv.txt";
    private static final String FISHING_PARAM_HIST_FILE_HARDCODED_NAME = "Fishing_Params_300114_HIST.txt";
    private static final String FISHING_PARAM_MSY_FILE_HARDCODED_NAME = "Fishing_Params_300114_MSY.txt";
    private static final String NS_IV_FILE_HARDCODED_NAME = "NS_IV_combo1.dat";
    private static final String NS_PARAMS_FILE_HARDCODED_NAME = "NS_Params_270114.dat";
    private static final String OUT_BIOMASS = "?Biomass?";
    private static final String OUT_SSB = "?SSB?";
    private static final String OUT_XTABLE = "?XTABLE?";
    private static final String OUT_EXECUTION_LOG = "?Execution log?";
    private static final String OUT_BIOMASS_HARDCODED_NAME = "BIOMASS_0.txt";
    private static final String OUT_SSB_HARDCODED_NAME = "SSB_0.txt";
    private static final String OUT_XTABLE_HARDCODED_NAME = "XTABLE_0.txt";
    private static final String EXECUTION_LOG = "execution.log";
    private Workspace workspace;
    private String executionId;

    public void init() throws Exception {
        AnalysisLogger.getLogger().info((Object)"Ensemble Abstract Initialisation");
        AnalysisLogger.getLogger().info((Object)this.getDescription());
        this.executionId = UUID.randomUUID().toString();
        this.workspace = new Workspace(this.getExecutionId());
        this.workspace.setExecutionsRoot(this.config.getConfigPath());
        this.workspace.setBinariesLocation(".");
        this.workspace.setInputLocation(".");
        this.workspace.setOutputLocation(".");
    }

    public String getDescription() {
        String description = "?TODO?";
        return description;
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_DAPSTOM_FILE, IN_DAPSTOM_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_NS_DIET_FILE, IN_NS_DIET_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_FISHING_PARAM_HIST_FILE, IN_FISHING_PARAM_HIST_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_FISHING_PARAM_MSY_FILE, IN_FISHING_PARAM_MSY_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_NS_IV_FILE, IN_NS_IV_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_NS_PARAMS_FILE, IN_NS_PARAMS_FILE_DESCRIPTION));
    }

    protected void process() throws Exception {
        this.setupWorkingDirectory();
        this.prepareInput();
        this.downloadAndSetupEnsemble();
        String command = String.format("python %s", ENSEMBLE_MODEL_SCRIPT_NAME);
        this.workspace.exec(command, null, EXECUTION_LOG);
        this.prepareOutput();
        this.workspace.destroy();
    }

    public StatisticalType getOutput() {
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        PrimitiveType logOutputFile = new PrimitiveType(File.class.getName(), (Object)new File(this.config.getPersistencePath(), EXECUTION_LOG), PrimitiveTypes.FILE, EXECUTION_LOG, OUT_EXECUTION_LOG);
        map.put("Execution Log", logOutputFile);
        PrimitiveType biomassOutputFile = new PrimitiveType(File.class.getName(), (Object)new File(this.config.getPersistencePath(), OUT_BIOMASS_HARDCODED_NAME), PrimitiveTypes.FILE, OUT_BIOMASS_HARDCODED_NAME, OUT_BIOMASS);
        map.put("Biomass", biomassOutputFile);
        PrimitiveType ssbOutputFile = new PrimitiveType(File.class.getName(), (Object)new File(this.config.getPersistencePath(), OUT_SSB_HARDCODED_NAME), PrimitiveTypes.FILE, OUT_SSB_HARDCODED_NAME, OUT_SSB);
        map.put("SSB", ssbOutputFile);
        PrimitiveType xtableOutputFile = new PrimitiveType(File.class.getName(), (Object)new File(this.config.getPersistencePath(), OUT_XTABLE_HARDCODED_NAME), PrimitiveTypes.FILE, OUT_XTABLE_HARDCODED_NAME, OUT_XTABLE);
        map.put("XTABLE", xtableOutputFile);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().info((Object)"Shutdown");
    }

    private String getExecutionId() {
        return this.executionId;
    }

    protected void setupWorkingDirectory() throws Exception {
        AnalysisLogger.getLogger().debug((Object)("setting up working directory '" + this.workspace.getRoot() + "'"));
        this.workspace.ensureStructureExists();
    }

    private void prepareInput() throws IOException {
        AnalysisLogger.getLogger().debug((Object)"Copying input files...");
        FileUtils.copyFile((File)new File(this.config.getParam(IN_DAPSTOM_FILE)), (File)new File(this.workspace.getInputLocation(), DAPSTOM_FILE_HARDCODED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_NS_DIET_FILE)), (File)new File(this.workspace.getInputLocation(), NS_DIET_FILE_HARDCODED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_FISHING_PARAM_HIST_FILE)), (File)new File(this.workspace.getInputLocation(), FISHING_PARAM_HIST_FILE_HARDCODED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_FISHING_PARAM_MSY_FILE)), (File)new File(this.workspace.getInputLocation(), FISHING_PARAM_MSY_FILE_HARDCODED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_NS_IV_FILE)), (File)new File(this.workspace.getInputLocation(), NS_IV_FILE_HARDCODED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_NS_PARAMS_FILE)), (File)new File(this.workspace.getInputLocation(), NS_PARAMS_FILE_HARDCODED_NAME));
        AnalysisLogger.getLogger().debug((Object)"Input files copied to input location.");
    }

    protected void downloadAndSetupEnsemble() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Downloading Ensemble package");
        FileUtils.copyFileToDirectory((File)new File(ENSEMBLE_MODEL_SOURCE_PKG), (File)this.workspace.getRoot());
    }

    protected void prepareOutput() throws IOException {
        FileUtils.copyFileToDirectory((File)new File(this.workspace.getOutputLocation(), EXECUTION_LOG), (File)new File(this.config.getPersistencePath()));
        FileUtils.copyFileToDirectory((File)new File(this.workspace.getOutputLocation(), OUT_BIOMASS_HARDCODED_NAME), (File)new File(this.config.getPersistencePath()));
        FileUtils.copyFileToDirectory((File)new File(this.workspace.getOutputLocation(), OUT_SSB_HARDCODED_NAME), (File)new File(this.config.getPersistencePath()));
        FileUtils.copyFileToDirectory((File)new File(this.workspace.getOutputLocation(), OUT_XTABLE_HARDCODED_NAME), (File)new File(this.config.getPersistencePath()));
    }

    protected void removeWorkingDirectory() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Removing working directory");
    }
}

