/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.persistence;

import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.preparedstatement.PreparedInsert;
import org.gcube.common.dbinterface.queries.Cast;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Selection;
import org.gcube.common.dbinterface.queries.update.CreateTable;
import org.gcube.common.dbinterface.queries.update.Delete;
import org.gcube.common.dbinterface.queries.update.Update;
import org.gcube.common.dbinterface.queries.update.Updater;
import org.gcube.common.dbinterface.queries.update.batch.BatchUpdater;
import org.gcube.common.dbinterface.registry.Connection;
import org.gcube.common.dbinterface.registry.DBInterface;
import org.gcube.common.dbinterface.registry.Shortcuts;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableInfo;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Attributes;
import org.gcube.common.dbinterface.utils.Conditions;
import org.gcube.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.dbinterface.persistence.ObjectStateChangedException;
import org.gcube.dbinterface.persistence.ObjectStateControl;
import org.gcube.dbinterface.persistence.PersistencyCallback;
import org.gcube.dbinterface.persistence.SystemTableInfo;
import org.gcube.dbinterface.persistence.annotations.AnnotationNotDefinedException;
import org.gcube.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.dbinterface.persistence.annotations.TableRootDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPersistency<T> {
    public static HashMap<String, ObjectPersistency> persistencyMapping = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(ObjectPersistency.class);
    private DBInterface dbInterface;
    private Shortcuts sc;
    private GetMetadata metadata;
    private static final String FIELD_PREFIX = "ifield";
    private Class<T> _clazz;
    private Table table;
    private List<PersistencyCallback<T>> callbacks = new ArrayList<PersistencyCallback<T>>();

    public void addCallback(PersistencyCallback<T> obj) {
        this.callbacks.add(obj);
    }

    public static <T> ObjectPersistency<T> get(Class<T> clazz, DBInterface dbInterface) throws Exception {
        if (!persistencyMapping.containsKey(clazz.getName())) {
            persistencyMapping.put(clazz.getName(), new ObjectPersistency<T>(clazz, dbInterface));
        }
        return persistencyMapping.get(clazz.getName());
    }

    private ObjectPersistency(Class<T> clazz, DBInterface dbInterface) throws Exception {
        this.dbInterface = dbInterface;
        this.sc = dbInterface.queries();
        this._clazz = clazz;
        if (!this._clazz.isAnnotationPresent(TableRootDefinition.class)) {
            throw new AnnotationNotDefinedException();
        }
        String tableName = String.valueOf(clazz.getSimpleName()) + Math.abs(clazz.getName().hashCode());
        try {
            this.table = this.createTable(tableName);
        }
        catch (TableAlreadyExistsException e) {
            this.table = new Table(tableName);
        }
        this.metadata = dbInterface.getMetadata(this.table);
    }

    private FieldMappingPair retrieveColumnDefinition(Class _clazz, int fieldIndex) throws Exception {
        ArrayList<ColumnDefinition> cdList = new ArrayList<ColumnDefinition>();
        TreeMap<String, String> internalFieldMapping = new TreeMap<String, String>();
        logger.trace("retrieving column definition for --> table " + _clazz.getSimpleName());
        Field[] fieldArray = _clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(FieldDefinition.class)) {
                FieldDefinition fieldDefinition = field.getAnnotation(FieldDefinition.class);
                String fieldNameInTable = FIELD_PREFIX + fieldIndex;
                Type type = Type.getTypeByJavaClass(field.getType());
                if (type == null || type.getInnerType() == Type.InnerType.STRING && fieldDefinition.precision().length == 0) {
                    type = new Type(Type.InnerType.TEXT, new int[0]);
                } else {
                    type.setPrecision(fieldDefinition.precision());
                }
                logger.trace(String.valueOf(field.getName()) + " --> the type " + field.getType() + " is converted in  " + type.getInnerType().name());
                ColumnDefinition cDef = this.sc.column(fieldNameInTable, type, fieldDefinition.specifications());
                cdList.add(cDef);
                internalFieldMapping.put(field.getName(), fieldNameInTable);
                ++fieldIndex;
            }
            ++n2;
        }
        if (_clazz.getSuperclass() != null) {
            if (_clazz.getSuperclass().equals(ObjectStateControl.class)) {
                Type type = new Type(Type.InnerType.INTEGER, new int[0]);
                type.setPrecision(new int[]{10});
                ColumnDefinition cDef = this.sc.column("objectversion", type, new Specification[0]);
                cdList.add(cDef);
            } else {
                FieldMappingPair fmPair = this.retrieveColumnDefinition(_clazz.getSuperclass(), fieldIndex);
                cdList.addAll(fmPair.getColumnsDefinition());
                internalFieldMapping.putAll(fmPair.getFieldMapping());
            }
        }
        return new FieldMappingPair(internalFieldMapping, cdList);
    }

    private Table createTable(String tableName) throws Exception {
        block5: {
            Connection conn = this.dbInterface.getConnection();
            FieldMappingPair fmPair = this.retrieveColumnDefinition(this._clazz, 0);
            CreateTable create = (CreateTable)this.dbInterface.builders().createTable().name(tableName).columns(fmPair.getColumnsDefinition().toArray(new ColumnDefinition[fmPair.getColumnsDefinition().size()])).build();
            try {
                try {
                    conn.executeUpdate((Updater)create);
                    SystemTableInfo.getSystemInfo(this.dbInterface).addInfo(fmPair.getFieldMapping(), tableName);
                }
                catch (SQLException e) {
                    logger.error("error executing update", (Throwable)e);
                    this.dbInterface.release(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.dbInterface.release(conn);
                throw throwable;
            }
            this.dbInterface.release(conn);
        }
        return new Table(tableName);
    }

    public void deleteByKey(Object key) throws Exception {
        int res;
        block9: {
            Map<String, Type> mapping = this.getMapping();
            String primaryKey = null;
            Type type = null;
            for (Map.Entry<String, Type> entry : mapping.entrySet()) {
                if (!entry.getValue().isPrimaryKey()) continue;
                primaryKey = entry.getKey();
                type = entry.getValue();
                break;
            }
            if (this.callbacks.size() > 0) {
                T obj = this.getByKey(key);
                for (PersistencyCallback<T> callback : this.callbacks) {
                    callback.onObjectDeleted(obj);
                }
            }
            Cast cast = (Cast)this.dbInterface.builders().cast().value(key.toString()).type(type).build();
            Delete delete = (Delete)this.dbInterface.builders().delete().table(this.table.getTableName()).where((Condition)Conditions.eq((Object)Attributes.attribute((String)primaryKey), (Object)cast)).build();
            Connection conn = this.dbInterface.getConnection();
            res = 0;
            try {
                try {
                    res = conn.executeUpdate((Updater)delete);
                }
                catch (SQLException e) {
                    logger.error("error executing update", (Throwable)e);
                    this.dbInterface.release(conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.dbInterface.release(conn);
                throw throwable;
            }
            this.dbInterface.release(conn);
        }
        if (res == 0) {
            throw new ObjectNotFoundException();
        }
    }

    public Map<String, String> getInfo() throws Exception {
        return SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName());
    }

    public T getByKey(Object key) throws ObjectNotFoundException, Exception {
        T toReturn;
        block6: {
            Map<String, Type> mapping = this.getMapping();
            String primaryKey = null;
            Type type = null;
            for (Map.Entry<String, Type> entry : mapping.entrySet()) {
                if (!entry.getValue().isPrimaryKey()) continue;
                primaryKey = entry.getKey();
                type = entry.getValue();
                break;
            }
            if (type == null) {
                throw new Exception("no primary key found in " + this.table.getTableName());
            }
            Cast cast = (Cast)this.dbInterface.builders().cast().value(key.toString()).type(type).build();
            Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where((Condition)Conditions.eq((Object)Attributes.attribute((String)primaryKey), (Object)cast)).build();
            toReturn = null;
            Connection connection = this.dbInterface.getConnection();
            try {
                ResultSet result = connection.executeQuery((Selection)select).asDefault();
                if (result.next()) {
                    toReturn = this.createObject(result);
                    break block6;
                }
                throw new ObjectNotFoundException();
            }
            finally {
                this.dbInterface.release(connection);
            }
        }
        return toReturn;
    }

    public void insert(T object) throws Exception {
        for (PersistencyCallback<T> callback : this.callbacks) {
            callback.onBeforeStore(object);
        }
        List<Object> oInsert = this.retrieveInsertField(object, this._clazz);
        PreparedInsert preparedInsert = (PreparedInsert)this.dbInterface.builders().preparedInsert().table(this.table.getTableName()).elements(oInsert.size()).build();
        BatchUpdater updater = (BatchUpdater)this.dbInterface.builders().batchInsert().stopOnError().use(preparedInsert).elements(Collections.singletonList(oInsert.toArray(new Object[oInsert.size()]))).build();
        logger.trace("inserting " + oInsert.toString());
        Connection conn = this.dbInterface.getConnection();
        try {
            conn.executeBatchUpdate(updater);
            logger.trace("insert executed");
        }
        catch (Exception e) {
            this.dbInterface.release(conn);
        }
        for (PersistencyCallback<T> callback : this.callbacks) {
            callback.onObjectStored(object);
        }
    }

    private List<Object> retrieveInsertField(T object, Class clazz) throws Exception {
        ArrayList<Object> oInsert = new ArrayList<Object>();
        logger.trace("storing class " + clazz.getSimpleName());
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(FieldDefinition.class)) {
                if (Type.getTypeByJavaClass(field.getType()) == null) {
                    logger.trace(String.valueOf(field.getName()) + " - " + field.getType());
                    field.setAccessible(true);
                    oInsert.add(new XStream().toXML(field.get(object)));
                } else {
                    logger.trace(String.valueOf(field.getName()) + " - " + field.getType());
                    field.setAccessible(true);
                    oInsert.add(field.get(object));
                }
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            if (clazz.getSuperclass().equals(ObjectStateControl.class)) {
                oInsert.add(0);
            } else if (clazz.getSuperclass().isAnnotationPresent(TableRootDefinition.class)) {
                oInsert.addAll(this.retrieveInsertField(object, clazz.getSuperclass()));
            }
        }
        return oInsert;
    }

    public void drop() throws Exception {
        Connection conn = this.dbInterface.getConnection();
        try {
            conn.executeUpdate((Updater)this.sc.remove(this.table));
            SystemTableInfo.getSystemInfo(this.dbInterface).deleteInfo(this.table.getTableName());
        }
        finally {
            this.dbInterface.release(conn);
        }
    }

    public void deleteByValue(String fieldName, Object value) throws Exception {
        String internalFieldName = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).get(fieldName);
        if (internalFieldName == null) {
            throw new Exception("field " + fieldName + " non retrieved");
        }
        if (this.callbacks.size() > 0) {
            Iterator<T> it = this.getObjectByField(fieldName, value).iterator();
            while (it.hasNext()) {
                for (PersistencyCallback<T> callback : this.callbacks) {
                    callback.onObjectDeleted(it.next());
                }
            }
        }
        Delete delete = (Delete)this.dbInterface.builders().delete().table(this.table.getTable()).where((Condition)Conditions.eq((Object)Attributes.attribute((String)internalFieldName), (Object)value)).build();
        Connection conn = this.dbInterface.getConnection();
        try {
            conn.executeUpdate((Updater)delete);
        }
        finally {
            this.dbInterface.release(conn);
        }
    }

    public List<T> getObjectByField(String fieldName, Object value) throws Exception {
        String internalFieldName = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).get(fieldName);
        if (internalFieldName == null) {
            throw new Exception("field " + fieldName + " non retrieved");
        }
        Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where((Condition)Conditions.eq((Object)Attributes.attribute((String)internalFieldName), (Object)value)).build();
        Connection conn = this.dbInterface.getConnection();
        try {
            List<T> list = this.toList(conn.executeQuery((Selection)select).asDefault());
            return list;
        }
        finally {
            this.dbInterface.release(conn);
        }
    }

    public List<T> getObjectByFields(HashMap<String, Object> fieldValueMapping) throws Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        ArrayList<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition((Object)new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where((Condition)Conditions.and((Condition[])((Condition[])conditions.toArray(new OperatorCondition[conditions.size()])))).build();
        Connection session = this.dbInterface.getConnection();
        try {
            List<T> list = this.toList(session.executeQuery((Selection)select).asDefault());
            return list;
        }
        finally {
            this.dbInterface.release(session);
        }
    }

    public List<T> getAll() throws Exception {
        Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).build();
        Connection session = this.dbInterface.getConnection();
        try {
            logger.trace("executing query {}", (Object)select.getQuery());
            List<T> list = this.toList(session.executeQuery((Selection)select).asDefault());
            return list;
        }
        catch (Exception e) {
            logger.error("error getting elements", (Throwable)e);
            throw e;
        }
        finally {
            this.dbInterface.release(session);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public boolean existsKey(Object key) throws Exception {
        Connection session = this.dbInterface.getConnection();
        try {
            Map mapping = new TableInfo(this.table.getTableName()).getMapping();
            String primaryKey = null;
            Type type = null;
            for (Map.Entry entry : mapping.entrySet()) {
                if (!((Type)entry.getValue()).isPrimaryKey()) continue;
                primaryKey = (String)entry.getKey();
                type = (Type)entry.getValue();
                break;
            }
            if (type == null) {
                throw new ObjectNotFoundException("no primary key found in " + this.table.getTableName());
            }
            Cast cast = (Cast)this.dbInterface.builders().cast().value(key.toString()).type(type).build();
            Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where((Condition)Conditions.eq((Object)Attributes.attribute((String)primaryKey), (Object)cast)).build();
            ResultSet result = session.executeQuery((Selection)select).asDefault();
            return result.next();
            {
            }
        }
        catch (Exception e) {
            logger.error("errror retrieving key", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                this.dbInterface.release(session);
            }
        }
    }

    public boolean existEntryByFields(HashMap<String, Object> fieldValueMapping) throws Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        ArrayList<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition((Object)new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where((Condition)Conditions.and((Condition[])((Condition[])conditions.toArray(new OperatorCondition[conditions.size()])))).build();
        Connection session = this.dbInterface.getConnection();
        try {
            ResultSet rs = session.executeQuery((Selection)select).asDefault();
            boolean bl = rs.next();
            return bl;
        }
        finally {
            this.dbInterface.release(session);
        }
    }

    public void update(T obj) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        Map<String, Type> mapping = this.getMapping();
        String primaryKey = null;
        Type type = null;
        for (Map.Entry<String, Type> entry : mapping.entrySet()) {
            if (!entry.getValue().isPrimaryKey()) continue;
            primaryKey = entry.getKey();
            type = entry.getValue();
            break;
        }
        if (type == null) {
            throw new ObjectNotFoundException("no primary key found in " + this.table.getTableName());
        }
        Object keyValue = this.getFieldValue(obj, SystemTableInfo.getSystemInfo(this.dbInterface).retrieveFieldName(this.table.getTableName(), primaryKey), type);
        Cast cast = (Cast)this.dbInterface.builders().cast().value(keyValue != null ? keyValue.toString() : null).type(type).build();
        this.executeUpdate(obj, (Condition)Conditions.eq((Object)Attributes.attribute((String)primaryKey), (Object)cast));
    }

    public void updateByFields(T obj, HashMap<String, Object> fieldValueMapping) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        ArrayList<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition((Object)new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        this.executeUpdate(obj, (Condition)Conditions.and((Condition[])((Condition[])conditions.toArray(new OperatorCondition[conditions.size()]))));
    }

    private Object getFieldValue(T obj, String fieldName, Type internalType) throws Exception {
        Field field = this.retrieveField(fieldName, this._clazz);
        field.setAccessible(true);
        Object fieldValue = null;
        if (internalType.getInnerType().getJavaClass().isPrimitive()) {
            Method fieldMethod = Field.class.getDeclaredMethod(internalType.getInnerType().getReflectionMethodGet(), Object.class);
            fieldValue = fieldMethod.invoke((Object)field, obj);
        } else {
            fieldValue = field.getType().isEnum() ? field.get(obj).toString() : (Type.getTypeByJavaClass(field.getType()) == null ? new XStream().toXML(field.get(obj)) : field.get(obj));
        }
        return fieldValue;
    }

    private void executeUpdate(T obj, Condition filter) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        Map<String, Type> mapping = this.getMapping();
        ArrayList<OperatorCondition> setters = new ArrayList<OperatorCondition>();
        for (Map.Entry<String, String> entry : SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName()).entrySet()) {
            Type internaltype = mapping.get(entry.getValue());
            if (internaltype.isPrimaryKey()) continue;
            Object fieldValue = this.getFieldValue(obj, entry.getKey(), internaltype);
            Cast cast = (Cast)this.dbInterface.builders().cast().value(fieldValue != null ? fieldValue.toString() : null).type(internaltype).build();
            setters.add(Conditions.eq((Object)Attributes.attribute((String)entry.getValue()), (Object)cast));
        }
        Connection session = this.dbInterface.getConnection();
        session.disableAutoCommit();
        try {
            Select select = (Select)this.dbInterface.builders().select().from(new Table[]{this.table}).where(filter).build();
            if (!session.executeQuery((Selection)select).asDefault().next()) {
                this.dbInterface.release(session);
                throw new ObjectNotFoundException();
            }
            if (this.isUnderVersionControl()) {
                Field field = ObjectStateControl.class.getDeclaredField("objectversion");
                field.setAccessible(true);
                int versionValue = field.getInt(obj);
                OperatorCondition versionControl = new OperatorCondition((Object)new SimpleAttribute("objectversion"), (Object)versionValue, "=");
                filter = Conditions.and((Condition[])new Condition[]{filter, versionControl});
                setters.add(new OperatorCondition((Object)new SimpleAttribute("objectversion"), (Object)(versionValue + 1), "="));
                field.setInt(obj, versionValue + 1);
            }
            Update update = (Update)this.dbInterface.builders().update().table(this.table).set(setters.toArray(new OperatorCondition[setters.size()])).where(filter).build();
            int result = session.executeUpdate((Updater)update);
            session.commit();
            if (result == 0) {
                throw new ObjectStateChangedException();
            }
        }
        finally {
            this.dbInterface.release(session);
        }
        if (obj != null) {
            for (PersistencyCallback<T> callback : this.callbacks) {
                callback.onObjectUpdated(obj);
            }
        }
    }

    private Field retrieveField(String fieldName, Class clazz) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                if (clazz.getSuperclass() == null || !clazz.getSuperclass().isAnnotationPresent(TableRootDefinition.class)) break block2;
                return this.retrieveField(fieldName, clazz.getSuperclass());
            }
        }
        return field;
    }

    private boolean isUnderVersionControl() {
        Class<T> clazz = this._clazz;
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.equals(ObjectStateControl.class)) continue;
            return true;
        }
        return false;
    }

    private List<T> toList(ResultSet resultSet) throws Exception {
        ArrayList<T> returnList = new ArrayList<T>();
        while (resultSet.next()) {
            returnList.add(this.createObject(resultSet));
        }
        resultSet.close();
        return returnList;
    }

    private Map<String, Type> getMapping() throws Exception {
        Connection conn = this.dbInterface.getConnection();
        try {
            LinkedHashMap linkedHashMap = this.metadata.getMetadata(conn);
            return linkedHashMap;
        }
        finally {
            this.dbInterface.release(conn);
        }
    }

    private T createObject(ResultSet result) throws Exception {
        Constructor<T> constr = this._clazz.getDeclaredConstructor(new Class[0]);
        logger.debug("createObjectInternal with class " + this._clazz.getName());
        constr.setAccessible(true);
        T returnObj = constr.newInstance(new Object[0]);
        Map<String, Type> mapping = this.getMapping();
        logger.trace("mapping is empty?" + (mapping.size() == 0));
        TreeMap<String, String> classTableMap = SystemTableInfo.getSystemInfo(this.dbInterface).retrieveInfo(this.table.getTableName());
        logger.trace("classTableMap is empty?" + (classTableMap.size() == 0));
        logger.trace("class table map is null?" + (classTableMap == null) + " and mapping is null? " + (mapping == null));
        this.createObjectInternal(this._clazz, mapping, returnObj, classTableMap, result);
        if (returnObj != null) {
            for (PersistencyCallback<T> callback : this.callbacks) {
                callback.onObjectLoaded(returnObj);
            }
        }
        return returnObj;
    }

    private void createObjectInternal(Class clazz, Map<String, Type> mapping, T returnObj, Map<String, String> classTableMap, ResultSet result) throws Exception {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String internalFieldName = classTableMap.get(field.getName());
            logger.trace("retrieved field " + internalFieldName);
            if (internalFieldName != null) {
                Method rsMethod;
                field.setAccessible(true);
                logger.trace("fieldName is " + field.getName());
                logger.trace("mapping.get(internalFieldName) is null?" + (mapping.get(internalFieldName) == null));
                if (mapping.get(internalFieldName).getInnerType().getJavaClass().isPrimitive()) {
                    rsMethod = ResultSet.class.getDeclaredMethod(mapping.get(internalFieldName).getInnerType().getReflectionMethodGet(), String.class);
                    Method fieldMethod = Field.class.getDeclaredMethod(mapping.get(internalFieldName).getInnerType().getReflectionMethodSet(), Object.class, mapping.get(internalFieldName).getInnerType().getJavaClass());
                    fieldMethod.invoke((Object)field, returnObj, rsMethod.invoke((Object)result, internalFieldName));
                } else if (field.getType().isEnum()) {
                    String value = result.getString(internalFieldName);
                    field.set(returnObj, Enum.valueOf(field.getType(), value));
                } else if (Type.getTypeByJavaClass(field.getType()) == null) {
                    field.set(returnObj, new XStream().fromXML(result.getString(internalFieldName)));
                } else if (Type.getTypeByJavaClass(field.getType()).getInnerType() == Type.InnerType.STRING) {
                    field.set(returnObj, result.getString(internalFieldName));
                } else {
                    logger.trace("method is " + mapping.get(internalFieldName).getInnerType().getReflectionMethodGet());
                    rsMethod = ResultSet.class.getDeclaredMethod(mapping.get(internalFieldName).getInnerType().getReflectionMethodGet(), String.class);
                    field.set(returnObj, rsMethod.invoke((Object)result, internalFieldName));
                }
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != null) {
            if (clazz.getSuperclass().equals(ObjectStateControl.class)) {
                Field superClassField = clazz.getSuperclass().getDeclaredField("objectversion");
                superClassField.setAccessible(true);
                superClassField.setInt(returnObj, result.getInt("objectversion"));
            } else {
                this.createObjectInternal(clazz.getSuperclass(), mapping, returnObj, classTableMap, result);
            }
        }
    }

    private class FieldMappingPair {
        private TreeMap<String, String> fieldMapping;
        private List<ColumnDefinition> columnsDefinition;

        public FieldMappingPair(TreeMap<String, String> fieldMapping, List<ColumnDefinition> columnsDefinition) {
            this.fieldMapping = fieldMapping;
            this.columnsDefinition = columnsDefinition;
        }

        public TreeMap<String, String> getFieldMapping() {
            return this.fieldMapping;
        }

        public List<ColumnDefinition> getColumnsDefinition() {
            return this.columnsDefinition;
        }
    }
}

