/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.queries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Cast;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.dbinterface.h2.queries.AbstractUpdate;

public class SingleSet
extends AbstractUpdate {
    private String query = "UPDATE <%TABLE%> SET <%FIELD%>=? WHERE <%FILDCOND%>=?";
    private String fieldToSet;
    private String fieldToCompare;
    private SimpleTable table;
    private PreparedStatement statement;
    private Object valueField = null;
    private Object valueCond = null;

    public SingleSet(SimpleTable table, String fieldToSet, String fieldToCompare) throws Exception {
        this.fieldToSet = fieldToSet;
        this.table = table;
        this.fieldToCompare = fieldToCompare;
        this.statement = DBSession.connect().getPreparedStatement(this.query.replace("<%TABLE%>", this.table.getTableName()).replace("<%FIELD%>", this.fieldToSet).replace("<%FILDCOND%>", this.fieldToCompare));
    }

    @Override
    public SimpleTable execute(DBSession session) throws Exception {
        if (this.valueField == null && this.valueCond == null) {
            throw new Exception("no value set");
        }
        Object value = null;
        value = Cast.apply(this.valueField.getClass(), (Type)((Type)this.table.getFieldsMapping().get(this.fieldToSet)), (Object)this.valueField);
        if (value == null) {
            this.statement.setNull(1, 0);
        } else {
            Method m = PreparedStatement.class.getMethod(((Type)this.table.getFieldsMapping().get(this.fieldToSet)).getType().getReflectionMethodSet(), Integer.TYPE, ((Type)this.table.getFieldsMapping().get(this.fieldToSet)).getType().getJavaClass());
            try {
                m.invoke((Object)this.statement, 1, value);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new Exception("error updating table " + this.table.getTableName());
            }
        }
        Method m1 = PreparedStatement.class.getMethod(((Type)this.table.getFieldsMapping().get(this.fieldToCompare)).getType().getReflectionMethodSet(), Integer.TYPE, ((Type)this.table.getFieldsMapping().get(this.fieldToCompare)).getType().getJavaClass());
        try {
            m1.invoke((Object)this.statement, 2, Cast.apply(this.valueCond.getClass(), (Type)((Type)this.table.getFieldsMapping().get(this.fieldToCompare)), (Object)this.valueCond));
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new Exception("error updating table " + this.table.getTableName());
        }
        this.statement.execute();
        return this.table;
    }

    @Override
    public String getExpression() {
        return this.query;
    }

    public void setValueField(Object value) {
        this.valueField = value;
    }

    public void setValueCondition(Object value) {
        this.valueCond = value;
    }
}

