/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.StringUtils;

public class JoinMetaData
extends MetaData
implements ColumnMetaDataContainer {
    ForeignKeyMetaData foreignKeyMetaData;
    IndexMetaData indexMetaData;
    UniqueMetaData uniqueMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    final List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    boolean outer = false;
    String table;
    String catalog;
    String schema;
    String columnName;
    protected IndexedValue indexed = null;
    protected boolean unique;
    protected ColumnMetaData[] columnMetaData;

    public JoinMetaData(JoinMetaData joinmd) {
        this.table = joinmd.table;
        this.catalog = joinmd.catalog;
        this.schema = joinmd.schema;
        this.columnName = joinmd.columnName;
        this.outer = joinmd.outer;
        this.indexed = joinmd.indexed;
        this.unique = joinmd.unique;
        for (int i = 0; i < joinmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData(joinmd.columns.get(i)));
        }
    }

    public JoinMetaData() {
    }

    @Override
    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        int i;
        if (this.table != null && this.parent instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
            throw new InvalidMemberMetaDataException(LOCALISER, "044130", mmd.getClassName(), mmd.getFullFieldName());
        }
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData();
            this.columnMetaData[0].setName(this.columnName);
            this.columnMetaData[0].parent = this;
            this.columnMetaData[0].initialise(clr, mmgr);
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise(clr, mmgr);
            }
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise(clr, mmgr);
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise(clr, mmgr);
        }
        if (this.uniqueMetaData == null && this.unique) {
            this.uniqueMetaData = new UniqueMetaData();
            this.uniqueMetaData.setTable(this.columnName);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise(clr, mmgr);
        }
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.initialise(clr, mmgr);
        }
        this.setInitialised();
    }

    @Override
    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public final boolean isOuter() {
        return this.outer;
    }

    public JoinMetaData setOuter(boolean outer) {
        this.outer = outer;
        return this;
    }

    public String getDeleteAction() {
        if (this.foreignKeyMetaData != null) {
            return this.foreignKeyMetaData.getDeleteAction().toString();
        }
        return null;
    }

    public JoinMetaData setDeleteAction(String deleteAction) {
        if (!StringUtils.isWhitespace(deleteAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setDeleteAction(ForeignKeyAction.getForeignKeyAction(deleteAction));
        }
        return this;
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public JoinMetaData setIndexed(IndexedValue indexed) {
        if (indexed != null) {
            this.indexed = indexed;
        }
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public JoinMetaData setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public JoinMetaData setUnique(String unique) {
        this.unique = MetaDataUtils.getBooleanForString(unique, false);
        return this;
    }

    public final String getTable() {
        return this.table;
    }

    public JoinMetaData setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
        return this;
    }

    public final String getCatalog() {
        return this.catalog;
    }

    public JoinMetaData setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
        return this;
    }

    public final String getSchema() {
        return this.schema;
    }

    public JoinMetaData setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
        return this;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public JoinMetaData setColumnName(String columnName) {
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
        return this;
    }

    @Override
    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
        foreignKeyMetaData.parent = this;
    }

    public ForeignKeyMetaData newForeignKeyMetaData() {
        ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
        this.setForeignKeyMetaData(fkmd);
        return fkmd;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        indexMetaData.parent = this;
    }

    public IndexMetaData newIndexMetaData() {
        IndexMetaData idxmd = new IndexMetaData();
        this.setIndexMetaData(idxmd);
        return idxmd;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
        uniqueMetaData.parent = this;
    }

    public UniqueMetaData newUniqueMetaData() {
        UniqueMetaData unimd = new UniqueMetaData();
        this.setUniqueMetaData(unimd);
        return unimd;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
        primaryKeyMetaData.parent = this;
    }

    public PrimaryKeyMetaData newPrimaryKeyMetaData() {
        PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
        this.setPrimaryKeyMetaData(pkmd);
        return pkmd;
    }

    @Override
    public String toString(String prefix, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<join");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.columnName != null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        sb.append(" outer=\"" + this.outer + "\"");
        sb.append(">\n");
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.columnMetaData != null) {
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</join>\n");
        return sb.toString();
    }
}

