/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.ByteSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractColumnListMutation<C>
implements ColumnListMutation<C> {
    protected long timestamp;
    protected Integer defaultTtl = null;

    public AbstractColumnListMutation(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, String value, Integer ttl) {
        return this.putColumn(columnName, value, StringSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, String value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, String value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, String value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, byte[] value, Integer ttl) {
        return this.putColumn(columnName, value, BytesArraySerializer.get(), ttl);
    }

    @Override
    public <V> ColumnListMutation<C> putColumnIfNotNull(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        if (value == null) {
            return this;
        }
        return this.putColumn(columnName, value, valueSerializer, ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, byte[] value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, byte[] value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, byte[] value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, byte value, Integer ttl) {
        return this.putColumn(columnName, value, ByteSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, byte value) {
        return this.putColumn(columnName, value, (Integer)null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Byte value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Byte value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, short value, Integer ttl) {
        return this.putColumn(columnName, value, ShortSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, short value) {
        return this.putColumn(columnName, value, (Integer)null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Short value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Short value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, int value, Integer ttl) {
        return this.putColumn(columnName, value, IntegerSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, int value) {
        return this.putColumn(columnName, value, (Integer)null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Integer value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Integer value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, long value, Integer ttl) {
        return this.putColumn(columnName, value, LongSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, long value) {
        return this.putColumn(columnName, value, (Integer)null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Long value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Long value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, boolean value, Integer ttl) {
        return this.putColumn(columnName, value, BooleanSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, boolean value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Boolean value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Boolean value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, ByteBuffer value, Integer ttl) {
        return this.putColumn(columnName, value, ByteBufferSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, ByteBuffer value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, ByteBuffer value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, ByteBuffer value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, Date value, Integer ttl) {
        return this.putColumn(columnName, value, DateSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, Date value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Date value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Date value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, float value, Integer ttl) {
        return this.putColumn(columnName, Float.valueOf(value), FloatSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, float value) {
        return this.putColumn(columnName, value, (Integer)null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Float value) {
        if (value != null) {
            return this.putColumn(columnName, value.floatValue());
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Float value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value.floatValue(), ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, double value, Integer ttl) {
        return this.putColumn(columnName, value, DoubleSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, double value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Double value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Double value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, UUID value, Integer ttl) {
        return this.putColumn(columnName, value, UUIDSerializer.get(), ttl);
    }

    @Override
    public ColumnListMutation<C> putColumn(C columnName, UUID value) {
        return this.putColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, UUID value) {
        if (value != null) {
            return this.putColumn(columnName, value);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putColumnIfNotNull(C columnName, UUID value, Integer ttl) {
        if (value != null) {
            return this.putColumn(columnName, value, ttl);
        }
        return this;
    }

    @Override
    public ColumnListMutation<C> putEmptyColumn(C columnName) {
        return this.putEmptyColumn(columnName, null);
    }

    @Override
    public ColumnListMutation<C> setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public ColumnListMutation<C> setDefaultTtl(Integer ttl) {
        this.defaultTtl = ttl;
        return this;
    }

    @Override
    public ColumnListMutation<C> putCompressedColumn(C columnName, String value, Integer ttl) {
        Preconditions.checkNotNull((Object)value, (Object)"Can't insert null value");
        if (value == null) {
            this.putEmptyColumn(columnName, ttl);
            return this;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(value.getBytes());
            gzip.close();
            return this.putColumn(columnName, ByteBuffer.wrap(out.toByteArray()), ttl);
        }
        catch (IOException e) {
            throw new RuntimeException("Error compressing column " + columnName, e);
        }
    }

    @Override
    public ColumnListMutation<C> putCompressedColumn(C columnName, String value) {
        return this.putCompressedColumn(columnName, value, null);
    }

    @Override
    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value, Integer ttl) {
        if (value == null) {
            return this;
        }
        return this.putCompressedColumn(columnName, value, ttl);
    }

    @Override
    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value) {
        return this.putCompressedColumnIfNotNull(columnName, value);
    }
}

