/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.entitystore.AbstractColumnMapper;
import com.netflix.astyanax.entitystore.ColumnMapper;
import com.netflix.astyanax.entitystore.LeafColumnMapper;
import com.netflix.astyanax.model.Column;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;

class CompositeColumnMapper
extends AbstractColumnMapper {
    private final Class<?> clazz;
    private final Map<String, ColumnMapper> columnList;
    private final List<ColumnMapper> nonNullableFields;

    CompositeColumnMapper(Field field) {
        super(field);
        this.clazz = field.getType();
        Entity entityAnnotation = this.clazz.getAnnotation(Entity.class);
        if (entityAnnotation == null) {
            throw new IllegalArgumentException("class is NOT annotated with @java.persistence.Entity: " + this.clazz.getName());
        }
        this.columnList = Maps.newHashMapWithExpectedSize((int)this.clazz.getDeclaredFields().length);
        this.nonNullableFields = Lists.newArrayList();
        HashSet usedColumnNames = Sets.newHashSet();
        for (Field childField : this.clazz.getDeclaredFields()) {
            javax.persistence.Column annotation = childField.getAnnotation(javax.persistence.Column.class);
            if (annotation == null) continue;
            childField.setAccessible(true);
            AbstractColumnMapper columnMapper = null;
            Entity compositeAnnotation = childField.getType().getAnnotation(Entity.class);
            columnMapper = compositeAnnotation == null ? new LeafColumnMapper(childField) : new CompositeColumnMapper(childField);
            Preconditions.checkArgument((!usedColumnNames.contains(columnMapper.getColumnName().toLowerCase()) ? 1 : 0) != 0, (Object)String.format("duplicate case-insensitive column name: %s", columnMapper.getColumnName()));
            this.columnList.put(columnMapper.getColumnName(), columnMapper);
            usedColumnNames.add(columnMapper.getColumnName().toLowerCase());
            if (annotation.nullable()) continue;
            this.nonNullableFields.add(columnMapper);
        }
    }

    public String toString() {
        return String.format("CompositeColumnMapper(%s)", this.clazz);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean fillMutationBatch(Object entity, ColumnListMutation<String> clm, String prefix) throws Exception {
        Object childEntity = this.field.get(entity);
        if (childEntity == null) {
            if (this.columnAnnotation.nullable()) {
                return false;
            }
            throw new IllegalArgumentException("cannot write non-nullable column with null value: " + this.columnName);
        }
        prefix = prefix + this.getColumnName() + ".";
        boolean hasNonNullChildField = false;
        for (ColumnMapper mapper : this.columnList.values()) {
            boolean childFilled = mapper.fillMutationBatch(childEntity, clm, prefix);
            if (!childFilled) continue;
            hasNonNullChildField = true;
        }
        return hasNonNullChildField;
    }

    @Override
    public boolean setField(Object entity, Iterator<String> name, Column<String> column) throws Exception {
        ColumnMapper mapper;
        Object childEntity = this.field.get(entity);
        if (childEntity == null) {
            childEntity = this.clazz.newInstance();
            this.field.set(entity, childEntity);
        }
        if ((mapper = this.columnList.get(name.next())) == null) {
            return false;
        }
        return mapper.setField(childEntity, name, column);
    }

    @Override
    public void validate(Object entity) throws Exception {
        Object objForThisField = this.field.get(entity);
        if (objForThisField == null) {
            if (!this.columnAnnotation.nullable()) {
                throw new IllegalArgumentException("cannot find non-nullable column: " + this.columnName);
            }
        } else {
            for (ColumnMapper childField : this.nonNullableFields) {
                childField.validate(objForThisField);
            }
        }
    }
}

