/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import java.util.concurrent.TimeUnit;

public class MessageQueueSettings {
    public static final Integer DEFAULT_RETENTION_TIMEOUT = null;
    public static final int DEFAULT_SHARD_COUNT = 1;
    public static final Long DEFAULT_BUCKET_DURATION = null;
    public static final int DEFAULT_BUCKET_COUNT = 1;
    public static final Integer DEFAULT_HISTORY_TTL = null;
    public static final String DEFAULT_QUEUE_NAME = "Queue";
    public static final long DEFAULT_POLL_WAIT = TimeUnit.MILLISECONDS.convert(100L, TimeUnit.MILLISECONDS);
    private Long partitionDuration = DEFAULT_BUCKET_DURATION;
    private int partitionCount = 1;
    private Integer retentionTimeout = DEFAULT_RETENTION_TIMEOUT;
    private int shardCount = 1;
    private Integer historyTtl = DEFAULT_HISTORY_TTL;
    private String queueName = "Queue";
    private long pollInterval = DEFAULT_POLL_WAIT;

    public Long getPartitionDuration() {
        return this.partitionDuration;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Integer getRetentionTimeout() {
        return this.retentionTimeout;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void setPartitionDuration(long partitionDuration) {
        this.partitionDuration = partitionDuration;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public void setRetentionTimeout(Integer retentionTimeout) {
        this.retentionTimeout = retentionTimeout;
    }

    public void setRetentionTimeout(Long retentionTimeout, TimeUnit units) {
        this.retentionTimeout = (int)TimeUnit.SECONDS.convert(retentionTimeout, units);
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public Integer getHistoryTtl() {
        return this.historyTtl;
    }

    public void setHistoryTtl(Integer historyTtl) {
        this.historyTtl = historyTtl;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public String toString() {
        return "MessageQueueSettings [partitionDuration=" + this.partitionDuration + ", partitionCount=" + this.partitionCount + ", retentionTimeout=" + this.retentionTimeout + ", shardCount=" + this.shardCount + ", historyTtl=" + this.historyTtl + ", queueName=" + this.queueName + ", pollInterval=" + this.pollInterval + "]";
    }
}

