/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyStringSerializer
extends AbstractSerializer<String> {
    private static final String UTF_8 = "UTF-8";
    private static final SnappyStringSerializer instance = new SnappyStringSerializer();
    private static final Charset charset = Charset.forName("UTF-8");

    public static SnappyStringSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(String obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SnappyOutputStream snappy = new SnappyOutputStream((OutputStream)out);
            snappy.write(obj.getBytes());
            snappy.close();
            return ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Error compressing column data", e);
        }
    }

    @Override
    public String fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        SnappyInputStream snappy = null;
        ByteArrayOutputStream baos = null;
        try {
            snappy = new SnappyInputStream((InputStream)new ByteArrayInputStream(byteBuffer.array(), 0, byteBuffer.limit()));
            baos = new ByteArrayOutputStream();
            int value22 = 0;
            while (value22 != -1) {
                value22 = snappy.read();
                if (value22 == -1) continue;
                baos.write(value22);
            }
            snappy.close();
            baos.close();
            String value22 = new String(baos.toByteArray(), charset);
            return value22;
        }
        catch (IOException e) {
            throw new RuntimeException("Error decompressing column data", e);
        }
        finally {
            if (snappy != null) {
                try {
                    snappy.close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.BYTESTYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return UTF8Type.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return UTF8Type.instance.getString(byteBuffer);
    }
}

