/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import com.netflix.astyanax.thrift.ThriftColumnFamilyMutationImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.commons.codec.binary.Hex;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public abstract class AbstractThriftMutationBatchImpl
implements MutationBatch {
    protected long timestamp;
    private ConsistencyLevel consistencyLevel;
    private Clock clock;
    private Host pinnedHost;
    private RetryPolicy retry;
    private WriteAheadLog wal;
    private Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap = Maps.newLinkedHashMap();
    private Map<KeyAndColumnFamily, ColumnListMutation<?>> rowLookup = Maps.newHashMap();

    public AbstractThriftMutationBatchImpl(Clock clock, ConsistencyLevel consistencyLevel, RetryPolicy retry) {
        this.clock = clock;
        this.timestamp = clock.getCurrentTime();
        this.consistencyLevel = consistencyLevel;
        this.retry = retry;
    }

    @Override
    public <K, C> ColumnListMutation<C> withRow(ColumnFamily<K, C> columnFamily, K rowKey) {
        Preconditions.checkNotNull(columnFamily, (Object)"columnFamily cannot be null");
        Preconditions.checkNotNull(rowKey, (Object)"Row key cannot be null");
        if (this.clock != null && this.mutationMap.isEmpty()) {
            this.timestamp = this.clock.getCurrentTime();
        }
        ByteBuffer bbKey = columnFamily.getKeySerializer().toByteBuffer(rowKey);
        KeyAndColumnFamily kacf = new KeyAndColumnFamily(columnFamily.getName(), bbKey);
        ColumnListMutation<?> clm = this.rowLookup.get(kacf);
        if (clm == null) {
            List innerMutationList;
            HashMap innerMutationMap = this.mutationMap.get(bbKey);
            if (innerMutationMap == null) {
                innerMutationMap = Maps.newHashMap();
                this.mutationMap.put(bbKey, innerMutationMap);
            }
            if ((innerMutationList = (List)innerMutationMap.get(columnFamily.getName())) == null) {
                innerMutationList = Lists.newArrayList();
                innerMutationMap.put(columnFamily.getName(), innerMutationList);
            }
            clm = new ThriftColumnFamilyMutationImpl(this.timestamp, innerMutationList, columnFamily.getColumnSerializer());
            this.rowLookup.put(kacf, clm);
        }
        return clm;
    }

    @Override
    public void discardMutations() {
        this.mutationMap.clear();
        this.rowLookup.clear();
    }

    @Override
    public <K> void deleteRow(Iterable<? extends ColumnFamily<K, ?>> columnFamilies, K rowKey) {
        for (ColumnFamily<K, ?> cf : columnFamilies) {
            this.withRow(cf, rowKey).delete();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mutationMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftMutationBatch[");
        boolean first = true;
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> row : this.mutationMap.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(Hex.encodeHex((byte[])row.getKey().array())).append("(");
            boolean first2 = true;
            for (Map.Entry<String, List<Mutation>> cf : row.getValue().entrySet()) {
                if (!first2) {
                    sb.append(",");
                }
                sb.append(cf.getKey()).append(":").append(cf.getValue().size());
                first2 = false;
            }
            first = false;
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ByteBuffer serialize() throws Exception {
        if (this.mutationMap.isEmpty()) {
            throw new Exception("Mutation is empty");
        }
        ByteBufferOutputStream out = new ByteBufferOutputStream();
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)out);
        Cassandra.batch_mutate_args args = new Cassandra.batch_mutate_args();
        args.setMutation_map(this.mutationMap);
        try {
            args.write((TProtocol)new TBinaryProtocol((TTransport)transport));
        }
        catch (TException e) {
            throw ThriftConverter.ToConnectionPoolException(e);
        }
        return out.getByteBuffer();
    }

    @Override
    public void deserialize(ByteBuffer data) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data.array());
        TIOStreamTransport transport = new TIOStreamTransport((InputStream)in);
        Cassandra.batch_mutate_args args = new Cassandra.batch_mutate_args();
        try {
            TBinaryProtocol bp = new TBinaryProtocol((TTransport)transport);
            bp.setReadLength(data.remaining());
            args.read((TProtocol)bp);
            this.mutationMap = args.getMutation_map();
        }
        catch (TException e) {
            throw ThriftConverter.ToConnectionPoolException(e);
        }
    }

    @Override
    public Map<ByteBuffer, Set<String>> getRowKeys() {
        return Maps.transformEntries(this.mutationMap, (Maps.EntryTransformer)new Maps.EntryTransformer<ByteBuffer, Map<String, List<Mutation>>, Set<String>>(){

            public Set<String> transformEntry(ByteBuffer key, Map<String, List<Mutation>> value) {
                return value.keySet();
            }
        });
    }

    public Map<ByteBuffer, Map<String, List<Mutation>>> getMutationMap() {
        return this.mutationMap;
    }

    @Override
    public void mergeShallow(MutationBatch other) {
        if (!(other instanceof AbstractThriftMutationBatchImpl)) {
            throw new UnsupportedOperationException();
        }
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> otherRow : ((AbstractThriftMutationBatchImpl)other).mutationMap.entrySet()) {
            Map<String, List<Mutation>> thisRow = this.mutationMap.get(otherRow.getKey());
            if (thisRow == null) {
                this.mutationMap.put(otherRow.getKey(), otherRow.getValue());
                continue;
            }
            for (Map.Entry<String, List<Mutation>> otherCf : otherRow.getValue().entrySet()) {
                List<Mutation> thisCf = thisRow.get(otherCf.getKey());
                if (thisCf == null) {
                    thisRow.put(otherCf.getKey(), otherCf.getValue());
                    continue;
                }
                thisCf.addAll((Collection<Mutation>)otherCf.getValue());
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.mutationMap.size();
    }

    @Override
    public MutationBatch setTimeout(long timeout) {
        return this;
    }

    @Override
    public MutationBatch setTimestamp(long timestamp) {
        this.clock = null;
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public MutationBatch withTimestamp(long timestamp) {
        this.clock = null;
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public MutationBatch lockCurrentTimestamp() {
        this.timestamp = this.clock.getCurrentTime();
        return this;
    }

    @Override
    public MutationBatch setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public MutationBatch withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public MutationBatch pinToHost(Host host) {
        this.pinnedHost = host;
        return this;
    }

    @Override
    public MutationBatch withRetryPolicy(RetryPolicy retry) {
        this.retry = retry;
        return this;
    }

    @Override
    public MutationBatch usingWriteAheadLog(WriteAheadLog manager) {
        this.wal = manager;
        return this;
    }

    public Host getPinnedHost() {
        return this.pinnedHost;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retry;
    }

    public WriteAheadLog getWriteAheadLog() {
        return this.wal;
    }

    private static class KeyAndColumnFamily {
        private final String columnFamily;
        private final ByteBuffer key;

        public KeyAndColumnFamily(String columnFamily, ByteBuffer key) {
            this.columnFamily = columnFamily;
            this.key = key;
        }

        public int compareTo(Object obj) {
            if (obj instanceof KeyAndColumnFamily) {
                KeyAndColumnFamily other = (KeyAndColumnFamily)obj;
                int result = this.columnFamily.compareTo(other.columnFamily);
                if (result == 0) {
                    result = this.key.compareTo(other.key);
                }
                return result;
            }
            return -1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.columnFamily == null ? 0 : this.columnFamily.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyAndColumnFamily other = (KeyAndColumnFamily)obj;
            if (this.columnFamily == null ? other.columnFamily != null : !this.columnFamily.equals(other.columnFamily)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

