/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.AbstractColumnListMutation;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnPath;
import com.netflix.astyanax.thrift.ThriftUtils;
import java.util.List;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;

public class ThriftSuperColumnMutationImpl<C>
extends AbstractColumnListMutation<C> {
    private final List<Mutation> mutationList;
    private final ColumnPath<C> path;
    private SuperColumn superColumn;
    private SlicePredicate deletionPredicate;

    public ThriftSuperColumnMutationImpl(long timestamp, List<Mutation> mutationList, ColumnPath<C> path) {
        super(timestamp);
        this.path = path;
        this.mutationList = mutationList;
    }

    @Override
    public <V> ColumnListMutation<C> putColumn(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        Column column = new Column();
        column.setName(this.path.getSerializer().toByteBuffer(columnName));
        column.setValue(valueSerializer.toByteBuffer(value));
        column.setTimestamp(this.timestamp);
        if (ttl != null) {
            column.setTtl(ttl.intValue());
        } else if (this.defaultTtl != null) {
            column.setTtl(this.defaultTtl.intValue());
        }
        this.addMutation(column);
        return this;
    }

    private void addMutation(Column column) {
        if (this.superColumn == null) {
            this.superColumn = new SuperColumn().setName(this.path.get(0));
            Mutation mutation = new Mutation();
            mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setSuper_column(this.superColumn));
            this.mutationList.add(mutation);
        }
        this.superColumn.addToColumns(column);
    }

    @Override
    public ColumnListMutation<C> putEmptyColumn(C columnName, Integer ttl) {
        Column column = new Column();
        column.setName(this.path.getSerializer().toByteBuffer(columnName));
        column.setValue(ThriftUtils.EMPTY_BYTE_BUFFER);
        column.setTimestamp(this.timestamp);
        if (ttl != null) {
            column.setTtl(ttl.intValue());
        } else if (this.defaultTtl != null) {
            column.setTtl(this.defaultTtl.intValue());
        }
        this.addMutation(column);
        return this;
    }

    @Override
    public ColumnListMutation<C> delete() {
        Deletion d = new Deletion();
        d.setSuper_column(this.path.get(0));
        d.setTimestamp(this.timestamp);
        this.mutationList.add(new Mutation().setDeletion(d));
        ++this.timestamp;
        return this;
    }

    @Override
    public <SC> ColumnListMutation<SC> withSuperColumn(ColumnPath<SC> superColumnPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnListMutation<C> incrementCounterColumn(C columnName, long amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnListMutation<C> deleteColumn(C columnName) {
        if (this.deletionPredicate == null) {
            this.deletionPredicate = new SlicePredicate();
            Deletion d = new Deletion();
            d.setTimestamp(this.timestamp);
            d.setSuper_column(this.path.get(0));
            d.setPredicate(this.deletionPredicate);
            this.mutationList.add(new Mutation().setDeletion(d));
        }
        this.deletionPredicate.addToColumn_names(this.path.getSerializer().toByteBuffer(columnName));
        return this;
    }

    @Override
    public ColumnListMutation<C> putCompressedColumn(C columnName, String value, Integer ttl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnListMutation<C> putCompressedColumn(C columnName, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value, Integer ttl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value) {
        throw new UnsupportedOperationException();
    }
}

