/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnImpl;
import com.netflix.astyanax.model.ColumnList;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.CounterColumn;

public class ThriftCounterColumnImpl<C>
extends AbstractColumnImpl<C> {
    private final CounterColumn column;

    public ThriftCounterColumnImpl(C name, CounterColumn column) {
        super(name);
        this.column = column;
    }

    @Override
    public <V> V getValue(Serializer<V> valSer) {
        throw new UnsupportedOperationException("CounterColumn '" + this.getName() + "' has no generic value. Call getLongValue().");
    }

    @Override
    public long getLongValue() {
        return this.column.getValue();
    }

    @Override
    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        throw new UnsupportedOperationException("CounterColumn '" + this.getName() + "' has no sub columns. Call getLongValue().");
    }

    @Override
    public boolean isParentColumn() {
        return false;
    }

    @Override
    public long getTimestamp() {
        throw new UnsupportedOperationException("CounterColumn '" + this.getName() + "' has no timestamp");
    }

    @Override
    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.column.getName());
    }

    @Override
    public int getTtl() {
        return 0;
    }

    @Override
    public boolean hasValue() {
        return true;
    }
}

