/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.metadata;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class ElementMetadata
extends RRElement {
    public static final String KeyValueDelimiter = "#@emd@#";
    private ElementMetadataDao item = new ElementMetadataDao();
    private RRContext context = ResourceRegistry.getContext();
    private Map<String, String> properties = null;

    public ElementMetadata() throws ResourceRegistryException {
        this.item.setID(UUID.randomUUID().toString());
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public Type getType() {
        return Type.valueOf(this.item.getType());
    }

    public void setType(Type type) {
        this.item.setType(type.toString());
    }

    public long getMetadataTimestamp() {
        return this.item.getMetadataTimestamp();
    }

    public void setMetadataTimestamp(long timestamp) {
        this.item.setMetadataTimestamp(timestamp);
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.buildProperties();
        }
        return this.properties;
    }

    public ElementMetadataDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    private void buildProperties() {
        this.properties = new HashMap<String, String>();
        block0: for (String k : this.item.getPropertyKeys()) {
            if (this.properties.containsKey(k)) continue;
            for (String v : this.item.getPropertyValues()) {
                String[] keyVal = v.split(KeyValueDelimiter);
                if (keyVal.length != 2 || !keyVal[0].trim().equals(k)) continue;
                this.properties.put(k, keyVal[1]);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(ElementMetadataDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return false;
        }
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        try {
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    ElementMetadata retrieved = (ElementMetadata)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, true, RRContext.DatastoreType.LOCAL, false);
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = this.getISContext().getManagerForRead(persistencyType);
            sharedLock.lock();
            locked = true;
            pm.currentTransaction().begin();
            this.item = (ElementMetadataDao)pm.detachCopy(pm.getObjectById(ElementMetadataDao.class, (Object)this.item.getID()));
            pm.currentTransaction().commit();
            sharedLock.unlock();
            locked = false;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return true;
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            ElementMetadata item = new ElementMetadata();
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, storeDetails, persistencyType, true);
        } else {
            PersistenceManager pm = null;
            Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
            boolean locked = false;
            try {
                this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
                this.apply((IRRElement)this, storeDetails, persistencyType, false);
                if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                    InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
                }
                pm = this.getISContext().getManagerForWrite(persistencyType);
                sharedLock.lock();
                locked = true;
                pm.currentTransaction().begin();
                this.item = (ElementMetadataDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                sharedLock.unlock();
                locked = false;
                pm.flush();
            }
            finally {
                if (pm != null && pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                if (pm != null) {
                    pm.close();
                }
                if (locked) {
                    sharedLock.unlock();
                }
            }
        }
    }

    protected void apply(IRRElement target, boolean applyDetails, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof ElementMetadata)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setID(((ElementMetadata)target).item.getID());
        this.item.setType(((ElementMetadata)target).item.getType());
        this.item.setMetadataTimestamp(((ElementMetadata)target).item.getMetadataTimestamp());
        this.item.getPropertyKeys().clear();
        this.item.getPropertyValues().clear();
        for (Map.Entry<String, String> prop : ((ElementMetadata)target).getProperties().entrySet()) {
            this.item.getPropertyKeys().add(prop.getKey());
            this.item.getPropertyValues().add(prop.getKey() + KeyValueDelimiter + prop.getValue());
        }
        if (doStore) {
            this.store(applyDetails, persistencyType, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return;
        }
        if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
            InMemoryStore.removeItem(((Object)((Object)this)).getClass(), (String)this.getID());
        }
        ElementMetadata s = new ElementMetadata();
        s.setID(this.getID());
        s.load(deleteDetails, persistencyType, true);
        PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
        try {
            pm.currentTransaction().begin();
            pm.deletePersistent((Object)s.item);
            pm.currentTransaction().commit();
            pm.flush();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof ElementMetadata)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((ElementMetadata)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((ElementMetadata)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((ElementMetadata)target).item.getID() != null && !this.item.getID().equals(((ElementMetadata)target).item.getID())) {
            return false;
        }
        if (this.item.getType() == null && ((ElementMetadata)target).item.getType() != null) {
            return false;
        }
        if (this.item.getType() != null && ((ElementMetadata)target).item.getType() == null) {
            return false;
        }
        if (this.item.getType() != null && ((ElementMetadata)target).item.getType() != null && !this.item.getID().equals(((ElementMetadata)target).item.getType())) {
            return false;
        }
        if (this.item.getMetadataTimestamp() != ((ElementMetadata)target).item.getMetadataTimestamp()) {
            return false;
        }
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            if (!((ElementMetadata)target).getProperties().containsKey(property.getKey())) {
                return false;
            }
            if (((ElementMetadata)target).getProperties().get(property).equals(property.getValue())) continue;
            return false;
        }
        return true;
    }

    public RRContext getISContext() {
        return this.context;
    }

    public static ElementMetadata getById(boolean loadDetails, RRContext.DatastoreType persistencyType, String id) throws ResourceRegistryException {
        ElementMetadata s = new ElementMetadata();
        s.setID(id);
        if (!s.load(loadDetails, persistencyType)) {
            return null;
        }
        return s;
    }

    public static ElementMetadata getById(boolean loadDetails, String id) throws ResourceRegistryException {
        return ElementMetadata.getById(loadDetails, RRContext.DatastoreType.LOCAL, id);
    }

    public static List<ElementMetadata> getDeletedFieldsMetadata(boolean loadDetails) throws ResourceRegistryException {
        return ElementMetadata.getMetadataByType(loadDetails, Type.FieldRecentDeletion);
    }

    public static List<ElementMetadata> getUpdatedFieldsMetadata(boolean loadDetails) throws ResourceRegistryException {
        return ElementMetadata.getMetadataByType(loadDetails, Type.FieldRecentUpdate);
    }

    public static List<ElementMetadata> getDeletedSearchablesMetadata(boolean loadDetails) throws ResourceRegistryException {
        return ElementMetadata.getMetadataByType(loadDetails, Type.DeletedSearchable);
    }

    public static List<ElementMetadata> getDeletedPresentablesMetadata(boolean loadDetails) throws ResourceRegistryException {
        return ElementMetadata.getMetadataByType(loadDetails, Type.DeletedPresentable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ElementMetadata> getMetadataByType(boolean loadDetails, Type type) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(ElementMetadataDao.class, "metadataOfType");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("type", type.toString());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            sharedLock.unlock();
            locked = false;
            ArrayList<ElementMetadata> col = new ArrayList<ElementMetadata>();
            for (String item : res) {
                ElementMetadata m = new ElementMetadata();
                m.setID(item);
                m.load(loadDetails);
                col.add(m);
            }
            ArrayList<ElementMetadata> arrayList = col;
            return arrayList;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static enum Type {
        DataSource,
        DeletedField,
        FieldRecentDeletion,
        FieldRecentUpdate,
        DeletedSearchable,
        DeletedPresentable;

    }
}

