/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.replace;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public String toString() {
        String sql = "REPLACE " + this.table;
        if (this.expressions != null && this.columns != null) {
            sql = sql + " SET ";
            int s = this.columns.size();
            for (int i = 0; i < s; ++i) {
                sql = sql + "" + this.columns.get(i) + "=" + this.expressions.get(i);
                sql = sql + (i < s - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            sql = sql + " " + PlainSelect.getStringList(this.columns, true, true);
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                sql = sql + " VALUES";
            }
            sql = sql + " " + this.itemsList;
        }
        return sql;
    }
}

