/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IDiskAtomFilter {
    private static final Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public static final int IGNORE_TOMBSTONED_PARTITIONS = -2;
    public final ColumnSlice[] slices;
    public final boolean reversed;
    public volatile int count;
    public final int compositesToGroup;
    private ColumnCounter columnCounter;

    public SliceQueryFilter(Composite start, Composite finish, boolean reversed, int count) {
        this(new ColumnSlice(start, finish), reversed, count);
    }

    public SliceQueryFilter(Composite start, Composite finish, boolean reversed, int count, int compositesToGroup) {
        this(new ColumnSlice(start, finish), reversed, count, compositesToGroup);
    }

    public SliceQueryFilter(ColumnSlice slice, boolean reversed, int count) {
        this(new ColumnSlice[]{slice}, reversed, count);
    }

    public SliceQueryFilter(ColumnSlice slice, boolean reversed, int count, int compositesToGroup) {
        this(new ColumnSlice[]{slice}, reversed, count, compositesToGroup);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count) {
        this(slices, reversed, count, -1);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count, int compositesToGroup) {
        this.slices = slices;
        this.reversed = reversed;
        this.count = count;
        this.compositesToGroup = compositesToGroup;
    }

    @Override
    public SliceQueryFilter cloneShallow() {
        return new SliceQueryFilter(this.slices, this.reversed, this.count, this.compositesToGroup);
    }

    public SliceQueryFilter withUpdatedCount(int newCount) {
        return new SliceQueryFilter(this.slices, this.reversed, newCount, this.compositesToGroup);
    }

    public SliceQueryFilter withUpdatedSlices(ColumnSlice[] newSlices) {
        return new SliceQueryFilter(newSlices, this.reversed, this.count, this.compositesToGroup);
    }

    private boolean sliceIncludesStatics(ColumnSlice slice, CFMetaData cfm) {
        return cfm.hasStaticColumns() && slice.includes(this.reversed ? cfm.comparator.reverseComparator() : cfm.comparator, cfm.comparator.staticPrefix().end());
    }

    public boolean hasStaticSlice(CFMetaData cfm) {
        for (ColumnSlice slice : this.slices) {
            if (!this.sliceIncludesStatics(slice, cfm)) continue;
            return true;
        }
        return false;
    }

    public Pair<SliceQueryFilter, SliceQueryFilter> splitOutStaticSlice(CFMetaData cfm) {
        assert (this.reversed);
        Composite staticSliceEnd = cfm.comparator.staticPrefix().end();
        ArrayList<ColumnSlice> nonStaticSlices = new ArrayList<ColumnSlice>(this.slices.length);
        for (ColumnSlice slice : this.slices) {
            if (this.sliceIncludesStatics(slice, cfm)) {
                nonStaticSlices.add(new ColumnSlice(slice.start, staticSliceEnd));
                continue;
            }
            nonStaticSlices.add(slice);
        }
        return Pair.create(new SliceQueryFilter(staticSliceEnd, Composites.EMPTY, true, this.count, this.compositesToGroup), new SliceQueryFilter(nonStaticSlices.toArray(new ColumnSlice[nonStaticSlices.size()]), true, this.count, this.compositesToGroup));
    }

    public SliceQueryFilter withUpdatedStart(Composite newStart, CFMetaData cfm) {
        Comparator<Composite> cmp = this.reversed ? cfm.comparator.reverseComparator() : cfm.comparator;
        ArrayList<ColumnSlice> newSlices = new ArrayList<ColumnSlice>();
        boolean pastNewStart = false;
        for (ColumnSlice slice : this.slices) {
            if (pastNewStart) {
                newSlices.add(slice);
                continue;
            }
            if (slice.isBefore(cmp, newStart)) {
                if (this.reversed || !this.sliceIncludesStatics(slice, cfm)) continue;
                newSlices.add(new ColumnSlice(Composites.EMPTY, cfm.comparator.staticPrefix().end()));
                continue;
            }
            if (slice.includes(cmp, newStart)) {
                if (!this.reversed && this.sliceIncludesStatics(slice, cfm) && !newStart.isEmpty()) {
                    newSlices.add(new ColumnSlice(Composites.EMPTY, cfm.comparator.staticPrefix().end()));
                }
                newSlices.add(new ColumnSlice(newStart, slice.finish));
            } else {
                newSlices.add(slice);
            }
            pastNewStart = true;
        }
        return this.withUpdatedSlices(newSlices.toArray(new ColumnSlice[newSlices.size()]));
    }

    @Override
    public Iterator<Cell> getColumnIterator(ColumnFamily cf) {
        assert (cf != null);
        return this.reversed ? cf.reverseIterator(this.slices) : cf.iterator(this.slices);
    }

    @Override
    public OnDiskAtomIterator getColumnIterator(final DecoratedKey key, final ColumnFamily cf) {
        assert (cf != null);
        final Iterator<Cell> iter = this.getColumnIterator(cf);
        return new OnDiskAtomIterator(){

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public OnDiskAtom next() {
                return (OnDiskAtom)iter.next();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return sstable.iterator(key, this.slices, this.reversed);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return sstable.iterator(file, key, this.slices, this.reversed, indexEntry);
    }

    @Override
    public Comparator<Cell> getColumnComparator(CellNameType comparator) {
        return this.reversed ? comparator.columnReverseComparator() : comparator.columnComparator(false);
    }

    @Override
    public void collectReducedColumns(ColumnFamily container, Iterator<Cell> reducedColumns, DecoratedKey key, int gcBefore, long now) {
        boolean warnTombstones;
        this.columnCounter = this.columnCounter(container.getComparator(), now);
        DeletionInfo.InOrderTester tester = container.deletionInfo().inOrderTester(this.reversed);
        while (reducedColumns.hasNext()) {
            Cell cell = reducedColumns.next();
            if (logger.isTraceEnabled()) {
                logger.trace("collecting {} of {}: {}", new Object[]{this.columnCounter.live(), this.count, cell.getString(container.getComparator())});
            }
            if (cell.getLocalDeletionTime() < gcBefore || !this.columnCounter.count(cell, tester)) continue;
            if (this.columnCounter.live() > this.count) break;
            if (this.respectTombstoneThresholds() && this.columnCounter.tombstones() > DatabaseDescriptor.getTombstoneFailureThreshold()) {
                Tracing.trace("Scanned over {} tombstones; query aborted (see tombstone_failure_threshold); slices={}", (Object)DatabaseDescriptor.getTombstoneFailureThreshold(), (Object)this.getSlicesInfo(container));
                throw new TombstoneOverwhelmingException(this.columnCounter.tombstones(), this.count, container.metadata().ksName, container.metadata().cfName, container.getComparator().getString(cell.name()), this.getSlicesInfo(container));
            }
            container.appendColumn(cell);
        }
        boolean bl = warnTombstones = logger.isWarnEnabled() && this.respectTombstoneThresholds() && this.columnCounter.tombstones() > DatabaseDescriptor.getTombstoneWarnThreshold();
        if (warnTombstones) {
            String msg = String.format("Read %d live and %d tombstone cells in %s.%s for key: %1.512s (see tombstone_warn_threshold). %d columns were requested, slices=%1.512s", this.columnCounter.live(), this.columnCounter.tombstones(), container.metadata().ksName, container.metadata().cfName, container.metadata().getKeyValidator().getString(key.getKey()), this.count, this.getSlicesInfo(container));
            ClientWarn.instance.warn(msg);
            logger.warn(msg);
        }
        Tracing.trace("Read {} live and {} tombstone cells{}", this.columnCounter.live(), this.columnCounter.tombstones(), warnTombstones ? " (see tombstone_warn_threshold)" : "");
    }

    private String getSlicesInfo(ColumnFamily container) {
        StringBuilder sb = new StringBuilder();
        CellNameType type = container.metadata().comparator;
        for (ColumnSlice sl : this.slices) {
            assert (sl != null);
            sb.append('[');
            sb.append(type.getString(sl.start));
            sb.append('-');
            sb.append(type.getString(sl.finish));
            sb.append(']');
        }
        return sb.toString();
    }

    protected boolean respectTombstoneThresholds() {
        return true;
    }

    @Override
    public int getLiveCount(ColumnFamily cf, long now) {
        return this.columnCounter(cf.getComparator(), now).countAll(cf).live();
    }

    @Override
    public ColumnCounter columnCounter(CellNameType comparator, long now) {
        if (this.compositesToGroup < 0) {
            return new ColumnCounter(now);
        }
        if (this.compositesToGroup == 0) {
            return new ColumnCounter.GroupByPrefix(now, null, 0);
        }
        if (this.reversed) {
            return new ColumnCounter.GroupByPrefixReversed(now, comparator, this.compositesToGroup);
        }
        return new ColumnCounter.GroupByPrefix(now, comparator, this.compositesToGroup);
    }

    public ColumnFamily trim(ColumnFamily cf, int trimTo, long now) {
        if (cf.getColumnCount() < trimTo) {
            return cf;
        }
        ColumnCounter counter = this.columnCounter(cf.getComparator(), now);
        Object trimmedCf = cf.getFactory().create(cf.metadata(), this.reversed, trimTo);
        ((ColumnFamily)trimmedCf).delete(cf);
        Collection<Cell> cells = this.reversed ? cf.getReverseSortedColumns() : cf.getSortedColumns();
        DeletionInfo.InOrderTester tester = cf.deletionInfo().inOrderTester(this.reversed);
        for (Cell cell : cells) {
            counter.count(cell, tester);
            if (counter.live() > trimTo) break;
            ((ColumnFamily)trimmedCf).addColumn(cell);
        }
        return trimmedCf;
    }

    public Composite start() {
        return this.slices[0].start;
    }

    public Composite finish() {
        return this.slices[this.slices.length - 1].finish;
    }

    public void setStart(Composite start) {
        assert (this.slices.length == 1);
        this.slices[0] = new ColumnSlice(start, this.slices[0].finish);
    }

    public int lastCounted() {
        return this.columnCounter == null ? 0 : Math.min(this.columnCounter.live(), this.count);
    }

    public int lastTombstones() {
        return this.columnCounter == null ? 0 : this.columnCounter.tombstones();
    }

    public int lastLive() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public String toString() {
        return "SliceQueryFilter [reversed=" + this.reversed + ", slices=" + Arrays.toString(this.slices) + ", count=" + this.count + ", toGroup = " + this.compositesToGroup + "]";
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
        this.count = newLimit;
    }

    @Override
    public boolean maySelectPrefix(CType type, Composite prefix) {
        for (ColumnSlice slice : this.slices) {
            if (!slice.includes(type, prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        List<ByteBuffer> minColumnNames = sstable.getSSTableMetadata().minColumnNames;
        List<ByteBuffer> maxColumnNames = sstable.getSSTableMetadata().maxColumnNames;
        CellNameType comparator = sstable.metadata.comparator;
        if (minColumnNames.isEmpty() || maxColumnNames.isEmpty()) {
            return true;
        }
        for (ColumnSlice slice : this.slices) {
            if (!slice.intersects(minColumnNames, maxColumnNames, comparator, this.reversed)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHeadFilter() {
        return this.slices.length == 1 && this.slices[0].start.isEmpty() && !this.reversed;
    }

    @Override
    public boolean countCQL3Rows(CellNameType comparator) {
        return comparator.isDense() || this.compositesToGroup >= 0;
    }

    @Override
    public boolean isFullyCoveredBy(ColumnFamily cf, long now) {
        if (this.isHeadFilter() && this.count <= this.getLiveCount(cf, now)) {
            return true;
        }
        if (this.start().isEmpty() || this.finish().isEmpty() || !cf.hasColumns()) {
            return false;
        }
        Composite low = this.isReversed() ? this.finish() : this.start();
        Composite high = this.isReversed() ? this.start() : this.finish();
        CellName first = cf.iterator(ColumnSlice.ALL_COLUMNS_ARRAY).next().name();
        CellName last = cf.reverseIterator(ColumnSlice.ALL_COLUMNS_ARRAY).next().name();
        return cf.getComparator().compare(first, low) <= 0 && cf.getComparator().compare(high, last) <= 0;
    }

    @Override
    public Iterator<RangeTombstone> getRangeTombstoneIterator(ColumnFamily source) {
        final DeletionInfo delInfo = source.deletionInfo();
        if (!delInfo.hasRanges() || this.slices.length == 0) {
            return Iterators.emptyIterator();
        }
        return new AbstractIterator<RangeTombstone>(){
            private int sliceIdx = 0;
            private Iterator<RangeTombstone> sliceIter = this.currentRangeIter();

            protected RangeTombstone computeNext() {
                while (!this.sliceIter.hasNext()) {
                    if (!this.nextSlice()) {
                        return (RangeTombstone)this.endOfData();
                    }
                    this.sliceIter = this.currentRangeIter();
                }
                return this.sliceIter.next();
            }

            private Iterator<RangeTombstone> currentRangeIter() {
                ColumnSlice slice = SliceQueryFilter.this.slices[SliceQueryFilter.this.reversed ? SliceQueryFilter.this.slices.length - 1 - this.sliceIdx : this.sliceIdx];
                return SliceQueryFilter.this.reversed ? delInfo.rangeIterator(slice.finish, slice.start) : delInfo.rangeIterator(slice.start, slice.finish);
            }

            private boolean nextSlice() {
                return ++this.sliceIdx < SliceQueryFilter.this.slices.length;
            }
        };
    }

    public static class Serializer
    implements IVersionedSerializer<SliceQueryFilter> {
        private CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serialize(SliceQueryFilter f, DataOutputPlus out, int version) throws IOException {
            out.writeInt(f.slices.length);
            for (ColumnSlice slice : f.slices) {
                this.type.sliceSerializer().serialize(slice, out, version);
            }
            out.writeBoolean(f.reversed);
            int count = f.count;
            out.writeInt(count);
            out.writeInt(f.compositesToGroup);
        }

        @Override
        public SliceQueryFilter deserialize(DataInput in, int version) throws IOException {
            ColumnSlice[] slices = new ColumnSlice[in.readInt()];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = this.type.sliceSerializer().deserialize(in, version);
            }
            boolean reversed = in.readBoolean();
            int count = in.readInt();
            int compositesToGroup = in.readInt();
            return new SliceQueryFilter(slices, reversed, count, compositesToGroup);
        }

        @Override
        public long serializedSize(SliceQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = 0;
            size += sizes.sizeof(f.slices.length);
            for (ColumnSlice slice : f.slices) {
                size = (int)((long)size + this.type.sliceSerializer().serializedSize(slice, version));
            }
            size += sizes.sizeof(f.reversed);
            size += sizes.sizeof(f.count);
            return size += sizes.sizeof(f.compositesToGroup);
        }
    }
}

