/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import com.ecyrd.jspwiki.util.HttpUtil;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class CookieAssertionLoginModule
extends AbstractLoginModule {
    public static final String PREFS_COOKIE_NAME = "JSPWikiAssertedName";
    public static final String PROMPT = "User name";
    protected static final Logger log = Logger.getLogger(CookieAssertionLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            String name;
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            HttpSession session = request == null ? null : request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            String string = name = request != null ? CookieAssertionLoginModule.getUserCookie(request) : null;
            if (name == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No cookie JSPWikiAssertedName present in session ID=:  " + sid));
                }
                throw new FailedLoginException("The user cookie was not found.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Logged in session ID=" + sid + "; asserted=" + name));
            }
            this.m_principals.add(new WikiPrincipal(name, "fullName"));
            return true;
        }
        catch (IOException e) {
            log.error((Object)("IOException: " + e.getMessage()));
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
    }

    public static String getUserCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue(request, PREFS_COOKIE_NAME);
        return TextUtil.urlDecodeUTF8(cookie);
    }

    public static void setUserCookie(HttpServletResponse response, String name) {
        name = TextUtil.urlEncodeUTF8(name);
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, name);
        userId.setMaxAge(86486400);
        response.addCookie(userId);
    }

    public static void clearUserCookie(HttpServletResponse response) {
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
    }
}

