/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResourceDestination
extends Resource {
    public RemoteResourceDestination(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public String to(String path) throws RemoteBackendException {
        this.logger.info("file gCube parameter before: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        String bucketName = null;
        this.logger.info("file gCube parameter after: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        try {
            if (this.file.getLocalPath() != null && this.file.getRemotePath() != null) {
                bucketName = (String)this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, this.engine.primaryBackend, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception t) {
            this.logger.error("get()", t.getCause());
            t.printStackTrace();
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        return bucketName;
    }
}

