/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.Encrypter;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class GetHttpsUrl
extends Operation {
    private OutputStream os;
    TransportManager tm;
    public static final String URL_SEPARATOR = "/";

    public GetHttpsUrl(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        return this.getRemoteIdentifier(remotePath, rootArea);
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }

    @Override
    public Object doIt(MyFile myFile) throws RemoteBackendException {
        String resolverHost = myFile.getResolverHOst();
        String urlBase = "smp://" + resolverHost + URL_SEPARATOR;
        String urlParam = "";
        try {
            String id = this.getId(myFile.getAbsoluteRemotePath(), myFile.isForceCreation(), myFile.getGcubeMemoryType());
            String phrase = myFile.getPassPhrase();
            urlParam = new Encrypter("DES", phrase).encrypt(id);
        }
        catch (Encrypter.EncryptionException e) {
            throw new RemoteBackendException(" Error in getUrl operation problem to encrypt the string", e.getCause());
        }
        this.logger.info("URL generated: " + urlBase + urlParam);
        String smpUrl = urlBase + urlParam;
        this.logger.info("URL generated: " + smpUrl);
        smpUrl = smpUrl.replace("smp://", "https://");
        URL httpsUrl = null;
        try {
            httpsUrl = this.translate(new URL(smpUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info("URL translated: " + httpsUrl);
        return httpsUrl.toString();
    }

    private String getId(String path, boolean forceCreation, MemoryType memoryType) {
        String id = null;
        if (this.tm == null) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            this.tm = tmf.getTransport(this.backendType, memoryType);
        }
        try {
            id = this.tm.getId(this.bucket, forceCreation);
        }
        catch (Exception e) {
            this.tm.close();
            throw new RemoteBackendException(" Error in GetUrl operation. Problem to discover remote file:" + this.bucket + " " + e.getMessage(), e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        return id;
    }

    private URL translate(URL url) throws IOException {
        this.logger.debug("translating: " + url);
        String urlString = url.toString();
        String baseUrl = "https://" + url.getHost() + URL_SEPARATOR;
        this.logger.debug("base Url extracted is: " + baseUrl);
        String params = urlString.substring(baseUrl.length());
        this.logger.debug("get params: " + baseUrl + " " + params);
        params = Base64.encodeBase64URLSafeString((byte[])params.getBytes("UTF-8"));
        urlString = baseUrl + params;
        this.logger.info("uri translated in https url: " + urlString);
        return new URL(urlString);
    }
}

