/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.migrate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.migrate.MigrationException;
import org.jamwiki.migrate.TopicImporter;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiXmlImporter
extends DefaultHandler
implements TopicImporter {
    private static final WikiLogger logger = WikiLogger.getLogger(MediaWikiXmlImporter.class.getName());
    private Map<String, String> currentAttributeMap = new HashMap<String, String>();
    private StringBuilder currentElementBuffer = new StringBuilder();
    private Topic currentTopic = null;
    private TopicVersion currentTopicVersion = new TopicVersion();
    private Map<Date, Integer> currentTopicVersions = new TreeMap<Date, Integer>();
    private final Map<String, String> mediawikiNamespaceMap = new HashMap<String, String>();
    private Map<Topic, List<Integer>> parsedTopics = new HashMap<Topic, List<Integer>>();
    private int previousTopicContentLength = 0;
    private String virtualWiki;

    @Override
    public Map<Topic, List<Integer>> importFromFile(File file, String virtualWiki) throws MigrationException {
        this.virtualWiki = virtualWiki;
        this.importWikiXml(file);
        return this.parsedTopics;
    }

    private void importWikiXml(File file) throws MigrationException {
        System.setProperty("entityExpansionLimit", "1000000");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)fis, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new MigrationException(e);
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
        catch (SAXException e) {
            if (e.getCause() instanceof DataAccessException || e.getCause() instanceof WikiException) {
                throw new MigrationException(e.getCause());
            }
            throw new MigrationException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private String convertArticleNameFromWikipediaToJAMWiki(String fullName) {
        String ret = fullName;
        int pos = fullName.indexOf(":");
        if (pos > 0) {
            String namespace = fullName.substring(0, pos);
            String title = fullName.substring(pos + 1);
            String jamwikiNamespace = this.mediawikiNamespaceMap.get(namespace);
            if (!StringUtils.isBlank((String)jamwikiNamespace)) {
                ret = jamwikiNamespace + ":" + title;
            }
        }
        ret = StringUtils.remove((String)ret, (char)'?');
        return ret;
    }

    private void convertToJAMWikiNamespaces(StringBuilder builder) {
        for (String mediawikiNamespace : this.mediawikiNamespaceMap.keySet()) {
            String jamwikiNamespace = this.mediawikiNamespaceMap.get(mediawikiNamespace);
            if (jamwikiNamespace == null || StringUtils.equalsIgnoreCase((String)jamwikiNamespace, (String)mediawikiNamespace)) continue;
            String wikiLinkPatternString = "(\\[\\[[ ]*(:)?)" + mediawikiNamespace + ":";
            this.replaceNamespace(builder, jamwikiNamespace, wikiLinkPatternString);
            String templatePatternString = "(\\{\\{[ ]*(:)?)" + mediawikiNamespace + ":";
            this.replaceNamespace(builder, jamwikiNamespace, templatePatternString);
        }
    }

    private void replaceNamespace(StringBuilder builder, String jamwikiNamespace, String patternString) {
        Pattern mediawikiPattern = Pattern.compile(patternString, 66);
        Matcher matcher = mediawikiPattern.matcher(builder);
        while (matcher.find()) {
            String replacement = matcher.group(1) + jamwikiNamespace + ":";
            builder.replace(0, builder.length(), matcher.replaceFirst(replacement));
            matcher.reset(builder);
        }
    }

    private Timestamp parseMediaWikiTimestamp(String timestamp) {
        try {
            Date date = DateUtils.parseDate((String)timestamp, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'"});
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            return new Timestamp(System.currentTimeMillis());
        }
    }

    private void initCurrentTopic(String topicName) throws SAXException {
        topicName = this.convertArticleNameFromWikipediaToJAMWiki(topicName);
        WikiLink wikiLink = LinkUtil.parseWikiLink(this.virtualWiki, topicName);
        Topic existingTopic = null;
        try {
            existingTopic = WikiBase.getDataHandler().lookupTopic(this.virtualWiki, topicName, false, null);
        }
        catch (DataAccessException e) {
            throw new SAXException("Failure while validating topic name: " + topicName, e);
        }
        if (existingTopic != null && existingTopic.getVirtualWiki().equals(this.virtualWiki)) {
            String importTopicName;
            String existingTopicName = Environment.getBooleanValue("allow-capitalization") ? StringUtils.capitalize((String)existingTopic.getPageName()) : existingTopic.getPageName();
            String string = importTopicName = Environment.getBooleanValue("allow-capitalization") ? StringUtils.capitalize((String)wikiLink.getArticle()) : wikiLink.getArticle();
            if (StringUtils.equals((String)existingTopicName, (String)importTopicName)) {
                WikiException e = new WikiException(new WikiMessage("import.error.topicexists", topicName));
                throw new SAXException("Topic " + topicName + " already exists and cannot be imported", e);
            }
        }
        this.currentTopic = new Topic(this.virtualWiki, topicName);
        this.currentTopic.setTopicType(WikiUtil.findTopicTypeForNamespace(wikiLink.getNamespace()));
    }

    private void commitTopicVersion() throws SAXException {
        this.currentTopic.setTopicContent(this.currentTopicVersion.getVersionContent());
        this.currentTopicVersion.setLoggable(false);
        this.currentTopicVersion.setRecentChangeAllowed(false);
        try {
            if (this.currentTopic.getTopicId() <= 0) {
                WikiBase.getDataHandler().writeTopic(this.currentTopic, this.currentTopicVersion, null, null);
            } else {
                WikiBase.getDataHandler().writeTopicVersion(this.currentTopic, this.currentTopicVersion);
            }
        }
        catch (DataAccessException e) {
            throw new SAXException("Failure while writing topic: " + this.currentTopic.getName(), e);
        }
        catch (WikiException e) {
            throw new SAXException("Failure while writing topic: " + this.currentTopic.getName(), e);
        }
        this.currentTopicVersions.put(this.currentTopicVersion.getEditDate(), this.currentTopicVersion.getTopicVersionId());
    }

    private void orderTopicVersions() throws SAXException {
        if (this.currentTopicVersions.isEmpty()) {
            throw new SAXException("No topic versions found for " + this.currentTopic.getName());
        }
        ArrayList<Integer> currentTopicVersionIdList = new ArrayList<Integer>(this.currentTopicVersions.values());
        try {
            WikiBase.getDataHandler().orderTopicVersions(this.currentTopic, currentTopicVersionIdList);
        }
        catch (DataAccessException e) {
            throw new SAXException("Failure while ordering topic versions for topic: " + this.currentTopic.getName(), e);
        }
        this.parsedTopics.put(this.currentTopic, currentTopicVersionIdList);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.currentElementBuffer = new StringBuilder();
        this.currentAttributeMap = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                if (StringUtils.isBlank((String)key)) continue;
                this.currentAttributeMap.put(key, attrs.getValue(i));
            }
        }
        if ("revision".equals(qName)) {
            this.currentTopicVersion = new TopicVersion();
            this.currentTopicVersion.setEditType(8);
        } else if ("page".equals(qName)) {
            this.currentTopicVersions = new TreeMap<Date, Integer>();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (StringUtils.equals((String)"namespace", (String)qName)) {
            int key = NumberUtils.toInt((String)this.currentAttributeMap.get("key"));
            try {
                Namespace jamwikiNamespace = WikiBase.getDataHandler().lookupNamespaceById(key);
                if (jamwikiNamespace == null) return;
                String mediawikiNamespace = this.currentElementBuffer.toString().trim();
                this.mediawikiNamespaceMap.put(mediawikiNamespace, jamwikiNamespace.getLabel(this.virtualWiki));
                return;
            }
            catch (DataAccessException e) {
                throw new SAXException("Failure while processing namespace with ID: " + key, e);
            }
        } else if ("title".equals(qName)) {
            String topicName = this.currentElementBuffer.toString().trim();
            this.initCurrentTopic(topicName);
            return;
        } else if ("text".equals(qName)) {
            this.convertToJAMWikiNamespaces(this.currentElementBuffer);
            String topicContent = this.currentElementBuffer.toString().trim();
            this.currentTopicVersion.setVersionContent(topicContent);
            this.currentTopicVersion.setCharactersChanged(StringUtils.length((String)topicContent) - this.previousTopicContentLength);
            this.previousTopicContentLength = StringUtils.length((String)topicContent);
            return;
        } else if ("comment".equals(qName)) {
            this.currentTopicVersion.setEditComment(this.currentElementBuffer.toString().trim());
            return;
        } else if ("timestamp".equals(qName)) {
            this.currentTopicVersion.setEditDate(this.parseMediaWikiTimestamp(this.currentElementBuffer.toString().trim()));
            return;
        } else if ("ip".equals(qName) || "username".equals(qName)) {
            String authorDisplay = this.currentElementBuffer.toString().trim();
            if (authorDisplay.length() > 100) {
                authorDisplay = authorDisplay.substring(0, 100);
            }
            this.currentTopicVersion.setAuthorDisplay(authorDisplay);
            return;
        } else if ("revision".equals(qName)) {
            this.commitTopicVersion();
            return;
        } else {
            if (!"page".equals(qName)) return;
            this.orderTopicVersions();
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentElementBuffer.append(buf, offset, len);
    }
}

